/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.graph.degree;

import java.util.BitSet;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.DirectedGraphVar;
import org.chocosolver.solver.variables.GraphVar;
import org.chocosolver.solver.variables.IncidentSet;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.UndirectedGraphVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.graphs.Orientation;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.tools.ArrayUtils;

public class PropNodeDegreeVar
extends Propagator<Variable> {
    private final int n;
    private final GraphVar g;
    private final IntVar[] degrees;
    private final IncidentSet target;
    private BitSet toDo;

    public PropNodeDegreeVar(DirectedGraphVar graph, Orientation setType, IntVar[] degrees2) {
        super(ArrayUtils.append(degrees2, {graph}), (Priority)PropagatorPriority.BINARY, false);
        this.g = graph;
        this.n = this.g.getNbMaxNodes();
        this.degrees = degrees2;
        this.target = setType == Orientation.PREDECESSORS ? new IncidentSet.PredecessorsSet() : new IncidentSet.SuccessorsSet();
    }

    public PropNodeDegreeVar(UndirectedGraphVar graph, IntVar[] degrees2) {
        super(ArrayUtils.append(degrees2, {graph}), (Priority)PropagatorPriority.BINARY, false);
        this.target = new IncidentSet.SuccessorsSet();
        this.g = graph;
        this.n = this.g.getNbMaxNodes();
        this.degrees = degrees2;
        this.toDo = new BitSet(this.n);
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (this.g.isDirected()) {
            this.propagateDirected();
        } else {
            this.propagateUndirected();
        }
    }

    public void propagateDirected() throws ContradictionException {
        for (int i = 0; i < this.n; ++i) {
            int s2;
            ISetIterator iSetIterator;
            if (!this.g.getPotentialNodes().contains(i)) {
                this.degrees[i].instantiateTo(0, this);
            } else if (this.degrees[i].getLB() > 0) {
                this.g.enforceNode(i, this);
            }
            ISet env = this.target.getPotentialSet(this.g, i);
            ISet ker = this.target.getMandatorySet(this.g, i);
            this.degrees[i].updateLowerBound(ker.size(), this);
            this.degrees[i].updateUpperBound(env.size(), this);
            if (ker.size() >= env.size() || !this.degrees[i].isInstantiated()) continue;
            int d2 = this.degrees[i].getValue();
            if (env.size() == d2) {
                iSetIterator = env.iterator();
                while (iSetIterator.hasNext()) {
                    s2 = (Integer)iSetIterator.next();
                    this.target.enforce(this.g, i, s2, this);
                }
                continue;
            }
            if (ker.size() != d2) continue;
            iSetIterator = env.iterator();
            while (iSetIterator.hasNext()) {
                s2 = (Integer)iSetIterator.next();
                if (ker.contains(s2)) continue;
                this.target.remove(this.g, i, s2, this);
            }
        }
    }

    public void propagateUndirected() throws ContradictionException {
        int i;
        assert (!this.g.isDirected());
        this.toDo.clear();
        for (i = 0; i < this.n; ++i) {
            this.toDo.set(i);
        }
        i = this.toDo.nextSetBit(0);
        do {
            int s2;
            ISetIterator iSetIterator;
            this.toDo.clear(i);
            if (!this.g.getPotentialNodes().contains(i)) {
                this.degrees[i].instantiateTo(0, this);
            } else if (this.degrees[i].getLB() > 0) {
                this.g.enforceNode(i, this);
            }
            ISet env = this.target.getPotentialSet(this.g, i);
            ISet ker = this.target.getMandatorySet(this.g, i);
            this.degrees[i].updateLowerBound(ker.size(), this);
            this.degrees[i].updateUpperBound(env.size(), this);
            if (ker.size() >= env.size() || !this.degrees[i].isInstantiated()) continue;
            int d2 = this.degrees[i].getValue();
            if (env.size() == d2) {
                iSetIterator = env.iterator();
                while (iSetIterator.hasNext()) {
                    s2 = (Integer)iSetIterator.next();
                    if (!this.target.enforce(this.g, i, s2, this)) continue;
                    this.toDo.set(s2);
                }
            } else {
                if (ker.size() != d2) continue;
                iSetIterator = env.iterator();
                while (iSetIterator.hasNext()) {
                    s2 = (Integer)iSetIterator.next();
                    if (ker.contains(s2) || !this.target.remove(this.g, i, s2, this)) continue;
                    this.toDo.set(s2);
                }
            }
        } while ((i = this.toDo.nextSetBit(0)) >= 0);
    }

    @Override
    public ESat isEntailed() {
        boolean done = true;
        for (int i = 0; i < this.n; ++i) {
            if (!this.degrees[i].contains(0) && !this.g.getPotentialNodes().contains(i)) {
                return ESat.FALSE;
            }
            ISet env = this.target.getPotentialSet(this.g, i);
            ISet ker = this.target.getMandatorySet(this.g, i);
            if (this.degrees[i].getLB() > env.size() || this.degrees[i].getUB() < ker.size()) {
                return ESat.FALSE;
            }
            if (env.size() == ker.size() && this.degrees[i].isInstantiated()) continue;
            done = false;
        }
        if (!done) {
            return ESat.UNDEFINED;
        }
        return ESat.TRUE;
    }
}

