/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.memory.trailing;

import org.chocosolver.memory.AbstractEnvironment;
import org.chocosolver.memory.IStateBool;
import org.chocosolver.memory.IStateDouble;
import org.chocosolver.memory.IStateDoubleVector;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.memory.IStateIntVector;
import org.chocosolver.memory.IStateLong;
import org.chocosolver.memory.IStorage;
import org.chocosolver.memory.structure.IOperation;
import org.chocosolver.memory.trailing.StoredBool;
import org.chocosolver.memory.trailing.StoredDouble;
import org.chocosolver.memory.trailing.StoredDoubleVector;
import org.chocosolver.memory.trailing.StoredInt;
import org.chocosolver.memory.trailing.StoredIntVector;
import org.chocosolver.memory.trailing.StoredLong;
import org.chocosolver.memory.trailing.trail.IOperationTrail;
import org.chocosolver.memory.trailing.trail.IStoredBoolTrail;
import org.chocosolver.memory.trailing.trail.IStoredDoubleTrail;
import org.chocosolver.memory.trailing.trail.IStoredIntTrail;
import org.chocosolver.memory.trailing.trail.IStoredLongTrail;
import org.chocosolver.memory.trailing.trail.StoredDoubleVectorTrail;
import org.chocosolver.memory.trailing.trail.StoredIntVectorTrail;
import org.chocosolver.memory.trailing.trail.flatten.OperationTrail;
import org.chocosolver.memory.trailing.trail.flatten.StoredBoolTrail;
import org.chocosolver.memory.trailing.trail.flatten.StoredDoubleTrail;
import org.chocosolver.memory.trailing.trail.flatten.StoredIntTrail;
import org.chocosolver.memory.trailing.trail.flatten.StoredLongTrail;

public class EnvironmentTrailing
extends AbstractEnvironment {
    public static final int NBWORLDS = 128;
    public static final int NBUPATES = 256;
    public static final double LOADFACTOR = 2.0;
    private IStoredIntTrail intTrail;
    private IStoredBoolTrail boolTrail;
    private IStoredLongTrail longTrail;
    private IStoredDoubleTrail doubleTrail;
    private IOperationTrail operationTrail;
    private StoredIntVectorTrail intVectorTrail;
    private StoredDoubleVectorTrail doubleVectorTrail;
    private IStorage[] trails = new IStorage[0];
    private int trailSize = 0;

    @Override
    public void worldPush() {
        ++this.timestamp;
        int wi = this.currentWorld + 1;
        for (int i = 0; i < this.trailSize; ++i) {
            this.trails[i].worldPush(wi);
        }
        ++this.currentWorld;
    }

    @Override
    public void worldPop() {
        ++this.timestamp;
        int wi = this.currentWorld;
        for (int i = this.trailSize - 1; i >= 0; --i) {
            this.trails[i].worldPop(wi);
        }
        --this.currentWorld;
        assert (this.currentWorld >= 0);
    }

    @Override
    public void worldCommit() {
        if (this.currentWorld == 0) {
            throw new IllegalStateException("Commit in world 0?");
        }
        int wi = this.currentWorld;
        for (int i = this.trailSize - 1; i >= 0; --i) {
            this.trails[i].worldCommit(wi);
        }
        --this.currentWorld;
    }

    @Override
    public IStateInt makeInt() {
        return this.makeInt(0);
    }

    @Override
    public IStateInt makeInt(int initialValue) {
        return new StoredInt(this, initialValue);
    }

    @Override
    public IStateBool makeBool(boolean initialValue) {
        return new StoredBool(this, initialValue);
    }

    @Override
    public IStateIntVector makeIntVector(int size, int initialValue) {
        return new StoredIntVector(this, size, initialValue);
    }

    @Override
    public IStateDoubleVector makeDoubleVector(int size, double initialValue) {
        return new StoredDoubleVector(this, size, initialValue);
    }

    @Override
    public IStateDouble makeFloat() {
        return this.makeFloat(Double.NaN);
    }

    @Override
    public IStateDouble makeFloat(double initialValue) {
        return new StoredDouble(this, initialValue);
    }

    @Override
    public IStateLong makeLong() {
        return this.makeLong(0L);
    }

    @Override
    public IStateLong makeLong(long init) {
        return new StoredLong(this, init);
    }

    private void increaseTrail() {
        IStorage[] tmp = this.trails;
        this.trails = new IStorage[tmp.length + 1];
        System.arraycopy(tmp, 0, this.trails, 0, tmp.length);
    }

    public void setIntTrail(IStoredIntTrail itrail) {
        if (this.intTrail != null) {
            throw new UnsupportedOperationException("A trail has already been declared.");
        }
        this.increaseTrail();
        this.intTrail = itrail;
        this.trails[this.trailSize++] = this.intTrail;
    }

    public IStoredIntTrail getIntTrail() {
        if (this.intTrail == null) {
            this.setIntTrail(new StoredIntTrail(256, 128, 2.0));
        }
        return this.intTrail;
    }

    public void setLongTrail(IStoredLongTrail ltrail) {
        if (this.longTrail != null) {
            throw new UnsupportedOperationException("A trail has already been declared.");
        }
        this.increaseTrail();
        this.longTrail = ltrail;
        this.trails[this.trailSize++] = this.longTrail;
    }

    public IStoredLongTrail getLongTrail() {
        if (this.longTrail == null) {
            this.setLongTrail(new StoredLongTrail(256, 128, 2.0));
        }
        return this.longTrail;
    }

    public void setBoolTrail(IStoredBoolTrail btrail) {
        if (this.boolTrail != null) {
            throw new UnsupportedOperationException("A trail has already been declared.");
        }
        this.increaseTrail();
        this.boolTrail = btrail;
        this.trails[this.trailSize++] = this.boolTrail;
    }

    public IStoredBoolTrail getBoolTrail() {
        if (this.boolTrail == null) {
            this.setBoolTrail(new StoredBoolTrail(256, 128, 2.0));
        }
        return this.boolTrail;
    }

    public void setDoubleTrail(IStoredDoubleTrail dtrail) {
        if (this.doubleTrail != null) {
            throw new UnsupportedOperationException("A trail has already been declared.");
        }
        this.increaseTrail();
        this.doubleTrail = dtrail;
        this.trails[this.trailSize++] = this.doubleTrail;
    }

    public IStoredDoubleTrail getDoubleTrail() {
        if (this.doubleTrail == null) {
            this.setDoubleTrail(new StoredDoubleTrail(256, 128, 2.0));
        }
        return this.doubleTrail;
    }

    public void setOperationTrail(IOperationTrail otrail) {
        if (this.operationTrail != null) {
            throw new UnsupportedOperationException("A trail has already been declared.");
        }
        this.increaseTrail();
        this.operationTrail = otrail;
        this.trails[this.trailSize++] = this.operationTrail;
    }

    public IOperationTrail getOperationTrail() {
        if (this.operationTrail == null) {
            this.setOperationTrail(new OperationTrail(256, 128, 2.0));
        }
        return this.operationTrail;
    }

    public StoredIntVectorTrail getIntVectorTrail() {
        if (this.intVectorTrail == null) {
            this.increaseTrail();
            this.intVectorTrail = new StoredIntVectorTrail(this, 256, 128, 2.0);
            this.trails[this.trailSize++] = this.intVectorTrail;
        }
        return this.intVectorTrail;
    }

    public StoredDoubleVectorTrail getDoubleVectorTrail() {
        if (this.doubleVectorTrail == null) {
            this.increaseTrail();
            this.doubleVectorTrail = new StoredDoubleVectorTrail(this, 256, 128, 2.0);
            this.trails[this.trailSize++] = this.doubleVectorTrail;
        }
        return this.doubleVectorTrail;
    }

    @Override
    public void save(IOperation oldValue) {
        this.getOperationTrail().savePreviousState(oldValue);
    }

    @Override
    public void saveAt(IOperation oldValue, int at) {
        this.getOperationTrail().savePreviousStateAt(oldValue, at, this.getWorldIndex());
    }
}

