/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.cutoffseq;

import org.chocosolver.cutoffseq.AbstractCutoffStrategy;

public final class GeometricalCutoffStrategy
extends AbstractCutoffStrategy {
    private final double geometricalFactor;
    private double geometricalFactorPower;

    public GeometricalCutoffStrategy(long s2, double g2) throws IllegalArgumentException {
        super(s2);
        if (g2 <= 1.0) {
            throw new IllegalArgumentException("The geometrical factor of the restart strategy must be strictly greater than 1.");
        }
        this.geometricalFactor = g2;
        this.geometricalFactorPower = 1.0;
    }

    @Override
    public long getNextCutoff() {
        long cutoff = (long)Math.ceil((double)this.scaleFactor * this.geometricalFactorPower);
        this.geometricalFactorPower *= this.geometricalFactor;
        return cutoff;
    }

    @Override
    public void reset() {
        this.geometricalFactorPower = 1.0;
    }

    public String toString() {
        return "GEOMETRICAL(s=" + this.scaleFactor + ", g=" + this.geometricalFactor + ')';
    }
}

