/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.periodictable;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.openscience.cdk.config.Elements;

public final class PeriodicTable {
    private static volatile Map<Elements, String> ids;
    private static final Object LOCK;

    public static Double getVdwRadius(String symbol) {
        return Elements.ofString(symbol).vdwRadius();
    }

    public static Double getCovalentRadius(String symbol) {
        return Elements.ofString(symbol).covalentRadius();
    }

    public static String getCASId(String symbol) {
        return PeriodicTable.casIds().get((Object)Elements.ofString(symbol));
    }

    public static String getChemicalSeries(String symbol) {
        Elements e = Elements.ofString(symbol);
        for (Series s : Series.values()) {
            if (!s.contains(e)) continue;
            return s.name();
        }
        return null;
    }

    public static Integer getGroup(String symbol) {
        return Elements.ofString(symbol).group();
    }

    public static String getName(String symbol) {
        return Elements.ofString(symbol).name();
    }

    public static Integer getPeriod(String symbol) {
        return Elements.ofString(symbol).period();
    }

    public static String getPhase(String symbol) {
        Elements e = Elements.ofString(symbol);
        for (Phase p : Phase.values()) {
            if (!p.contains(e)) continue;
            return p.name();
        }
        return null;
    }

    public static Integer getAtomicNumber(String symbol) {
        return Elements.ofString(symbol).number();
    }

    public static Double getPaulingElectronegativity(String symbol) {
        return Elements.ofString(symbol).electronegativity();
    }

    public static String getSymbol(int atomicNumber) {
        return Elements.ofNumber(atomicNumber).symbol();
    }

    public static int getElementCount() {
        return Elements.values().length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Elements, String> casIds() {
        Map<Elements, String> result = ids;
        if (result == null) {
            Object object = LOCK;
            synchronized (object) {
                result = ids;
                if (result == null) {
                    ids = result = PeriodicTable.initCasIds();
                }
            }
        }
        return result;
    }

    private static Map<Elements, String> initCasIds() {
        EnumMap<Elements, String> ids = new EnumMap<Elements, String>(Elements.class);
        ids.put(Elements.Unknown, "");
        ids.put(Elements.Hydrogen, "1333-74-0");
        ids.put(Elements.Helium, "7440-59-7");
        ids.put(Elements.Lithium, "7439-93-2");
        ids.put(Elements.Beryllium, "7440-41-7");
        ids.put(Elements.Boron, "7440-42-8");
        ids.put(Elements.Carbon, "7440-44-0");
        ids.put(Elements.Nitrogen, "7727-37-9");
        ids.put(Elements.Oxygen, "7782-44-7");
        ids.put(Elements.Fluorine, "7782-41-4");
        ids.put(Elements.Neon, "7440-01-9");
        ids.put(Elements.Sodium, "7440-23-5");
        ids.put(Elements.Magnesium, "7439-95-4");
        ids.put(Elements.Aluminium, "7429-90-5");
        ids.put(Elements.Silicon, "7440-21-3");
        ids.put(Elements.Phosphorus, "7723-14-0");
        ids.put(Elements.Sulfur, "7704-34-9");
        ids.put(Elements.Chlorine, "7782-50-5");
        ids.put(Elements.Argon, "7440-37-1");
        ids.put(Elements.Potassium, "7440-09-7");
        ids.put(Elements.Calcium, "7440-70-2");
        ids.put(Elements.Scandium, "7440-20-2");
        ids.put(Elements.Titanium, "7440-32-6");
        ids.put(Elements.Vanadium, "7440-62-2");
        ids.put(Elements.Chromium, "7440-47-3");
        ids.put(Elements.Manganese, "7439-96-5");
        ids.put(Elements.Iron, "7439-89-6");
        ids.put(Elements.Cobalt, "7440-48-4");
        ids.put(Elements.Nickel, "7440-02-0");
        ids.put(Elements.Copper, "7440-50-8");
        ids.put(Elements.Zinc, "7440-66-6");
        ids.put(Elements.Gallium, "7440-55-3");
        ids.put(Elements.Germanium, "7440-56-4");
        ids.put(Elements.Arsenic, "7440-38-2");
        ids.put(Elements.Selenium, "7782-49-2");
        ids.put(Elements.Bromine, "7726-95-6");
        ids.put(Elements.Krypton, "7439-90-9");
        ids.put(Elements.Rubidium, "7440-17-7");
        ids.put(Elements.Strontium, "7440-24-6");
        ids.put(Elements.Yttrium, "7440-65-5");
        ids.put(Elements.Zirconium, "7440-67-7");
        ids.put(Elements.Niobium, "7440-03-1");
        ids.put(Elements.Molybdenum, "7439-98-7");
        ids.put(Elements.Technetium, "7440-26-8");
        ids.put(Elements.Ruthenium, "7440-18-8");
        ids.put(Elements.Rhodium, "7440-16-6");
        ids.put(Elements.Palladium, "7440-05-3");
        ids.put(Elements.Silver, "7440-22-4");
        ids.put(Elements.Cadmium, "7440-43-9");
        ids.put(Elements.Indium, "7440-74-6");
        ids.put(Elements.Tin, "7440-31-5");
        ids.put(Elements.Antimony, "7440-36-0");
        ids.put(Elements.Tellurium, "13494-80-9");
        ids.put(Elements.Iodine, "7553-56-2");
        ids.put(Elements.Xenon, "7440-63-3");
        ids.put(Elements.Caesium, "7440-46-2");
        ids.put(Elements.Barium, "7440-39-3");
        ids.put(Elements.Lanthanum, "7439-91-0");
        ids.put(Elements.Cerium, "7440-45-1");
        ids.put(Elements.Praseodymium, "7440-10-0");
        ids.put(Elements.Neodymium, "7440-00-8");
        ids.put(Elements.Promethium, "7440-12-2");
        ids.put(Elements.Samarium, "7440-19-9");
        ids.put(Elements.Europium, "7440-53-1");
        ids.put(Elements.Gadolinium, "7440-54-2");
        ids.put(Elements.Terbium, "7440-27-9");
        ids.put(Elements.Dysprosium, "7429-91-6");
        ids.put(Elements.Holmium, "7440-60-0");
        ids.put(Elements.Erbium, "7440-52-0");
        ids.put(Elements.Thulium, "7440-30-4");
        ids.put(Elements.Ytterbium, "7440-64-4");
        ids.put(Elements.Lutetium, "7439-94-3");
        ids.put(Elements.Hafnium, "7440-58-6");
        ids.put(Elements.Tantalum, "7440-25-7");
        ids.put(Elements.Tungsten, "7440-33-7");
        ids.put(Elements.Rhenium, "7440-15-5");
        ids.put(Elements.Osmium, "7440-04-2");
        ids.put(Elements.Iridium, "7439-88-5");
        ids.put(Elements.Platinum, "7440-06-4");
        ids.put(Elements.Gold, "7440-57-5");
        ids.put(Elements.Mercury, "7439-97-6");
        ids.put(Elements.Thallium, "7440-28-0");
        ids.put(Elements.Lead, "7439-92-1");
        ids.put(Elements.Bismuth, "7440-69-9");
        ids.put(Elements.Polonium, "7440-08-6");
        ids.put(Elements.Astatine, "7440-08-6");
        ids.put(Elements.Radon, "10043-92-2");
        ids.put(Elements.Francium, "7440-73-5");
        ids.put(Elements.Radium, "7440-14-4");
        ids.put(Elements.Actinium, "7440-34-8");
        ids.put(Elements.Thorium, "7440-29-1");
        ids.put(Elements.Protactinium, "7440-13-3");
        ids.put(Elements.Uranium, "7440-61-1");
        ids.put(Elements.Neptunium, "7439-99-8");
        ids.put(Elements.Plutonium, "7440-07-5");
        ids.put(Elements.Americium, "7440-35-9");
        ids.put(Elements.Curium, "7440-51-9");
        ids.put(Elements.Berkelium, "7440-40-6");
        ids.put(Elements.Californium, "7440-71-3");
        ids.put(Elements.Einsteinium, "7429-92-7");
        ids.put(Elements.Fermium, "7440-72-4");
        ids.put(Elements.Mendelevium, "7440-11-1");
        ids.put(Elements.Nobelium, "10028-14-5");
        ids.put(Elements.Lawrencium, "22537-19-5");
        ids.put(Elements.Rutherfordium, "53850-36-5");
        ids.put(Elements.Dubnium, "53850-35-4");
        ids.put(Elements.Seaborgium, "54038-81-2");
        ids.put(Elements.Bohrium, "54037-14-8");
        ids.put(Elements.Hassium, "54037-57-9");
        ids.put(Elements.Meitnerium, "54038-01-6");
        ids.put(Elements.Darmstadtium, "54083-77-1");
        ids.put(Elements.Roentgenium, "54386-24-2");
        ids.put(Elements.Copernicium, "54084-26-3");
        ids.put(Elements.Ununtrium, "");
        ids.put(Elements.Flerovium, "54085-16-4");
        ids.put(Elements.Ununpentium, "");
        ids.put(Elements.Livermorium, "54100-71-9");
        ids.put(Elements.Ununseptium, "");
        ids.put(Elements.Ununoctium, "");
        return ids;
    }

    static {
        LOCK = new Object();
    }

    private static enum Phase {
        Solid(Elements.Sulfur, Elements.Hafnium, Elements.Terbium, Elements.Calcium, Elements.Gadolinium, Elements.Nickel, Elements.Cerium, Elements.Germanium, Elements.Phosphorus, Elements.Copper, Elements.Polonium, Elements.Lead, Elements.Gold, Elements.Iodine, Elements.Cadmium, Elements.Ytterbium, Elements.Manganese, Elements.Lithium, Elements.Palladium, Elements.Vanadium, Elements.Chromium, Elements.Molybdenum, Elements.Potassium, Elements.Ruthenium, Elements.Osmium, Elements.Boron, Elements.Bismuth, Elements.Rhenium, Elements.Holmium, Elements.Niobium, Elements.Praseodymium, Elements.Barium, Elements.Antimony, Elements.Thallium, Elements.Iron, Elements.Silver, Elements.Silicon, Elements.Caesium, Elements.Astatine, Elements.Iridium, Elements.Francium, Elements.Lutetium, Elements.Yttrium, Elements.Rubidium, Elements.Lanthanum, Elements.Tungsten, Elements.Erbium, Elements.Selenium, Elements.Gallium, Elements.Carbon, Elements.Rhodium, Elements.Uranium, Elements.Dysprosium, Elements.Cobalt, Elements.Zinc, Elements.Platinum, Elements.Protactinium, Elements.Titanium, Elements.Arsenic, Elements.Tantalum, Elements.Thorium, Elements.Samarium, Elements.Europium, Elements.Neodymium, Elements.Zirconium, Elements.Radium, Elements.Thulium, Elements.Sodium, Elements.Scandium, Elements.Tellurium, Elements.Indium, Elements.Beryllium, Elements.Aluminium, Elements.Strontium, Elements.Tin, Elements.Magnesium),
        Liquid(Elements.Bromine, Elements.Mercury),
        Gas(Elements.Fluorine, Elements.Oxygen, Elements.Xenon, Elements.Argon, Elements.Chlorine, Elements.Helium, Elements.Krypton, Elements.Hydrogen, Elements.Radon, Elements.Nitrogen, Elements.Neon),
        Synthetic(Elements.Fermium, Elements.Seaborgium, Elements.Plutonium, Elements.Roentgenium, Elements.Lawrencium, Elements.Meitnerium, Elements.Einsteinium, Elements.Nobelium, Elements.Actinium, Elements.Rutherfordium, Elements.Americium, Elements.Curium, Elements.Bohrium, Elements.Berkelium, Elements.Promethium, Elements.Copernicium, Elements.Technetium, Elements.Hassium, Elements.Californium, Elements.Mendelevium, Elements.Neptunium, Elements.Darmstadtium, Elements.Dubnium);

        private final Set<Elements> elements;

        private Phase(Elements first, Elements ... rest) {
            this.elements = EnumSet.of(first, rest);
        }

        boolean contains(Elements e) {
            return this.elements.contains((Object)e);
        }
    }

    private static enum Series {
        NonMetals(Elements.Sulfur, Elements.Selenium, Elements.Oxygen, Elements.Carbon, Elements.Phosphorus, Elements.Hydrogen, Elements.Nitrogen),
        NobleGasses(Elements.Helium, Elements.Krypton, Elements.Xenon, Elements.Argon, Elements.Radon, Elements.Neon),
        AlkaliMetals(Elements.Sodium, Elements.Rubidium, Elements.Potassium, Elements.Caesium, Elements.Francium, Elements.Lithium),
        AlkaliEarthMetals(Elements.Strontium, Elements.Radium, Elements.Calcium, Elements.Magnesium, Elements.Barium, Elements.Beryllium),
        Metalloids(Elements.Silicon, Elements.Arsenic, Elements.Tellurium, Elements.Germanium, Elements.Antimony, Elements.Polonium, Elements.Boron),
        Halogens(Elements.Fluorine, Elements.Iodine, Elements.Chlorine, Elements.Astatine, Elements.Bromine),
        Metals(Elements.Gallium, Elements.Indium, Elements.Aluminium, Elements.Thallium, Elements.Tin, Elements.Lead, Elements.Bismuth),
        TransitionMetals(Elements.Seaborgium, Elements.Hafnium, Elements.Roentgenium, Elements.Iridium, Elements.Nickel, Elements.Meitnerium, Elements.Yttrium, Elements.Copper, Elements.Rutherfordium, Elements.Tungsten, Elements.Copernicium, Elements.Rhodium, Elements.Cobalt, Elements.Zinc, Elements.Platinum, Elements.Gold, Elements.Cadmium, Elements.Manganese, Elements.Darmstadtium, Elements.Dubnium, Elements.Palladium, Elements.Vanadium, Elements.Titanium, Elements.Tantalum, Elements.Chromium, Elements.Molybdenum, Elements.Ruthenium, Elements.Zirconium, Elements.Osmium, Elements.Bohrium, Elements.Rhenium, Elements.Niobium, Elements.Scandium, Elements.Technetium, Elements.Hassium, Elements.Mercury, Elements.Iron, Elements.Silver),
        Lanthanides(Elements.Terbium, Elements.Samarium, Elements.Lutetium, Elements.Neodymium, Elements.Cerium, Elements.Europium, Elements.Gadolinium, Elements.Thulium, Elements.Lanthanum, Elements.Erbium, Elements.Promethium, Elements.Holmium, Elements.Praseodymium, Elements.Dysprosium, Elements.Ytterbium),
        Actinides(Elements.Fermium, Elements.Protactinium, Elements.Plutonium, Elements.Thorium, Elements.Lawrencium, Elements.Einsteinium, Elements.Nobelium, Elements.Actinium, Elements.Americium, Elements.Curium, Elements.Berkelium, Elements.Mendelevium, Elements.Uranium, Elements.Californium, Elements.Neptunium);

        private final Set<Elements> elements;

        private Series(Elements first, Elements ... rest) {
            this.elements = EnumSet.of(first, rest);
        }

        boolean contains(Elements e) {
            return this.elements.contains((Object)e);
        }
    }
}

