/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.fingerprint;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.fingerprint.AbstractFingerprinter;
import org.openscience.cdk.fingerprint.BitSetFingerprint;
import org.openscience.cdk.fingerprint.IBitFingerprint;
import org.openscience.cdk.fingerprint.ICountFingerprint;
import org.openscience.cdk.fingerprint.IFingerprinter;
import org.openscience.cdk.graph.AllPairsShortestPaths;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;

public class AtomPairs2DFingerprinter
extends AbstractFingerprinter
implements IFingerprinter {
    private static final int MAX_DISTANCE = 10;
    private static final String[] atypes = new String[]{"C", "N", "O", "S", "P", "F", "Cl", "Br", "I", "B", "Si", "X"};
    private final Map<String, Integer> pathToBit = new HashMap<String, Integer>();
    private final Map<Integer, String> bitToPath = new HashMap<Integer, String>();

    public AtomPairs2DFingerprinter() {
        for (int dist = 1; dist <= 10; ++dist) {
            for (int i = 0; i < atypes.length; ++i) {
                for (int j = i; j < atypes.length; ++j) {
                    String key_name = dist + "_" + atypes[i] + "_" + atypes[j];
                    this.pathToBit.put(key_name, this.pathToBit.size());
                    this.bitToPath.put(this.bitToPath.size(), key_name);
                }
            }
        }
    }

    @Override
    public int getSize() {
        return this.pathToBit.size();
    }

    private static boolean isHalogen(IAtom atom) {
        switch (atom.getAtomicNumber()) {
            case 9: 
            case 17: 
            case 35: 
            case 53: {
                return true;
            }
        }
        return false;
    }

    private static boolean include(IAtom atom) {
        switch (atom.getAtomicNumber()) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 35: 
            case 53: {
                return true;
            }
        }
        return false;
    }

    private static String encodePath(int dist, IAtom a, IAtom b) {
        return dist + "_" + a.getSymbol() + "_" + b.getSymbol();
    }

    private static String encodeHalPath(int dist, IAtom a, IAtom b) {
        return dist + "_" + (AtomPairs2DFingerprinter.isHalogen(a) ? "X" : a.getSymbol()) + "_" + (AtomPairs2DFingerprinter.isHalogen(b) ? "X" : b.getSymbol());
    }

    private void calculate(List<String> paths, IAtomContainer mol) {
        AllPairsShortestPaths apsp = new AllPairsShortestPaths(mol);
        int numAtoms = mol.getAtomCount();
        for (int i = 0; i < numAtoms; ++i) {
            if (!AtomPairs2DFingerprinter.include(mol.getAtom(i))) continue;
            for (int j = i + 1; j < numAtoms; ++j) {
                int dist;
                if (!AtomPairs2DFingerprinter.include(mol.getAtom(j)) || (dist = apsp.from(i).distanceTo(j)) > 10) continue;
                IAtom beg = mol.getAtom(i);
                IAtom end = mol.getAtom(j);
                paths.add(AtomPairs2DFingerprinter.encodePath(dist, beg, end));
                paths.add(AtomPairs2DFingerprinter.encodePath(dist, end, beg));
                if (!AtomPairs2DFingerprinter.isHalogen(mol.getAtom(i)) && !AtomPairs2DFingerprinter.isHalogen(mol.getAtom(j))) continue;
                paths.add(AtomPairs2DFingerprinter.encodeHalPath(dist, beg, end));
                paths.add(AtomPairs2DFingerprinter.encodeHalPath(dist, end, beg));
            }
        }
    }

    @Override
    public IBitFingerprint getBitFingerprint(IAtomContainer container) throws CDKException {
        BitSet fp = new BitSet(this.pathToBit.size());
        ArrayList<String> paths = new ArrayList<String>();
        this.calculate(paths, container);
        for (String path : paths) {
            if (!this.pathToBit.containsKey(path)) continue;
            fp.set(this.pathToBit.get(path));
        }
        return new BitSetFingerprint(fp);
    }

    @Override
    public Map<String, Integer> getRawFingerprint(IAtomContainer mol) throws CDKException {
        HashMap<String, Integer> raw = new HashMap<String, Integer>();
        ArrayList<String> paths = new ArrayList<String>();
        this.calculate(paths, mol);
        Collections.sort(paths);
        int count = 0;
        String prev = null;
        for (String path : paths) {
            if (prev == null || !path.equals(prev)) {
                if (count > 0) {
                    raw.put(prev, count);
                }
                count = 1;
                prev = path;
                continue;
            }
            ++count;
        }
        if (count > 0) {
            raw.put(prev, count);
        }
        return raw;
    }

    @Override
    public ICountFingerprint getCountFingerprint(IAtomContainer mol) throws CDKException {
        final Map<String, Integer> raw = this.getRawFingerprint(mol);
        final ArrayList<String> keys = new ArrayList<String>(raw.keySet());
        return new ICountFingerprint(){

            @Override
            public long size() {
                return AtomPairs2DFingerprinter.this.pathToBit.size();
            }

            @Override
            public int numOfPopulatedbins() {
                return keys.size();
            }

            @Override
            public int getCount(int index) {
                return (Integer)raw.get(keys.get(index));
            }

            @Override
            public int getHash(int index) {
                return (Integer)AtomPairs2DFingerprinter.this.pathToBit.get(keys.get(index));
            }

            @Override
            public void merge(ICountFingerprint fp) {
            }

            @Override
            public void setBehaveAsBitFingerprint(boolean behaveAsBitFingerprint) {
            }

            @Override
            public boolean hasHash(int hash) {
                return AtomPairs2DFingerprinter.this.bitToPath.containsKey(hash);
            }

            @Override
            public int getCountForHash(int hash) {
                return (Integer)raw.get(AtomPairs2DFingerprinter.this.bitToPath.get(hash));
            }
        };
    }
}

