/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.depict;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.freehep.graphicsio.pdf.PDFGraphics2D;
import org.freehep.graphicsio.ps.PSGraphics2D;
import org.freehep.graphicsio.svg.SVGGraphics2D;

final class FreeHepWrapper {
    private final ByteArrayOutputStream bout;
    private final String fmt;
    final Graphics2D g2;
    private final Dimension dim;

    public FreeHepWrapper(String fmt, double w, double h) {
        this.dim = new Dimension((int)Math.ceil(w), (int)Math.ceil(h));
        try {
            this.fmt = fmt;
            this.bout = new ByteArrayOutputStream();
            this.g2 = FreeHepWrapper.createGraphics2d(this.fmt, this.bout, this.dim);
        }
        catch (IOException e) {
            throw new InstantiationError("Could not create Vector Graphics output: " + e.getMessage());
        }
    }

    private static Graphics2D createGraphics2d(String fmt, OutputStream out, Dimension dim) throws IOException {
        switch (fmt) {
            case "svg": {
                SVGGraphics2D svg = new SVGGraphics2D(out, dim);
                svg.setCreator("Chemistry Development Kit (http://www.github.com/cdk/)");
                svg.writeHeader();
                return svg;
            }
            case "pdf": {
                PDFGraphics2D pdf = new PDFGraphics2D(out, dim);
                pdf.setCreator("Chemistry Development Kit (http://www.github.com/cdk/)");
                Properties props = new Properties();
                props.setProperty(PDFGraphics2D.FIT_TO_PAGE, "false");
                props.setProperty(PDFGraphics2D.PAGE_SIZE, PDFGraphics2D.CUSTOM_PAGE_SIZE);
                props.setProperty(PDFGraphics2D.CUSTOM_PAGE_SIZE, dim.width + ", " + dim.height);
                props.setProperty(PDFGraphics2D.PAGE_MARGINS, "0, 0, 0, 0");
                pdf.setProperties(props);
                pdf.writeHeader();
                return pdf;
            }
            case "eps": {
                PSGraphics2D eps = new PSGraphics2D(out, dim);
                Properties eps_props = new Properties();
                eps_props.setProperty(PDFGraphics2D.FIT_TO_PAGE, "false");
                eps.setProperties(eps_props);
                eps.writeHeader();
                return eps;
            }
            case "ps": {
                PSGraphics2D ps = new PSGraphics2D(out, dim);
                Properties ps_props = new Properties();
                ps_props.setProperty(PDFGraphics2D.FIT_TO_PAGE, "true");
                ps.setProperties(ps_props);
                ps.writeHeader();
                return ps;
            }
        }
        throw new IOException("Unsupported vector format, " + fmt);
    }

    public void dispose() {
        try {
            switch (this.fmt) {
                case "svg": {
                    ((SVGGraphics2D)this.g2).writeTrailer();
                    ((SVGGraphics2D)this.g2).closeStream();
                    break;
                }
                case "pdf": {
                    ((PDFGraphics2D)this.g2).writeTrailer();
                    ((PDFGraphics2D)this.g2).closeStream();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.g2.dispose();
    }

    public String toString() {
        String nl;
        String[] split;
        String result = new String(this.bout.toByteArray(), StandardCharsets.UTF_8);
        if (this.fmt.equals("svg")) {
            result = result.replaceAll("\"([-+0-9.]+)px\"", "\"$1mm\"");
        } else if (this.fmt.equals("eps") && (split = result.split(nl = result.contains("\r\n") ? "\r\n" : (result.contains("\r") ? "\r" : "\n"), 2)).length > 1 && split[0].startsWith("%!PS-")) {
            String boundingBox = this.dim != null ? "%%BoundingBox: 0 0 " + this.dim.width + " " + this.dim.height + nl : "";
            if (!split[0].contains("EPS") && !boundingBox.equals("")) {
                split[0] = split[0] + " EPSF-3.0";
            }
            result = split[0] + nl + boundingBox + split[1].replaceFirst("(\\d+ ){4}setmargins", "0 0 0 0 setmargins").replaceFirst("(\\d+ ){2}setpagesize", this.dim.width + " " + this.dim.height + " setpagesize");
        }
        return result;
    }
}

