### R code from vignette source 'rainbow.Rnw'

###################################################
### code chunk number 1: rainbow.Rnw:51-53
###################################################
library(rainbow)
options(prompt = "R> ", rainbow.messages = FALSE, digits = 3)


###################################################
### code chunk number 2: rainbow.Rnw:72-77
###################################################
# plot.type = "function", curves are plotted by time
# the most recent curve is shown in purple
# the distant past cure is shown in red
plot(Australiasmoothfertility, plot.type = "functions",
     plotlegend = TRUE)


###################################################
### code chunk number 3: rainbow.Rnw:91-93
###################################################
plot(ElNino_OISST_region_1and2, plot.type = "functions",
     plotlegend = TRUE)


###################################################
### code chunk number 4: rainbow.Rnw:128-129
###################################################
  plot(ElNino_OISST_region_1and2,plot.type="depth",plotlegend=TRUE)


###################################################
### code chunk number 5: rainbow.Rnw:136-137
###################################################
plot(ElNino_OISST_region_1and2,plot.type="density",plotlegend=TRUE)


###################################################
### code chunk number 6: rainbow.Rnw:172-176
###################################################
# plot.type = "bivariate", the bivariate principal component scores are displayed
# type = "bag" requests the bagplot
fboxplot(ElNino_OISST_region_1and2, plot.type = "bivariate", type = "bag", projmethod = "PCAproj",
         ylim = c(-10, 20), xlim = c(-10, 20))


###################################################
### code chunk number 7: rainbow.Rnw:183-185
###################################################
# plot.type = "functional", the bivariate pc scores are matched to corresponding curves
fboxplot(ElNino_OISST_region_1and2, plot.type = "functional", type = "bag", projmethod = "PCAproj")


###################################################
### code chunk number 8: rainbow.Rnw:218-222
###################################################
# plot.type = "bivariate", the bivariate principal component scores are displayed
# type = "hdr" requests the highest density region boxplot
fboxplot(ElNino_OISST_region_1and2, plot.type="bivariate", type="hdr", alpha=c(0.07,0.5),
         projmethod = "PCAproj", ylim=c(-10,20), xlim=c(-10,20))


###################################################
### code chunk number 9: rainbow.Rnw:229-231
###################################################
# plot.type = "functional", the bivariate pc scores are matched to corresponding curves
fboxplot(ElNino_OISST_region_1and2, plot.type = "functional", type = "hdr", alpha = c(0.07,0.5), projmethod="PCAproj")


###################################################
### code chunk number 10: rainbow.Rnw:275-276
###################################################
SVDplot(ElNino_OISST_region_1and2, order = 3, plot = TRUE)


