/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.http;

import com.qarks.util.http.SSLHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import nanoxml.XMLElement;

public class TomcatConfigurator {
    public static void main(String[] stringArray) {
        if (stringArray.length != 4) {
            System.out.println("Usage: TomcatConfigurator certOutputpath certPassword httpPort httpsPort");
        } else {
            try {
                SSLHelper.getAutogeneratedKeystore(stringArray[0], stringArray[1]);
                File file = new File(stringArray[0]);
                String string = file.getName();
                File file2 = file.getParentFile();
                File file3 = new File(file2, "server.xml");
                TomcatConfigurator.backupFile(file3);
                TomcatConfigurator.alterConfFile(file3, string, stringArray[1], stringArray[2], stringArray[3]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void backupFile(File file) throws Exception {
        File file2 = new File(file.getAbsolutePath() + ".backup");
        byte[] byArray = new byte[2048];
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            int n = 0;
            while ((n = fileInputStream.read(byArray)) > -1) {
                fileOutputStream.write(byArray, 0, n);
            }
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    private static void findConnectors(XMLElement xMLElement, List<XMLElement> list) {
        if ("connector".equals(xMLElement.getName().toLowerCase())) {
            list.add(xMLElement);
        } else {
            Vector vector = xMLElement.getChildren();
            for (XMLElement xMLElement2 : vector) {
                TomcatConfigurator.findConnectors(xMLElement2, list);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void alterConfFile(File file, String string, String string2, String string3, String string4) throws Exception {
        String string5;
        String string6 = TomcatConfigurator.getFileContent(file);
        boolean bl = false;
        XMLElement xMLElement = new XMLElement();
        xMLElement.parseString(string6);
        ArrayList<XMLElement> arrayList = new ArrayList<XMLElement>();
        TomcatConfigurator.findConnectors(xMLElement, arrayList);
        for (int i = 0; !bl && i < arrayList.size(); ++i) {
            string5 = (XMLElement)arrayList.get(i);
            String string7 = string5.getStringAttribute("port").trim();
            if (!string3.equals(string7) && !string4.equals(string7)) continue;
            bl = true;
        }
        if (!bl) {
            String string8 = "<Service";
            string5 = ">";
            int n = string6.indexOf(string8);
            if (n <= -1) throw new Exception("service tag not found");
            n = string6.indexOf(string5, n);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string6.substring(0, n + 1));
            stringBuffer.append("\n\n<Connector port=\"");
            stringBuffer.append(string3);
            stringBuffer.append("\" maxHttpHeaderSize=\"8192\"\n");
            stringBuffer.append("maxThreads=\"150\" minSpareThreads=\"25\" maxSpareThreads=\"75\"\n");
            stringBuffer.append("enableLookups=\"false\" redirectPort=\"");
            stringBuffer.append(string4);
            stringBuffer.append("\" acceptCount=\"100\"\n");
            stringBuffer.append("connectionTimeout=\"20000\" disableUploadTimeout=\"true\" />\n\n");
            stringBuffer.append("<Connector port=\"");
            stringBuffer.append(string4);
            stringBuffer.append("\" maxHttpHeaderSize=\"8192\"\n");
            stringBuffer.append("maxThreads=\"150\" minSpareThreads=\"25\" maxSpareThreads=\"75\"\n");
            stringBuffer.append("enableLookups=\"false\" disableUploadTimeout=\"true\"\n");
            stringBuffer.append("acceptCount=\"100\" scheme=\"https\" secure=\"true\"\n");
            stringBuffer.append("clientAuth=\"false\" sslProtocol=\"TLS\" \n");
            stringBuffer.append("keystoreFile=\"conf\\");
            stringBuffer.append(string);
            stringBuffer.append("\" keystorePass=\"");
            stringBuffer.append(string2);
            stringBuffer.append("\"/>\n\n");
            stringBuffer.append(string6.substring(n + 1));
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(stringBuffer.toString().getBytes());
            fileOutputStream.close();
            return;
        } else {
            System.out.println("AVS default ports already defined");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFileContent(File file) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        FileInputStream fileInputStream = null;
        byte[] byArray = new byte[2048];
        try {
            fileInputStream = new FileInputStream(file);
            int n = 0;
            while ((n = fileInputStream.read(byArray)) > -1) {
                stringBuffer.append(new String(byArray, 0, n, "UTF-8"));
            }
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        return stringBuffer.toString();
    }
}

