/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent.io;

import java.io.IOException;
import opennlp.maxent.quasinewton.QNModel;
import opennlp.model.AbstractModel;
import opennlp.model.AbstractModelWriter;
import opennlp.model.Context;
import opennlp.model.IndexHashTable;

public abstract class QNModelWriter
extends AbstractModelWriter {
    protected String[] outcomeNames;
    protected String[] predNames;
    protected Context[] params;
    protected double[] predParams;
    protected IndexHashTable<String> pmap;
    protected double[] parameters;

    public QNModelWriter(AbstractModel model) {
        Object[] data = model.getDataStructures();
        this.params = (Context[])data[0];
        this.pmap = (IndexHashTable)data[1];
        this.outcomeNames = (String[])data[2];
        QNModel qnModel = (QNModel)model;
        this.parameters = qnModel.getParameters();
    }

    public void persist() throws IOException {
        int i;
        this.writeUTF("QN");
        this.predNames = new String[this.pmap.size()];
        this.pmap.toArray((String[])this.predNames);
        this.writeInt(this.predNames.length);
        for (i = 0; i < this.predNames.length; ++i) {
            this.writeUTF(this.predNames[i]);
        }
        this.writeInt(this.outcomeNames.length);
        for (i = 0; i < this.outcomeNames.length; ++i) {
            this.writeUTF(this.outcomeNames[i]);
        }
        this.writeInt(this.params.length);
        for (Context currContext : this.params) {
            int i2;
            this.writeInt(currContext.getOutcomes().length);
            for (i2 = 0; i2 < currContext.getOutcomes().length; ++i2) {
                this.writeInt(currContext.getOutcomes()[i2]);
            }
            this.writeInt(currContext.getParameters().length);
            for (i2 = 0; i2 < currContext.getParameters().length; ++i2) {
                this.writeDouble(currContext.getParameters()[i2]);
            }
        }
        this.writeInt(this.parameters.length);
        for (int i3 = 0; i3 < this.parameters.length; ++i3) {
            this.writeDouble(this.parameters[i3]);
        }
        this.close();
    }
}

