/*
 * Decompiled with CFR 0.152.
 */
package org.jamesframework.ext.problems.objectives.evaluations;

import java.util.HashMap;
import java.util.Map;
import org.jamesframework.core.problems.objectives.Objective;
import org.jamesframework.core.problems.objectives.evaluations.Evaluation;

public class WeightedIndexEvaluation
implements Evaluation {
    private final Map<Objective, Evaluation> evaluations = new HashMap<Objective, Evaluation>();
    private double weightedSum = 0.0;

    public void addEvaluation(Objective obj, Evaluation eval, double weight) {
        this.evaluations.put(obj, eval);
        this.weightedSum += weight * eval.getValue();
    }

    public Evaluation getEvaluation(Objective obj) {
        return this.evaluations.get(obj);
    }

    @Override
    public double getValue() {
        return this.weightedSum;
    }

    public String toString() {
        return this.getValue() + "";
    }
}

