/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.util.ArrayList;
import java.util.Enumeration;
import weka.core.AbstractInstance;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class SparseInstance
extends AbstractInstance {
    private static final long serialVersionUID = -3579051291332630149L;
    protected int[] m_Indices;
    protected int m_NumAttributes;

    public SparseInstance(Instance instance) {
        this.m_Weight = instance.weight();
        this.m_Dataset = null;
        this.m_NumAttributes = instance.numAttributes();
        if (instance instanceof SparseInstance) {
            this.m_AttValues = ((SparseInstance)instance).m_AttValues;
            this.m_Indices = ((SparseInstance)instance).m_Indices;
        } else {
            double[] tempValues = new double[instance.numAttributes()];
            int[] tempIndices = new int[instance.numAttributes()];
            int vals = 0;
            for (int i = 0; i < instance.numAttributes(); ++i) {
                if (instance.value(i) == 0.0) continue;
                tempValues[vals] = instance.value(i);
                tempIndices[vals] = i;
                ++vals;
            }
            this.m_AttValues = new double[vals];
            this.m_Indices = new int[vals];
            System.arraycopy(tempValues, 0, this.m_AttValues, 0, vals);
            System.arraycopy(tempIndices, 0, this.m_Indices, 0, vals);
        }
    }

    public SparseInstance(SparseInstance instance) {
        this.m_AttValues = instance.m_AttValues;
        this.m_Indices = instance.m_Indices;
        this.m_Weight = instance.m_Weight;
        this.m_NumAttributes = instance.m_NumAttributes;
        this.m_Dataset = null;
    }

    public SparseInstance(double weight, double[] attValues) {
        this.m_Weight = weight;
        this.m_Dataset = null;
        this.m_NumAttributes = attValues.length;
        double[] tempValues = new double[this.m_NumAttributes];
        int[] tempIndices = new int[this.m_NumAttributes];
        int vals = 0;
        for (int i = 0; i < this.m_NumAttributes; ++i) {
            if (attValues[i] == 0.0) continue;
            tempValues[vals] = attValues[i];
            tempIndices[vals] = i;
            ++vals;
        }
        this.m_AttValues = new double[vals];
        this.m_Indices = new int[vals];
        System.arraycopy(tempValues, 0, this.m_AttValues, 0, vals);
        System.arraycopy(tempIndices, 0, this.m_Indices, 0, vals);
    }

    public SparseInstance(double weight, double[] attValues, int[] indices, int maxNumValues) {
        int vals = 0;
        this.m_AttValues = new double[attValues.length];
        this.m_Indices = new int[indices.length];
        for (int i = 0; i < attValues.length; ++i) {
            if (attValues[i] == 0.0) continue;
            this.m_AttValues[vals] = attValues[i];
            this.m_Indices[vals] = indices[i];
            ++vals;
        }
        if (vals != attValues.length) {
            double[] newVals = new double[vals];
            System.arraycopy(this.m_AttValues, 0, newVals, 0, vals);
            this.m_AttValues = newVals;
            int[] newIndices = new int[vals];
            System.arraycopy(this.m_Indices, 0, newIndices, 0, vals);
            this.m_Indices = newIndices;
        }
        this.m_Weight = weight;
        this.m_NumAttributes = maxNumValues;
        this.m_Dataset = null;
    }

    public SparseInstance(int numAttributes) {
        this.m_AttValues = new double[numAttributes];
        this.m_NumAttributes = numAttributes;
        this.m_Indices = new int[numAttributes];
        for (int i = 0; i < this.m_AttValues.length; ++i) {
            this.m_AttValues[i] = Utils.missingValue();
            this.m_Indices[i] = i;
        }
        this.m_Weight = 1.0;
        this.m_Dataset = null;
    }

    @Override
    public Object copy() {
        SparseInstance result = new SparseInstance(this);
        result.m_Dataset = this.m_Dataset;
        return result;
    }

    @Override
    public Instance copy(double[] values) {
        SparseInstance result = new SparseInstance(this.m_Weight, values);
        result.m_Dataset = this.m_Dataset;
        return result;
    }

    @Override
    public int index(int position) {
        return this.m_Indices[position];
    }

    public int locateIndex(int index) {
        int min = 0;
        int max = this.m_Indices.length - 1;
        if (max == -1) {
            return -1;
        }
        while (this.m_Indices[min] <= index && this.m_Indices[max] >= index) {
            int current = (max + min) / 2;
            if (this.m_Indices[current] > index) {
                max = current - 1;
                continue;
            }
            if (this.m_Indices[current] < index) {
                min = current + 1;
                continue;
            }
            return current;
        }
        if (this.m_Indices[max] < index) {
            return max;
        }
        return min - 1;
    }

    @Override
    public Instance mergeInstance(Instance inst) {
        double[] values = new double[this.numValues() + inst.numValues()];
        int[] indices = new int[this.numValues() + inst.numValues()];
        int m = 0;
        int j = 0;
        while (j < this.numValues()) {
            values[m] = this.valueSparse(j);
            indices[m] = this.index(j);
            ++j;
            ++m;
        }
        j = 0;
        while (j < inst.numValues()) {
            values[m] = inst.valueSparse(j);
            indices[m] = this.numAttributes() + inst.index(j);
            ++j;
            ++m;
        }
        return new SparseInstance(1.0, values, indices, this.numAttributes() + inst.numAttributes());
    }

    @Override
    public int numAttributes() {
        return this.m_NumAttributes;
    }

    @Override
    public int numValues() {
        return this.m_Indices.length;
    }

    @Override
    public void replaceMissingValues(double[] array) {
        if (array == null || array.length != this.m_NumAttributes) {
            throw new IllegalArgumentException("Unequal number of attributes!");
        }
        double[] tempValues = new double[this.m_AttValues.length];
        int[] tempIndices = new int[this.m_AttValues.length];
        int vals = 0;
        for (int i = 0; i < this.m_AttValues.length; ++i) {
            if (this.isMissingSparse(i)) {
                if (array[this.m_Indices[i]] == 0.0) continue;
                tempValues[vals] = array[this.m_Indices[i]];
                tempIndices[vals] = this.m_Indices[i];
                ++vals;
                continue;
            }
            tempValues[vals] = this.m_AttValues[i];
            tempIndices[vals] = this.m_Indices[i];
            ++vals;
        }
        this.m_AttValues = new double[vals];
        this.m_Indices = new int[vals];
        System.arraycopy(tempValues, 0, this.m_AttValues, 0, vals);
        System.arraycopy(tempIndices, 0, this.m_Indices, 0, vals);
    }

    @Override
    public void setValue(int attIndex, double value) {
        int index = this.locateIndex(attIndex);
        if (index >= 0 && this.m_Indices[index] == attIndex) {
            if (value != 0.0) {
                double[] tempValues = new double[this.m_AttValues.length];
                System.arraycopy(this.m_AttValues, 0, tempValues, 0, this.m_AttValues.length);
                tempValues[index] = value;
                this.m_AttValues = tempValues;
            } else {
                double[] tempValues = new double[this.m_AttValues.length - 1];
                int[] tempIndices = new int[this.m_Indices.length - 1];
                System.arraycopy(this.m_AttValues, 0, tempValues, 0, index);
                System.arraycopy(this.m_Indices, 0, tempIndices, 0, index);
                System.arraycopy(this.m_AttValues, index + 1, tempValues, index, this.m_AttValues.length - index - 1);
                System.arraycopy(this.m_Indices, index + 1, tempIndices, index, this.m_Indices.length - index - 1);
                this.m_AttValues = tempValues;
                this.m_Indices = tempIndices;
            }
        } else if (value != 0.0) {
            double[] tempValues = new double[this.m_AttValues.length + 1];
            int[] tempIndices = new int[this.m_Indices.length + 1];
            System.arraycopy(this.m_AttValues, 0, tempValues, 0, index + 1);
            System.arraycopy(this.m_Indices, 0, tempIndices, 0, index + 1);
            tempIndices[index + 1] = attIndex;
            tempValues[index + 1] = value;
            System.arraycopy(this.m_AttValues, index + 1, tempValues, index + 2, this.m_AttValues.length - index - 1);
            System.arraycopy(this.m_Indices, index + 1, tempIndices, index + 2, this.m_Indices.length - index - 1);
            this.m_AttValues = tempValues;
            this.m_Indices = tempIndices;
        }
    }

    @Override
    public void setValueSparse(int indexOfIndex, double value) {
        if (value != 0.0) {
            double[] tempValues = new double[this.m_AttValues.length];
            System.arraycopy(this.m_AttValues, 0, tempValues, 0, this.m_AttValues.length);
            this.m_AttValues = tempValues;
            this.m_AttValues[indexOfIndex] = value;
        } else {
            double[] tempValues = new double[this.m_AttValues.length - 1];
            int[] tempIndices = new int[this.m_Indices.length - 1];
            System.arraycopy(this.m_AttValues, 0, tempValues, 0, indexOfIndex);
            System.arraycopy(this.m_Indices, 0, tempIndices, 0, indexOfIndex);
            System.arraycopy(this.m_AttValues, indexOfIndex + 1, tempValues, indexOfIndex, this.m_AttValues.length - indexOfIndex - 1);
            System.arraycopy(this.m_Indices, indexOfIndex + 1, tempIndices, indexOfIndex, this.m_Indices.length - indexOfIndex - 1);
            this.m_AttValues = tempValues;
            this.m_Indices = tempIndices;
        }
    }

    @Override
    public double[] toDoubleArray() {
        double[] newValues = new double[this.m_NumAttributes];
        for (int i = 0; i < this.m_AttValues.length; ++i) {
            newValues[this.m_Indices[i]] = this.m_AttValues[i];
        }
        return newValues;
    }

    @Override
    public String toStringNoWeight() {
        return this.toStringNoWeight(AbstractInstance.s_numericAfterDecimalPoint);
    }

    @Override
    public String toStringNoWeight(int afterDecimalPoint) {
        StringBuilder text = new StringBuilder();
        text.append('{');
        String prefix = "";
        int sparseIndex = 0;
        for (int i = 0; i < this.m_NumAttributes; ++i) {
            if (text.length() > 1) {
                prefix = ",";
            }
            double value = 0.0;
            try {
                if (sparseIndex < this.m_Indices.length && this.m_Indices[sparseIndex] == i && Utils.isMissingValue(value = this.m_AttValues[sparseIndex++])) {
                    text.append(prefix).append(i).append(" ?");
                    continue;
                }
                if (this.m_Dataset == null) {
                    if (value == 0.0) continue;
                    text.append(prefix).append(i).append(" ").append(Utils.doubleToString(value, afterDecimalPoint));
                    continue;
                }
                Attribute att = this.m_Dataset.attribute(i);
                if (att.isString()) {
                    text.append(prefix).append(i).append(" ").append(Utils.quote(att.value((int)value)));
                    continue;
                }
                if (att.isRelationValued()) {
                    text.append(prefix).append(i).append(" ").append(Utils.quote(att.relation((int)value).stringWithoutHeader()));
                    continue;
                }
                if (value == 0.0) continue;
                if (att.isNominal()) {
                    text.append(prefix).append(i).append(" ").append(Utils.quote(att.value((int)value)));
                    continue;
                }
                if (att.isDate()) {
                    text.append(prefix).append(i).append(" ").append(Utils.quote(att.formatDate(value)));
                    continue;
                }
                text.append(prefix).append(i).append(" ").append(Utils.doubleToString(value, afterDecimalPoint));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println(new Instances(this.m_Dataset, 0) + "\nAtt: " + i + " Val: " + value);
                throw new Error("This should never happen!");
            }
        }
        text.append('}');
        return text.toString();
    }

    @Override
    public double value(int attIndex) {
        int index = this.locateIndex(attIndex);
        if (index >= 0 && this.m_Indices[index] == attIndex) {
            return this.m_AttValues[index];
        }
        return 0.0;
    }

    @Override
    protected void forceDeleteAttributeAt(int position) {
        int index = this.locateIndex(position);
        --this.m_NumAttributes;
        if (index >= 0 && this.m_Indices[index] == position) {
            int[] tempIndices = new int[this.m_Indices.length - 1];
            double[] tempValues = new double[this.m_AttValues.length - 1];
            System.arraycopy(this.m_Indices, 0, tempIndices, 0, index);
            System.arraycopy(this.m_AttValues, 0, tempValues, 0, index);
            for (int i = index; i < this.m_Indices.length - 1; ++i) {
                tempIndices[i] = this.m_Indices[i + 1] - 1;
                tempValues[i] = this.m_AttValues[i + 1];
            }
            this.m_Indices = tempIndices;
            this.m_AttValues = tempValues;
        } else {
            int[] tempIndices = new int[this.m_Indices.length];
            double[] tempValues = new double[this.m_AttValues.length];
            System.arraycopy(this.m_Indices, 0, tempIndices, 0, index + 1);
            System.arraycopy(this.m_AttValues, 0, tempValues, 0, index + 1);
            for (int i = index + 1; i < this.m_Indices.length; ++i) {
                tempIndices[i] = this.m_Indices[i] - 1;
                tempValues[i] = this.m_AttValues[i];
            }
            this.m_Indices = tempIndices;
            this.m_AttValues = tempValues;
        }
    }

    @Override
    protected void forceInsertAttributeAt(int position) {
        int index = this.locateIndex(position);
        ++this.m_NumAttributes;
        if (index >= 0 && this.m_Indices[index] == position) {
            int[] tempIndices = new int[this.m_Indices.length + 1];
            double[] tempValues = new double[this.m_AttValues.length + 1];
            System.arraycopy(this.m_Indices, 0, tempIndices, 0, index);
            System.arraycopy(this.m_AttValues, 0, tempValues, 0, index);
            tempIndices[index] = position;
            tempValues[index] = Utils.missingValue();
            for (int i = index; i < this.m_Indices.length; ++i) {
                tempIndices[i + 1] = this.m_Indices[i] + 1;
                tempValues[i + 1] = this.m_AttValues[i];
            }
            this.m_Indices = tempIndices;
            this.m_AttValues = tempValues;
        } else {
            int[] tempIndices = new int[this.m_Indices.length + 1];
            double[] tempValues = new double[this.m_AttValues.length + 1];
            System.arraycopy(this.m_Indices, 0, tempIndices, 0, index + 1);
            System.arraycopy(this.m_AttValues, 0, tempValues, 0, index + 1);
            tempIndices[index + 1] = position;
            tempValues[index + 1] = Utils.missingValue();
            for (int i = index + 1; i < this.m_Indices.length; ++i) {
                tempIndices[i + 1] = this.m_Indices[i] + 1;
                tempValues[i + 1] = this.m_AttValues[i];
            }
            this.m_Indices = tempIndices;
            this.m_AttValues = tempValues;
        }
    }

    protected SparseInstance() {
    }

    public static void main(String[] options) {
        try {
            int i;
            Attribute length = new Attribute("length");
            Attribute weight = new Attribute("weight");
            ArrayList<String> my_nominal_values = new ArrayList<String>(3);
            my_nominal_values.add("first");
            my_nominal_values.add("second");
            my_nominal_values.add("third");
            Attribute position = new Attribute("position", my_nominal_values);
            ArrayList<Attribute> attributes = new ArrayList<Attribute>(3);
            attributes.add(length);
            attributes.add(weight);
            attributes.add(position);
            Instances race = new Instances("race", attributes, 0);
            race.setClassIndex(position.index());
            SparseInstance inst = new SparseInstance(3);
            inst.setValue(length, 5.3);
            inst.setValue(weight, 300.0);
            inst.setValue(position, "first");
            inst.setDataset(race);
            System.out.println("The instance: " + inst);
            System.out.println("First attribute: " + inst.attribute(0));
            System.out.println("Class attribute: " + inst.classAttribute());
            System.out.println("Class index: " + inst.classIndex());
            System.out.println("Class is missing: " + inst.classIsMissing());
            System.out.println("Class value (internal format): " + inst.classValue());
            SparseInstance copy = (SparseInstance)inst.copy();
            System.out.println("Shallow copy: " + copy);
            copy.setDataset(inst.dataset());
            System.out.println("Shallow copy with dataset set: " + copy);
            System.out.print("All stored values in internal format: ");
            for (i = 0; i < inst.numValues(); ++i) {
                if (i > 0) {
                    System.out.print(",");
                }
                System.out.print(inst.valueSparse(i));
            }
            System.out.println();
            System.out.print("All values set to zero: ");
            while (inst.numValues() > 0) {
                inst.setValueSparse(0, 0.0);
            }
            for (i = 0; i < inst.numValues(); ++i) {
                if (i > 0) {
                    System.out.print(",");
                }
                System.out.print(inst.valueSparse(i));
            }
            System.out.println();
            System.out.print("All values set to one: ");
            for (i = 0; i < inst.numAttributes(); ++i) {
                inst.setValue(i, 1.0);
            }
            for (i = 0; i < inst.numValues(); ++i) {
                if (i > 0) {
                    System.out.print(",");
                }
                System.out.print(inst.valueSparse(i));
            }
            System.out.println();
            copy.setDataset(null);
            copy.deleteAttributeAt(0);
            copy.insertAttributeAt(0);
            copy.setDataset(inst.dataset());
            System.out.println("Copy with first attribute deleted and inserted: " + copy);
            copy.setDataset(null);
            copy.deleteAttributeAt(1);
            copy.insertAttributeAt(1);
            copy.setDataset(inst.dataset());
            System.out.println("Copy with second attribute deleted and inserted: " + copy);
            copy.setDataset(null);
            copy.deleteAttributeAt(2);
            copy.insertAttributeAt(2);
            copy.setDataset(inst.dataset());
            System.out.println("Copy with third attribute deleted and inserted: " + copy);
            System.out.println("Enumerating attributes (leaving out class):");
            Enumeration<Attribute> enu = inst.enumerateAttributes();
            while (enu.hasMoreElements()) {
                Attribute att = enu.nextElement();
                System.out.println(att);
            }
            System.out.println("Header of original and copy equivalent: " + inst.equalHeaders(copy));
            System.out.println("Length of copy missing: " + copy.isMissing(length));
            System.out.println("Weight of copy missing: " + copy.isMissing(weight.index()));
            System.out.println("Length of copy missing: " + Utils.isMissingValue(copy.value(length)));
            System.out.println("Number of attributes: " + copy.numAttributes());
            System.out.println("Number of classes: " + copy.numClasses());
            double[] meansAndModes = new double[]{2.0, 3.0, 0.0};
            copy.replaceMissingValues(meansAndModes);
            System.out.println("Copy with missing value replaced: " + copy);
            copy.setClassMissing();
            System.out.println("Copy with missing class: " + copy);
            copy.setClassValue(0.0);
            System.out.println("Copy with class value set to first value: " + copy);
            copy.setClassValue("third");
            System.out.println("Copy with class value set to \"third\": " + copy);
            copy.setMissing(1);
            System.out.println("Copy with second attribute set to be missing: " + copy);
            copy.setMissing(length);
            System.out.println("Copy with length set to be missing: " + copy);
            copy.setValue(0, 0.0);
            System.out.println("Copy with first attribute set to 0: " + copy);
            copy.setValue(weight, 1.0);
            System.out.println("Copy with weight attribute set to 1: " + copy);
            copy.setValue(position, "second");
            System.out.println("Copy with position set to \"second\": " + copy);
            copy.setValue(2, "first");
            System.out.println("Copy with last attribute set to \"first\": " + copy);
            System.out.println("Current weight of instance copy: " + copy.weight());
            copy.setWeight(2.0);
            System.out.println("Current weight of instance copy (set to 2): " + copy.weight());
            System.out.println("Last value of copy: " + copy.toString(2));
            System.out.println("Value of position for copy: " + copy.toString(position));
            System.out.println("Last value of copy (internal format): " + copy.value(2));
            System.out.println("Value of position for copy (internal format): " + copy.value(position));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 14605 $");
    }
}

