/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Model;

import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Model.Model;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Node.IntDouble;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Node.NodeRuleBase;
import keel.Algorithms.Fuzzy_Rule_Learning.Shared.Fuzzy.FuzzyAlphaCut;
import keel.Algorithms.Fuzzy_Rule_Learning.Shared.Fuzzy.FuzzyNumberTRIANG;
import keel.Algorithms.Fuzzy_Rule_Learning.Shared.Fuzzy.FuzzyPartition;

public class FuzzyGPModel
extends Model {
    NodeRuleBase R;
    static FuzzyPartition C;
    int defuzType;

    public FuzzyGPModel(NodeRuleBase pR, FuzzyPartition c, int td) {
        this.R = (NodeRuleBase)pR.clone();
        C = c.clone();
        this.defuzType = td;
    }

    public FuzzyGPModel(FuzzyGPModel mb) {
        this.R = (NodeRuleBase)mb.R.clone();
        C = C.clone();
        this.defuzType = mb.defuzType;
    }

    public void set(FuzzyGPModel mb) {
        this.R = (NodeRuleBase)mb.R.clone();
        C = C.clone();
        this.defuzType = mb.defuzType;
    }

    @Override
    public Model clone() {
        return new FuzzyGPModel(this);
    }

    @Override
    public void debug() {
        this.R.debug();
    }

    @Override
    public double output(double[] x) {
        FuzzyAlphaCut[] xfuzzy = new FuzzyAlphaCut[x.length];
        for (int i = 0; i < x.length; ++i) {
            xfuzzy[i] = new FuzzyAlphaCut(new FuzzyNumberTRIANG(x[i], x[i], x[i]));
        }
        this.R.replaceTerminals(xfuzzy);
        IntDouble[] result = this.R.CrispEval();
        if (this.defuzType == 0) {
            double addcenter = 0.0;
            double addweight = 0.0;
            for (int i = 0; i < result.length; ++i) {
                addcenter += C.getComponent(result[i].consequent).massCentre() * result[i].weight;
                addweight += result[i].weight;
            }
            if (addweight == 0.0) {
                return 0.0;
            }
            return addcenter / addweight;
        }
        if (this.defuzType == 1) {
            double center = 0.0;
            double maxweight = 0.0;
            for (int i = 0; i < result.length; ++i) {
                if (!(result[i].weight >= maxweight)) continue;
                maxweight = result[i].weight;
                center = C.getComponent(result[i].consequent).massCentre();
            }
            if (maxweight == 0.0) {
                return 0.0;
            }
            return center;
        }
        return 0.0;
    }
}

