/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.PNN;

import java.util.HashMap;
import keel.Algorithms.Instance_Generation.Basic.Prototype;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerationAlgorithm;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerator;
import keel.Algorithms.Instance_Generation.Basic.PrototypeSet;
import keel.Algorithms.Instance_Generation.PNN.MatrixOfDistances;
import keel.Algorithms.Instance_Generation.utilities.Debug;
import keel.Algorithms.Instance_Generation.utilities.KNN.KNN;
import keel.Algorithms.Instance_Generation.utilities.Pair;
import keel.Algorithms.Instance_Generation.utilities.Parameters;

public class PNNGenerator
extends PrototypeGenerator {
    protected boolean useNumberOfPrototypes = false;
    protected int numberOfPrototypes = 10;

    public PNNGenerator(PrototypeSet tSet) {
        super(tSet);
        this.algorithmName = "PNN";
        this.useNumberOfPrototypes = false;
    }

    public PNNGenerator(PrototypeSet tSet, int numberOfProts) {
        super(tSet);
        this.useNumberOfPrototypes = true;
        Debug.force(numberOfProts < tSet.size(), "Number of prototypes desired is bigger than actual size of the training data set");
        this.numberOfPrototypes = numberOfProts;
        this.algorithmName = "PNN";
    }

    public PNNGenerator(PrototypeSet tSet, double percentageOfPrototypes) {
        super(tSet);
        this.useNumberOfPrototypes = true;
        this.numberOfPrototypes = this.getSetSizeFromPercentage(percentageOfPrototypes);
        this.algorithmName = "PNN";
    }

    public PNNGenerator(PrototypeSet _trainingDataSet, Parameters parameters) {
        super(_trainingDataSet, parameters);
        this.algorithmName = "PNN";
        this.useNumberOfPrototypes = false;
        if (parameters.existMore()) {
            this.useNumberOfPrototypes = true;
            this.numberOfPrototypes = parameters.getNextAsInt();
        }
    }

    protected Pair<Prototype, Prototype> nearestPrototypesIn(PrototypeSet A, PrototypeSet B, MatrixOfDistances m) {
        double minimumDist = Double.MAX_VALUE;
        Pair<Prototype, Prototype> nearest = new Pair<Prototype, Prototype>((Prototype)A.get(0), (Prototype)B.get(0));
        for (Prototype a : A) {
            for (Prototype b : B) {
                double dist = m.get(a, b);
                if (!(dist < minimumDist)) continue;
                minimumDist = dist;
                nearest = new Pair<Prototype, Prototype>(a, b);
            }
        }
        return nearest;
    }

    protected PrototypeSet maximumReduction() {
        PrototypeSet A = new PrototypeSet();
        PrototypeSet B = this.trainingDataSet.copy();
        HashMap<Prototype, Double> W = new HashMap<Prototype, Double>();
        for (Prototype b : B) {
            W.put(b, 1.0);
        }
        int counterOfMerges = 0;
        do {
            Prototype arbitraryPoint = B.removeRandom();
            A.add(arbitraryPoint);
            counterOfMerges = 0;
            MatrixOfDistances dist = new MatrixOfDistances(A, B);
            while (B.size() > 0) {
                Pair<Prototype, Prototype> nearest = this.nearestPrototypesIn(A, B, dist);
                Prototype p = nearest.first();
                Prototype q = nearest.second();
                if (p.label() == q.label()) {
                    Prototype pStar = Prototype.avg(p, (Double)W.get(p), q, (Double)W.get(q));
                    int currentAccuracy = PNNGenerator.absoluteAccuracy(A.join(q), this.trainingDataSet);
                    int newAccuracy = PNNGenerator.absoluteAccuracy(A.join(pStar), this.trainingDataSet);
                    if (newAccuracy < currentAccuracy) {
                        A.add(q);
                        B.remove(q);
                        continue;
                    }
                    W.put(pStar, (Double)W.get(p) + (Double)W.get(q));
                    A.remove(p);
                    B.remove(q);
                    dist.removeFromA(p);
                    dist.removeFromB(q);
                    A.add(pStar);
                    dist.addToA(pStar);
                    ++counterOfMerges;
                    continue;
                }
                A.add(q);
                B.remove(q);
            }
            if (counterOfMerges <= 0) continue;
            B = A;
            A = new PrototypeSet();
        } while (counterOfMerges > 0);
        return A;
    }

    protected PrototypeSet controlledReduction() {
        PrototypeSet A = new PrototypeSet();
        PrototypeSet B = this.trainingDataSet.copy();
        HashMap<Prototype, Double> W = new HashMap<Prototype, Double>();
        for (Prototype b : B) {
            W.put(b, 1.0);
        }
        int counterOfMerges = 0;
        boolean sizeReached = false;
        do {
            Prototype arbitraryPoint = B.removeRandom();
            A.add(arbitraryPoint);
            counterOfMerges = 0;
            MatrixOfDistances dist = new MatrixOfDistances(A, B);
            while (B.size() > 0 && !sizeReached) {
                Pair<Prototype, Prototype> nearest = this.nearestPrototypesIn(A, B, dist);
                Prototype p = nearest.first();
                Prototype q = nearest.second();
                if (p.label() == q.label()) {
                    Prototype pStar = Prototype.avg(p, (Double)W.get(p), q, (Double)W.get(q));
                    W.put(pStar, (Double)W.get(p) + (Double)W.get(q));
                    int currentAccuracy = PNNGenerator.absoluteAccuracy(A.join(q), this.trainingDataSet);
                    int newAccuracy = PNNGenerator.absoluteAccuracy(A.join(pStar), this.trainingDataSet);
                    if (newAccuracy < currentAccuracy) {
                        A.add(q);
                        B.remove(q);
                    } else {
                        A.remove(p);
                        B.remove(q);
                        dist.removeFromA(p);
                        dist.removeFromB(q);
                        A.add(pStar);
                        dist.addToA(pStar);
                        ++counterOfMerges;
                    }
                } else {
                    A.add(q);
                    B.remove(q);
                }
                sizeReached = A.size() == this.numberOfPrototypes;
            }
            if (counterOfMerges <= 0 || sizeReached) continue;
            B = A;
            A = new PrototypeSet();
        } while (counterOfMerges > 0 && !sizeReached);
        return A;
    }

    @Override
    public PrototypeSet reduceSet() {
        PrototypeSet reduced = null;
        reduced = this.useNumberOfPrototypes ? this.controlledReduction() : this.maximumReduction();
        return reduced;
    }

    public static void main(String[] args) {
        Debug.setStdDebugMode(false);
        Parameters.setUse("PNN", "<seed> [percentageOfPrototypes]");
        Parameters.assertBasicArgs(args);
        PrototypeSet training = PrototypeGenerationAlgorithm.readPrototypeSet(args[0]);
        PrototypeSet test = PrototypeGenerationAlgorithm.readPrototypeSet(args[1]);
        long seed = Parameters.assertExtendedArgAsInt(args, 2, "seed", 0.0, 9.223372036854776E18);
        PNNGenerator.setSeed(seed);
        PNNGenerator generator = null;
        if (args.length >= 4) {
            double pc = Parameters.assertExtendedArgAsDouble(args, 3, "percentage of prototypes", 0.0, 100.0);
            generator = new PNNGenerator(training, pc);
        } else {
            generator = new PNNGenerator(training);
        }
        PrototypeSet resultingSet = generator.execute();
        int accuracy1NN = KNN.classficationAccuracy1NN(resultingSet, test);
        generator.showResultsOfAccuracy(Parameters.getFileName(), accuracy1NN, test);
    }
}

