/*
 * Decompiled with CFR 0.152.
 */
package javolution.lang;

import javolution.lang.MathLib;
import javolution.lang.TextBuilder;

public final class CharSet {
    public static final CharSet EMPTY = new CharSet(new long[0]);
    public static final CharSet WHITESPACES = CharSet.valueOf('\t', '\n', '\u000b', '\f', '\r', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '\u1680', '\u180e', '\u2000', '\u2001', '\u2002', '\u2003', '\u2004', '\u2005', '\u2006', '\u2008', '\u2009', '\u200a', '\u200b', '\u2028', '\u2029', '\u205f', '\u3000');
    public static final CharSet SPACES = CharSet.valueOf(' ', '\u00a0', '\u1680', '\u180e', '\u2000', '\u2001', '\u2002', '\u2003', '\u2004', '\u2005', '\u2006', '\u2007', '\u2008', '\u2009', '\u200a', '\u200b', '\u2028', '\u2029', '\u202f', '\u205f', '\u3000');
    public static final CharSet ISO_CONTROLS = CharSet.valueOf('\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', '\u007f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\u0085', '\u0086', '\u0087', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u008d', '\u008e', '\u008f', '\u0090', '\u0091', '\u0092', '\u0093', '\u0094', '\u0095', '\u0096', '\u0097', '\u0098', '\u0099', '\u009a', '\u009b', '\u009c', '\u009d', '\u009e', '\u009f');
    private final long[] _mapping;

    private CharSet(long[] lArray) {
        this._mapping = lArray;
    }

    public static CharSet valueOf(char ... cArray) {
        char c = '\u0000';
        int n = cArray.length;
        while (--n >= 0) {
            if (cArray[n] <= c) continue;
            c = cArray[n];
        }
        CharSet charSet = new CharSet(new long[(c >> 6) + 1]);
        int n2 = cArray.length;
        while (--n2 >= 0) {
            char c2 = cArray[n2];
            int n3 = c2 >> 6;
            charSet._mapping[n3] = charSet._mapping[n3] | 1L << (c2 & 0x3F);
        }
        return charSet;
    }

    public static CharSet rangeOf(char c, char c2) {
        if (c > c2) {
            throw new IllegalArgumentException("first should be less or equal to last");
        }
        CharSet charSet = new CharSet(new long[(c2 >> 6) + 1]);
        for (char c3 = c; c3 <= c2; c3 = (char)(c3 + '\u0001')) {
            int n = c3 >> 6;
            charSet._mapping[n] = charSet._mapping[n] | 1L << (c3 & 0x3F);
        }
        return charSet;
    }

    public boolean contains(char c) {
        int n = c >> 6;
        return n < this._mapping.length ? (this._mapping[n] & 1L << (c & 0x3F)) != 0L : false;
    }

    public CharSet plus(CharSet charSet) {
        if (charSet._mapping.length > this._mapping.length) {
            return charSet.plus(this);
        }
        CharSet charSet2 = this.copy();
        int n = charSet._mapping.length;
        while (--n >= 0) {
            int n2 = n;
            charSet2._mapping[n2] = charSet2._mapping[n2] | charSet._mapping[n];
        }
        return charSet2;
    }

    public CharSet minus(CharSet charSet) {
        CharSet charSet2 = this.copy();
        int n = MathLib.min(this._mapping.length, charSet._mapping.length);
        while (--n >= 0) {
            int n2 = n;
            charSet2._mapping[n2] = charSet2._mapping[n2] & (charSet._mapping[n] ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return charSet2;
    }

    public String toString() {
        TextBuilder textBuilder = TextBuilder.newInstance();
        textBuilder.append('{');
        int n = this._mapping.length << 6;
        for (int i = 0; i < n; ++i) {
            if (!this.contains((char)i)) continue;
            if (textBuilder.length() > 1) {
                textBuilder.append(',');
                textBuilder.append(' ');
            }
            textBuilder.append('\'');
            textBuilder.append((char)i);
            textBuilder.append('\'');
        }
        textBuilder.append('}');
        return textBuilder.toString();
    }

    private CharSet copy() {
        CharSet charSet = new CharSet(new long[this._mapping.length]);
        int n = this._mapping.length;
        while (--n >= 0) {
            charSet._mapping[n] = this._mapping[n];
        }
        return charSet;
    }
}

