/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.SingleClassifierEnhancer;
import weka.classifiers.trees.J48;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Discretize;

public class RegressionByDiscretization
extends SingleClassifierEnhancer {
    static final long serialVersionUID = 5066426153134050375L;
    protected Discretize m_Discretizer = new Discretize();
    protected int m_NumBins = 10;
    protected double[] m_ClassMeans;

    public String globalInfo() {
        return "A regression scheme that employs any classifier on a copy of the data that has the class attribute (equal-width) discretized. The predicted value is the expected value of the mean class value for each discretized interval (based on the predicted probabilities for each interval).";
    }

    protected String defaultClassifierString() {
        return "weka.classifiers.trees.J48";
    }

    public RegressionByDiscretization() {
        this.m_Classifier = new J48();
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.disableAllClasses();
        capabilities.disableAllClassDependencies();
        capabilities.enable(Capabilities.Capability.NUMERIC_CLASS);
        capabilities.enable(Capabilities.Capability.DATE_CLASS);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        int n;
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        this.m_Discretizer.setIgnoreClass(true);
        this.m_Discretizer.setAttributeIndices("" + (instances.classIndex() + 1));
        this.m_Discretizer.setBins(this.getNumBins());
        this.m_Discretizer.setInputFormat(instances);
        Instances instances2 = Filter.useFilter(instances, this.m_Discretizer);
        int n2 = instances2.numClasses();
        this.m_ClassMeans = new double[n2];
        int[] nArray = new int[n2];
        for (n = 0; n < instances.numInstances(); ++n) {
            int n3;
            Instance instance = instances2.instance(n);
            if (instance.classIsMissing()) continue;
            int n4 = n3 = (int)instance.classValue();
            nArray[n4] = nArray[n4] + 1;
            int n5 = n3;
            this.m_ClassMeans[n5] = this.m_ClassMeans[n5] + instances.instance(n).classValue();
        }
        for (n = 0; n < n2; ++n) {
            if (nArray[n] <= 0) continue;
            int n6 = n;
            this.m_ClassMeans[n6] = this.m_ClassMeans[n6] / (double)nArray[n];
        }
        if (this.m_Debug) {
            System.out.println("Bin Means");
            System.out.println("==========");
            for (n = 0; n < this.m_ClassMeans.length; ++n) {
                System.out.println(this.m_ClassMeans[n]);
            }
            System.out.println();
        }
        this.m_Classifier.buildClassifier(instances2);
    }

    public double classifyInstance(Instance instance) throws Exception {
        if (this.m_Discretizer.numPendingOutput() > 0) {
            throw new Exception("Discretize output queue not empty");
        }
        if (this.m_Discretizer.input(instance)) {
            this.m_Discretizer.batchFinished();
            Instance instance2 = this.m_Discretizer.output();
            double[] dArray = this.m_Classifier.distributionForInstance(instance2);
            double d = 0.0;
            double d2 = 0.0;
            for (int i = 0; i < dArray.length; ++i) {
                d += dArray[i] * this.m_ClassMeans[i];
                d2 += dArray[i];
            }
            return d / d2;
        }
        throw new Exception("Discretize didn't make the test instance immediately available");
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(1);
        vector.addElement(new Option("\tNumber of bins for equal-width discretization\n\t(default 10).\n", "B", 1, "-B <int>"));
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('B', stringArray);
        if (string.length() != 0) {
            this.setNumBins(Integer.parseInt(string));
        } else {
            this.setNumBins(10);
        }
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = super.getOptions();
        String[] stringArray2 = new String[stringArray.length + 2];
        int n = 0;
        stringArray2[n++] = "-I";
        stringArray2[n++] = "" + this.getNumBins();
        System.arraycopy(stringArray, 0, stringArray2, n, stringArray.length);
        return stringArray2;
    }

    public String numBinsTipText() {
        return "Number of bins for discretization.";
    }

    public int getNumBins() {
        return this.m_NumBins;
    }

    public void setNumBins(int n) {
        this.m_NumBins = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Regression by discretization");
        if (this.m_ClassMeans == null) {
            stringBuffer.append(": No model built yet.");
        } else {
            stringBuffer.append("\n\nClass attribute discretized into " + this.m_ClassMeans.length + " values\n");
            stringBuffer.append("\nClassifier spec: " + this.getClassifierSpec() + "\n");
            stringBuffer.append(this.m_Classifier.toString());
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        RegressionByDiscretization.runClassifier(new RegressionByDiscretization(), stringArray);
    }
}

