/*
 * Decompiled with CFR 0.152.
 */
package javalain.math.fonction.multiobjectif;

import java.util.Comparator;
import javalain.ea.SolutionEA;
import javalain.ea.operator.comparator.DominanceMinComparator;
import javalain.math.Calcul;
import javalain.math.fonction.Fct;

public final class ZDT2
extends Fct {
    public ZDT2() {
        this(30);
    }

    public ZDT2(int nbVariable) {
        this.nomFct = "ZDT2";
        this.nbVariable = nbVariable;
        this.nbFctObjectif = 2;
        this.lowerLimit = new double[this.nbVariable];
        this.upperLimit = new double[this.nbVariable];
        for (int i = 0; i < this.nbVariable; ++i) {
            this.lowerLimit[i] = 0.0;
            this.upperLimit[i] = 1.0;
        }
    }

    @Override
    public double[] compute(double[] x) {
        double[] fct = new double[this.nbFctObjectif];
        double g = ZDT2.g(x);
        fct[0] = x[0];
        fct[1] = g * ZDT2.f(fct[0], g);
        return fct;
    }

    @Override
    public double[][] getFront() {
        if (this.front == null) {
            this.readParetoFront("ZDT2.pf");
        }
        return this.front;
    }

    private static double g(double[] x) {
        double somme = 0.0;
        for (int i = 1; i < x.length; ++i) {
            somme += x[i];
        }
        return 1.0 + somme * 9.0 / (double)(x.length - 1);
    }

    private static double f(double f1, double g) {
        return 1.0 - Calcul.pow2(f1 / g);
    }

    @Override
    public Comparator<SolutionEA> comparator() {
        return new DominanceMinComparator();
    }
}

