/*
 * Decompiled with CFR 0.152.
 */
package com.portfolioeffect.quant.client.api;

import com.portfolioeffect.quant.client.api.Forecast;
import com.portfolioeffect.quant.client.api.Metric;
import com.portfolioeffect.quant.client.model.ComputeErrorException;
import com.portfolioeffect.quant.client.portfolio.Portfolio;
import com.portfolioeffect.quant.client.portfolio.optimizer.ForecastedValues;
import com.portfolioeffect.quant.client.portfolio.optimizer.PortfolioOptimizer;
import com.portfolioeffect.quant.client.portfolio.optimizer.StrategyOptimizer;
import com.portfolioeffect.quant.client.result.LazyMetric;
import com.portfolioeffect.quant.client.util.LinearForecastBuilder;

public class Optimizer {
    private Portfolio portfolio;
    private PortfolioOptimizer optimizer;
    private boolean wrongPortfolioMode;

    public Optimizer(Metric goal, String direction, double approxError, double optimumProbability) {
        this.portfolio = goal.getMetric().getPortfolio();
        boolean isStrategyOptimizer = this.portfolio.getPortfolioMetricsMode().equals("portfolio") || this.portfolio.getPortfolioMetricsMode().equals("");
        this.optimizer = isStrategyOptimizer ? new StrategyOptimizer(this.portfolio) : new PortfolioOptimizer(this.portfolio);
        this.optimizer.setOptimizationGoal(goal.getMetric(), direction);
        this.optimizer.setErrorInDecimalPoints(approxError);
        this.optimizer.setGlobalOptimumProbability(optimumProbability);
        if (isStrategyOptimizer) {
            LinearForecastBuilder builder = new LinearForecastBuilder();
            builder.setRollingWindow("1s");
            builder.setRegressionUpdateInterval("1s");
            builder.setForecastStep("1s");
            ((StrategyOptimizer)this.optimizer).setForecastBuilder(builder);
            ((StrategyOptimizer)this.optimizer).setForecastStep(this.portfolio.getSamplingInterval());
        }
    }

    public Optimizer(Metric goal, String direction) {
        this(goal, direction, 1.0E-12, 0.99);
    }

    public void setForecastStep(String step) {
        ((StrategyOptimizer)this.optimizer).setForecastStep(step);
    }

    public Metric run() throws ComputeErrorException {
        if (this.wrongPortfolioMode) {
            return new Metric(new LazyMetric("Wrong portfolio mode for using forecast."));
        }
        return new Metric(this.optimizer.getOptimizedPortfolio());
    }

    public Optimizer constraint(Metric constraintMertic, String constraintType, double constraintValue) {
        this.optimizer.addConstraint(constraintMertic.getMetric(), constraintType, constraintValue);
        return this;
    }

    public Optimizer setForecast(Forecast forecast) {
        try {
            ((StrategyOptimizer)this.optimizer).setExpectedReturnForecastBuilder(forecast.getBuilder());
            ((StrategyOptimizer)this.optimizer).setBetaForecastBuilder(forecast.getBuilder());
            ((StrategyOptimizer)this.optimizer).setVarianceForecastBuilder(forecast.getBuilder());
            ((StrategyOptimizer)this.optimizer).setCumulant3ForecastBuilder(forecast.getBuilder());
            ((StrategyOptimizer)this.optimizer).setCumulant4ForecastBuilder(forecast.getBuilder());
        }
        catch (ClassCastException e) {
            this.wrongPortfolioMode = true;
        }
        return this;
    }

    public Optimizer forecast(String metricType, Forecast forecast) {
        if (metricType.equals("ExpReturn")) {
            ((StrategyOptimizer)this.optimizer).setExpectedReturnForecastBuilder(forecast.getBuilder());
            return this;
        }
        if (metricType.equals("Beta")) {
            ((StrategyOptimizer)this.optimizer).setBetaForecastBuilder(forecast.getBuilder());
            return this;
        }
        if (metricType.equals("Variance")) {
            ((StrategyOptimizer)this.optimizer).setVarianceForecastBuilder(forecast.getBuilder());
            return this;
        }
        if (metricType.equals("Cumulant3")) {
            ((StrategyOptimizer)this.optimizer).setCumulant3ForecastBuilder(forecast.getBuilder());
            return this;
        }
        if (metricType.equals("Cumulant4")) {
            ((StrategyOptimizer)this.optimizer).setCumulant4ForecastBuilder(forecast.getBuilder());
            return this;
        }
        return this;
    }

    public Optimizer forecast(String metricType, String symbol, double[] value, long[] time) {
        ForecastedValues forecastedValues = new ForecastedValues(this.portfolio);
        if (metricType.equals("ExpReturn")) {
            forecastedValues.setSymbolForecastedExpReturn(symbol, value, time);
            return this;
        }
        if (metricType.equals("Beta")) {
            forecastedValues.setSymbolForecastedBeta(symbol, value, time);
            return this;
        }
        if (metricType.equals("Variance")) {
            forecastedValues.setSymbolForecastedVariance(symbol, value, time);
            return this;
        }
        if (metricType.equals("Cumulant3")) {
            forecastedValues.setSymbolForecastedCumulant3(symbol, value, time);
            return this;
        }
        if (metricType.equals("Cumulant4")) {
            forecastedValues.setSymbolForecastedCumulant4(symbol, value, time);
            return this;
        }
        ((StrategyOptimizer)this.optimizer).setForecastedValue(forecastedValues);
        return this;
    }
}

