/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.template.type.codec;

import java.io.IOException;
import java.io.InputStream;
import org.openfast.ByteVectorValue;
import org.openfast.Global;
import org.openfast.IntegerValue;
import org.openfast.ScalarValue;
import org.openfast.error.FastConstants;
import org.openfast.template.type.codec.IntegerCodec;
import org.openfast.template.type.codec.TypeCodec;

final class ByteVectorType
extends TypeCodec {
    private static final long serialVersionUID = 1L;

    ByteVectorType() {
    }

    public byte[] encode(ScalarValue value) {
        byte[] bytes = value.getBytes();
        int lengthSize = IntegerCodec.getUnsignedIntegerSize(bytes.length);
        byte[] encoding = new byte[bytes.length + lengthSize];
        byte[] length = TypeCodec.UINT.encode(new IntegerValue(bytes.length));
        System.arraycopy(length, 0, encoding, 0, lengthSize);
        System.arraycopy(bytes, 0, encoding, lengthSize, bytes.length);
        return encoding;
    }

    public ScalarValue decode(InputStream in) {
        int length = ((IntegerValue)TypeCodec.UINT.decode((InputStream)in)).value;
        byte[] encoding = new byte[length];
        int i = 0;
        while (i < length) {
            int nextByte;
            block4: {
                try {
                    nextByte = in.read();
                    if (nextByte >= 0) break block4;
                    Global.handleError(FastConstants.END_OF_STREAM, "The end of the input stream has been reached.");
                    return null;
                }
                catch (IOException e) {
                    Global.handleError(FastConstants.IO_ERROR, "A IO error has been encountered while decoding.", e);
                    return null;
                }
            }
            encoding[i] = (byte)nextByte;
            ++i;
        }
        return new ByteVectorValue(encoding);
    }

    public byte[] encodeValue(ScalarValue value) {
        throw new UnsupportedOperationException();
    }

    public ScalarValue fromString(String value) {
        return new ByteVectorValue(value.getBytes());
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass();
    }
}

