/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.solver.preconditioner;

import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.solver.preconditioner.FloatPreconditioner;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;

public class FloatDiagonal
implements FloatPreconditioner {
    private float[] invdiag;

    public FloatDiagonal(int n) {
        this.invdiag = new float[n];
    }

    public FloatMatrix1D apply(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) {
        if (floatMatrix1D2 == null) {
            floatMatrix1D2 = floatMatrix1D.like();
        }
        if (!(floatMatrix1D2 instanceof DenseFloatMatrix1D) || !(floatMatrix1D instanceof DenseFloatMatrix1D)) {
            throw new IllegalArgumentException("a nad b must be dense vectors");
        }
        float[] fArray = ((DenseFloatMatrix1D)floatMatrix1D2).elements();
        float[] fArray2 = ((DenseFloatMatrix1D)floatMatrix1D).elements();
        for (int i = 0; i < this.invdiag.length; ++i) {
            fArray[i] = fArray2[i] * this.invdiag[i];
        }
        return floatMatrix1D2;
    }

    public FloatMatrix1D transApply(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) {
        if (floatMatrix1D2 == null) {
            floatMatrix1D2 = floatMatrix1D.like();
        }
        return this.apply(floatMatrix1D, floatMatrix1D2);
    }

    public void setMatrix(FloatMatrix2D floatMatrix2D) {
        if (floatMatrix2D.rows() != this.invdiag.length) {
            throw new IllegalArgumentException("Matrix size differs from preconditioner size");
        }
        for (int i = 0; i < this.invdiag.length; ++i) {
            this.invdiag[i] = floatMatrix2D.getQuick(i, i);
            if (this.invdiag[i] == 0.0f) {
                throw new RuntimeException("Zero diagonal on row " + (i + 1));
            }
            this.invdiag[i] = 1.0f / this.invdiag[i];
        }
    }
}

