/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core;

import com.amazon.redshift.api.PGDataTypeUtilities;
import com.amazon.redshift.api.PGTimestamp;
import com.amazon.support.exceptions.ErrorException;
import java.io.ByteArrayOutputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class PGArrayParser {
    static final byte UTF8LEFTCURLYBRACE = 123;
    static final byte UTF8RIGHTCURLYBRACE = 125;
    static final byte UTF8DOUBLEQUOTE = 34;
    static final byte UTF8COMMA = 44;
    static final byte UTF8BACKSLASH = 92;

    private static List<?> parse(byte[] byArray, int n, int n2, int n3) throws ErrorException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        boolean bl = false;
        boolean bl2 = false;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        block20: for (int i = n2; i < n2 + n3; ++i) {
            switch (byArray[i]) {
                case 92: {
                    bl2 = true;
                    byteArrayOutputStream.write(byArray[i]);
                    continue block20;
                }
                case 123: {
                    if (!bl) continue block20;
                    byteArrayOutputStream.write(byArray[i]);
                    continue block20;
                }
                case 34: {
                    if (bl && bl2) {
                        byteArrayOutputStream.write(byArray[i]);
                        continue block20;
                    }
                    bl = !bl;
                    continue block20;
                }
                case 44: 
                case 125: {
                    if (bl) {
                        byteArrayOutputStream.write(byArray[i]);
                        continue block20;
                    }
                    byte[] byArray2 = byteArrayOutputStream.toByteArray();
                    if (0 == byArray2.length) continue block20;
                    switch (n) {
                        case 4: {
                            arrayList.add(PGDataTypeUtilities.toInteger(byArray2, 0, byArray2.length));
                            byteArrayOutputStream = new ByteArrayOutputStream();
                            continue block20;
                        }
                        case 5: {
                            arrayList.add(PGDataTypeUtilities.toShort(byArray2, 0, byArray2.length));
                            byteArrayOutputStream = new ByteArrayOutputStream();
                            continue block20;
                        }
                        case -5: {
                            arrayList.add(PGDataTypeUtilities.toLong(byArray2, 0, byArray2.length));
                            byteArrayOutputStream = new ByteArrayOutputStream();
                            continue block20;
                        }
                        case 7: {
                            arrayList.add(Float.valueOf(PGDataTypeUtilities.toFloat(byArray2, 0, byArray2.length)));
                            byteArrayOutputStream = new ByteArrayOutputStream();
                            continue block20;
                        }
                        case 8: {
                            arrayList.add(PGDataTypeUtilities.toDouble(byArray2, 0, byArray2.length));
                            byteArrayOutputStream = new ByteArrayOutputStream();
                            continue block20;
                        }
                        case 91: {
                            Object object = PGDataTypeUtilities.toDate(byArray2, 0, byArray2.length);
                            arrayList.add(PGDataTypeUtilities.toSqlDate((int[])object));
                            byteArrayOutputStream = new ByteArrayOutputStream();
                            continue block20;
                        }
                        case 92: {
                            Object object = PGDataTypeUtilities.toTime(byArray2, 0, byArray2.length);
                            arrayList.add(PGArrayParser.toSqlTime((int)object[0], (int)object[1], (int)object[2], (int)object[3]));
                            byteArrayOutputStream = new ByteArrayOutputStream();
                            continue block20;
                        }
                        case 93: {
                            Object object = PGDataTypeUtilities.toUTF8String(byteArrayOutputStream.toByteArray());
                            object = ((String)object).toLowerCase();
                            if (((String)object).contains("infinity")) {
                                if (((String)object).startsWith("-")) {
                                    arrayList.add(new PGTimestamp(Long.MIN_VALUE));
                                } else {
                                    arrayList.add(new PGTimestamp(Long.MAX_VALUE));
                                }
                            } else {
                                int[] nArray = PGDataTypeUtilities.toTimestamp(byArray2, 0, byArray2.length);
                                arrayList.add(PGArrayParser.toSqlTimestamp(nArray[0], nArray[1] - 1, nArray[2], nArray[3], nArray[4], nArray[5], nArray[6]));
                            }
                            byteArrayOutputStream = new ByteArrayOutputStream();
                            continue block20;
                        }
                        case -1: 
                        case 1: 
                        case 12: {
                            arrayList.add(PGDataTypeUtilities.toUTF8String(byteArrayOutputStream.toByteArray()));
                            byteArrayOutputStream = new ByteArrayOutputStream();
                            continue block20;
                        }
                        case -7: 
                        case 16: {
                            arrayList.add(PGDataTypeUtilities.toBit(byArray2, 0));
                            byteArrayOutputStream = new ByteArrayOutputStream();
                            continue block20;
                        }
                        case 2: 
                        case 3: {
                            Object object = PGDataTypeUtilities.toBigDecimal(byArray2, 0, byArray2.length);
                            arrayList.add(object);
                            byteArrayOutputStream = new ByteArrayOutputStream();
                            continue block20;
                        }
                        case -4: 
                        case -3: 
                        case -2: {
                            arrayList.add(byteArrayOutputStream.toByteArray());
                            byteArrayOutputStream = new ByteArrayOutputStream();
                            continue block20;
                        }
                    }
                    arrayList.add(PGDataTypeUtilities.toUTF8String(byteArrayOutputStream.toByteArray()));
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    continue block20;
                }
                default: {
                    bl2 = false;
                    byteArrayOutputStream.write(byArray[i]);
                }
            }
        }
        return arrayList;
    }

    public static Object parseArray(byte[] byArray, int n, int n2, int n3) throws ErrorException {
        List<?> list = PGArrayParser.parse(byArray, n, n2, n3);
        int n4 = list.size();
        Object[] objectArray = PGArrayParser.createTypedArray(n, n4);
        for (int i = 0; i < n4; ++i) {
            objectArray[i] = list.get(i);
        }
        return objectArray;
    }

    private static Object[] createTypedArray(int n, int n2) {
        Object[] objectArray = null;
        switch (n) {
            case 4: {
                objectArray = new Integer[n2];
                break;
            }
            case 5: {
                objectArray = new Short[n2];
                break;
            }
            case -5: {
                objectArray = new Long[n2];
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                objectArray = new String[n2];
                break;
            }
            case 7: {
                objectArray = new Float[n2];
                break;
            }
            case 6: 
            case 8: {
                objectArray = new Double[n2];
                break;
            }
            case -7: 
            case 16: {
                objectArray = new Boolean[n2];
                break;
            }
            case 91: {
                objectArray = new Date[n2];
                break;
            }
            case 92: {
                objectArray = new Time[n2];
                break;
            }
            case 93: {
                objectArray = new Timestamp[n2];
                break;
            }
            case 2: 
            case 3: {
                objectArray = new BigDecimal[n2];
                break;
            }
            case -6: {
                objectArray = new Byte[n2];
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                objectArray = (Object[])new byte[n2][];
                break;
            }
            default: {
                objectArray = new Object[n2];
            }
        }
        return objectArray;
    }

    private static Time toSqlTime(int n, int n2, int n3, int n4) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1970, 0, 1, n, n2, n3);
        calendar.set(14, n4 / 1000000);
        return new Time(calendar.getTimeInMillis());
    }

    private static Timestamp toSqlTimestamp(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(n, n2, n3);
        calendar.set(11, n4);
        calendar.set(12, n5);
        calendar.set(13, n6);
        Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
        timestamp.setNanos(n7);
        return timestamp;
    }
}

