/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.inference.model.Bounds;
import dr.inference.model.Parameter;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;

public class UniformOperator
extends SimpleMCMCOperator {
    private Parameter parameter = null;
    private final Double lowerBound;
    private final Double upperBound;

    public UniformOperator(Parameter parameter, double d) {
        this(parameter, d, null, null);
    }

    public UniformOperator(Parameter parameter, double d, Double d2, Double d3) {
        this.parameter = parameter;
        this.setWeight(d);
        this.lowerBound = d2;
        this.upperBound = d3;
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    @Override
    public final double doOperation() {
        int n = MathUtils.nextInt(this.parameter.getDimension());
        Bounds<Double> bounds = this.parameter.getBounds();
        double d = this.lowerBound == null ? bounds.getLowerLimit(n) : Math.max(bounds.getLowerLimit(n), this.lowerBound);
        double d2 = this.upperBound == null ? bounds.getUpperLimit(n) : Math.min(bounds.getUpperLimit(n), this.upperBound);
        double d3 = MathUtils.nextDouble() * (d2 - d) + d;
        this.parameter.setParameterValue(n, d3);
        return 0.0;
    }

    @Override
    public final String getOperatorName() {
        return "uniform(" + this.parameter.getParameterName() + ")";
    }

    public final void optimize(double d) {
        throw new RuntimeException("This operator cannot be optimized!");
    }

    public boolean isOptimizing() {
        return false;
    }

    public void setOptimizing(boolean bl) {
        throw new RuntimeException("This operator cannot be optimized!");
    }

    public String getPerformanceSuggestion() {
        return "";
    }

    public String toString() {
        return "uniformOperator(" + this.parameter.getParameterName() + ")";
    }
}

