/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.antigenic.phyloclustering.operators;

import dr.inference.model.MatrixParameter;
import dr.inference.model.Parameter;
import dr.inference.operators.AbstractAdaptableOperator;
import dr.inference.operators.AdaptationMode;
import dr.math.MathUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class muMeanTranslateInactiveMu1Operator
extends AbstractAdaptableOperator {
    private MatrixParameter mu = null;
    private Parameter muMean = null;
    private Parameter indicators;
    private double windowSize = 0.5;
    public static final String muMeanTranslateInactiveMu1OperatorStr = "muMeanTranslateInactiveMu1Operator";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        public static final String MU = "mu";
        public static final String MUMEAN = "muMean";
        public static final String INDICATORS = "indicators";
        public static final String WINDOWSIZE = "windowSize";
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("weight"), AttributeRule.newDoubleRule("windowSize"), new ElementRule("mu", Parameter.class), new ElementRule("indicators", Parameter.class), new ElementRule("muMean", Parameter.class)};

        @Override
        public String getParserName() {
            return muMeanTranslateInactiveMu1Operator.muMeanTranslateInactiveMu1OperatorStr;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            double d = xMLObject.getDoubleAttribute("weight");
            double d2 = xMLObject.getDoubleAttribute(WINDOWSIZE);
            XMLObject xMLObject2 = xMLObject.getChild(MU);
            MatrixParameter matrixParameter = (MatrixParameter)xMLObject2.getChild(MatrixParameter.class);
            xMLObject2 = xMLObject.getChild(INDICATORS);
            Parameter parameter = (Parameter)xMLObject2.getChild(Parameter.class);
            xMLObject2 = xMLObject.getChild(MUMEAN);
            Parameter parameter2 = (Parameter)xMLObject2.getChild(Parameter.class);
            return new muMeanTranslateInactiveMu1Operator(d, matrixParameter, parameter, parameter2, d2);
        }

        @Override
        public String getParserDescription() {
            return "changes mu1Scale and make sure the first dimension of the active drifted mus stay the same";
        }

        @Override
        public Class getReturnType() {
            return muMeanTranslateInactiveMu1Operator.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public muMeanTranslateInactiveMu1Operator(double d, MatrixParameter matrixParameter, Parameter parameter, Parameter parameter2, double d2) {
        super(AdaptationMode.ADAPTATION_ON);
        this.setWeight(d);
        this.mu = matrixParameter;
        this.indicators = parameter;
        this.muMean = parameter2;
        this.windowSize = d2;
    }

    @Override
    public double doOperation() {
        System.out.println("run here stop");
        System.exit(0);
        double d = (2.0 * MathUtils.nextDouble() - 1.0) * this.windowSize;
        double d2 = this.muMean.getParameterValue(0);
        double d3 = d + d2;
        this.muMean.setParameterValue(0, d3);
        int n = this.mu.getColumnDimension();
        for (int i = 0; i < n; ++i) {
            if ((int)this.indicators.getParameterValue(i) != 0) continue;
            double d4 = this.mu.getParameter(i).getParameterValue(0);
            double d5 = d4 + d;
            this.mu.getParameter(i).setParameterValue(0, d5);
        }
        return 0.0;
    }

    @Override
    protected double getAdaptableParameterValue() {
        return Math.log(this.windowSize);
    }

    @Override
    public void setAdaptableParameterValue(double d) {
        this.windowSize = Math.exp(d);
    }

    @Override
    public double getRawParameter() {
        return this.windowSize;
    }

    @Override
    public String getAdaptableParameterName() {
        return "windowSize";
    }

    @Override
    public final String getOperatorName() {
        return muMeanTranslateInactiveMu1OperatorStr;
    }

    public int getStepCount() {
        return 1;
    }
}

