/*
 * Decompiled with CFR 0.152.
 */
package beagle;

import beagle.BenchmarkedResourceDetails;
import beagle.InstanceDetails;
import beagle.ResourceDetails;

public class BeagleJNIWrapper {
    public static final String LIBRARY_NAME = BeagleJNIWrapper.getPlatformSpecificLibraryName();
    public static BeagleJNIWrapper INSTANCE;

    private BeagleJNIWrapper() {
    }

    public native String getVersion();

    public native String getCitation();

    public native ResourceDetails[] getResourceList();

    public native BenchmarkedResourceDetails[] getBenchmarkedResourceList(int var1, int var2, int var3, int var4, int var5, int[] var6, int var7, long var8, long var10, int var12, int var13, int var14, long var15);

    public native int createInstance(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int[] var10, int var11, long var12, long var14, InstanceDetails var16);

    public native int finalize(int var1);

    public native int setCPUThreadCount(int var1, int var2);

    public native int setPatternWeights(int var1, double[] var2);

    public native int setPatternPartitions(int var1, int var2, int[] var3);

    public native int setTipStates(int var1, int var2, int[] var3);

    public native int getTipStates(int var1, int var2, int[] var3);

    public native int setTipPartials(int var1, int var2, double[] var3);

    public native int setRootPrePartials(int var1, int[] var2, int[] var3, int var4);

    public native int setPartials(int var1, int var2, double[] var3);

    public native int getPartials(int var1, int var2, int var3, double[] var4);

    public native int getLogScaleFactors(int var1, int var2, double[] var3);

    public native int setEigenDecomposition(int var1, int var2, double[] var3, double[] var4, double[] var5);

    public native int setStateFrequencies(int var1, int var2, double[] var3);

    public native int setCategoryWeights(int var1, int var2, double[] var3);

    public native int setCategoryRates(int var1, double[] var2);

    public native int setCategoryRatesWithIndex(int var1, int var2, double[] var3);

    public native int setTransitionMatrix(int var1, int var2, double[] var3, double var4);

    public native int setDifferentialMatrix(int var1, int var2, double[] var3);

    public native int getTransitionMatrix(int var1, int var2, double[] var3);

    public native int convolveTransitionMatrices(int var1, int[] var2, int[] var3, int[] var4, int var5);

    public native int addTransitionMatrices(int var1, int[] var2, int[] var3, int[] var4, int var5);

    public native int transposeTransitionMatrices(int var1, int[] var2, int[] var3, int var4);

    public native int updateTransitionMatrices(int var1, int var2, int[] var3, int[] var4, int[] var5, double[] var6, int var7);

    public native int updateTransitionMatricesWithMultipleModels(int var1, int[] var2, int[] var3, int[] var4, int[] var5, int[] var6, double[] var7, int var8);

    public native int updatePrePartials(int var1, int[] var2, int var3, int var4);

    public native int updatePartials(int var1, int[] var2, int var3, int var4);

    public native int updatePartialsByPartition(int var1, int[] var2, int var3);

    public native int waitForPartials(int var1, int[] var2, int var3);

    public native int accumulateScaleFactors(int var1, int[] var2, int var3, int var4);

    public native int accumulateScaleFactorsByPartition(int var1, int[] var2, int var3, int var4, int var5);

    public native int removeScaleFactors(int var1, int[] var2, int var3, int var4);

    public native int removeScaleFactorsByPartition(int var1, int[] var2, int var3, int var4, int var5);

    public native int resetScaleFactors(int var1, int var2);

    public native int resetScaleFactorsByPartition(int var1, int var2, int var3);

    public native int copyScaleFactors(int var1, int var2, int var3);

    public native int calculateRootLogLikelihoods(int var1, int[] var2, int[] var3, int[] var4, int[] var5, int var6, double[] var7);

    public native int calculateRootLogLikelihoodsByPartition(int var1, int[] var2, int[] var3, int[] var4, int[] var5, int[] var6, int var7, int var8, double[] var9, double[] var10);

    public native int getSiteLogLikelihoods(int var1, double[] var2);

    public native int calculateEdgeDifferentials(int var1, int[] var2, int[] var3, int[] var4, int[] var5, int var6, double[] var7, double[] var8, double[] var9);

    public native int calculateEdgeDerivative(int var1, int[] var2, int[] var3, int var4, int[] var5, int[] var6, int var7, int var8, int var9, int[] var10, int var11, double[] var12, double[] var13);

    private static String getPlatformSpecificLibraryName() {
        String string = System.getProperty("os.name").toLowerCase();
        String string2 = System.getProperty("os.arch").toLowerCase();
        if (string.startsWith("windows")) {
            if (string2.equals("x86") || string2.equals("i386")) {
                return "hmsbeagle32";
            }
            if (string2.startsWith("amd64") || string2.startsWith("x86_64")) {
                return "hmsbeagle64";
            }
        }
        return "hmsbeagle-jni";
    }

    public static void loadBeagleLibrary() throws UnsatisfiedLinkError {
        String string = "";
        if (System.getProperty("beagle.library.path") != null && (string = System.getProperty("beagle.library.path")).length() > 0 && !string.endsWith("/")) {
            string = string + "/";
        }
        System.loadLibrary(string + LIBRARY_NAME);
        INSTANCE = new BeagleJNIWrapper();
    }
}

