/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.athena.utilities;

import com.simba.athena.shaded.apache.log4j.AppenderSkeleton;
import com.simba.athena.shaded.apache.log4j.Level;
import com.simba.athena.shaded.apache.log4j.spi.LoggingEvent;
import com.simba.athena.support.ILogger;
import com.simba.athena.support.LogLevel;
import com.simba.athena.support.LogUtilities;
import java.text.SimpleDateFormat;

public class AJAWSLogAppender
extends AppenderSkeleton {
    private ILogger m_logger;
    private final SimpleDateFormat m_dateFormatter;

    public AJAWSLogAppender(ILogger iLogger, LogLevel logLevel) {
        this.m_logger = iLogger;
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{logLevel});
        this.m_dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        if (LogLevel.TRACE.equals((Object)logLevel)) {
            this.setThreshold(Level.ALL);
        } else if (LogLevel.DEBUG.equals((Object)logLevel)) {
            this.setThreshold(Level.DEBUG);
        } else if (LogLevel.INFO.equals((Object)logLevel)) {
            this.setThreshold(Level.INFO);
        } else if (LogLevel.WARNING.equals((Object)logLevel)) {
            this.setThreshold(Level.WARN);
        } else if (LogLevel.ERROR.equals((Object)logLevel)) {
            this.setThreshold(Level.ERROR);
        } else if (LogLevel.FATAL.equals((Object)logLevel)) {
            this.setThreshold(Level.FATAL);
        } else {
            this.setThreshold(Level.OFF);
        }
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public boolean requiresLayout() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return false;
    }

    @Override
    protected void append(LoggingEvent loggingEvent) {
        if (null != loggingEvent) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Timestamp: " + this.m_dateFormatter.format(loggingEvent.getTimeStamp()));
            stringBuilder.append(" Log Level: " + loggingEvent.getLevel());
            stringBuilder.append(" Thread: " + loggingEvent.getThreadName());
            stringBuilder.append(" Event Message: " + loggingEvent.getMessage());
            if (null != loggingEvent.getThrowableInformation()) {
                stringBuilder.append(" Throwable:" + loggingEvent.getThrowableInformation().getThrowable());
            }
            if (Level.ALL.equals(loggingEvent.getLevel()) || Level.TRACE.equals(loggingEvent.getLevel())) {
                LogUtilities.logTrace(stringBuilder.toString(), this.m_logger);
            } else if (Level.DEBUG.equals(loggingEvent.getLevel())) {
                LogUtilities.logDebug(stringBuilder.toString(), this.m_logger);
            } else if (Level.INFO.equals(loggingEvent.getLevel())) {
                LogUtilities.logInfo(stringBuilder.toString(), this.m_logger);
            } else if (Level.WARN.equals(loggingEvent.getLevel())) {
                LogUtilities.logWarning(stringBuilder.toString(), this.m_logger);
            } else if (Level.ERROR.equals(loggingEvent.getLevel())) {
                LogUtilities.logError(stringBuilder.toString(), this.m_logger);
            } else if (Level.FATAL.equals(loggingEvent.getLevel())) {
                LogUtilities.logFatal(stringBuilder.toString(), this.m_logger);
            }
        }
    }
}

