/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.athena.dataengine.metadata;

import com.simba.athena.athena.core.AJDriver;
import com.simba.athena.athena.core.AJSettings;
import com.simba.athena.athena.exceptions.AJMessageKey;
import com.simba.athena.dsi.dataengine.interfaces.IMetadataSource;
import com.simba.athena.dsi.dataengine.utilities.DSITypeUtilities;
import com.simba.athena.dsi.dataengine.utilities.DataWrapper;
import com.simba.athena.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.simba.athena.dsi.dataengine.utilities.Nullable;
import com.simba.athena.dsi.dataengine.utilities.Searchable;
import com.simba.athena.dsi.dataengine.utilities.TypeUtilities;
import com.simba.athena.support.ILogger;
import com.simba.athena.support.LogUtilities;
import com.simba.athena.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Map;

public class AJTypeInfoMetadataSource
implements IMetadataSource {
    private final AJSettings m_settings;
    ArrayList<TypeInfo> m_dataTypes = new ArrayList();
    private ListIterator<TypeInfo> m_dataTypeIterator;
    private TypeInfo m_currentDataType;
    private ILogger m_logger;

    public AJTypeInfoMetadataSource(ILogger iLogger, Map<MetadataSourceColumnTag, String> map, AJSettings aJSettings) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, map, aJSettings);
        this.m_logger = iLogger;
        this.m_settings = aJSettings;
        String string = map.get((Object)MetadataSourceColumnTag.DATA_TYPE);
        if (null != string) {
            try {
                this.initializeDataTypes(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                LogUtilities.logError(numberFormatException, this.m_logger);
                throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.GENERAL_ERROR, (Throwable)numberFormatException);
            }
        } else {
            this.initializeDataTypes(0);
        }
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            this.closeCursor();
        }
        catch (ErrorException errorException) {
            // empty catch block
        }
    }

    @Override
    public void closeCursor() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag metadataSourceColumnTag, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{metadataSourceColumnTag, l, l2});
        switch (metadataSourceColumnTag) {
            case DATA_TYPE_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_currentDataType.m_typeName, dataWrapper, l, l2);
            }
            case DATA_TYPE: {
                dataWrapper.setInteger(this.m_currentDataType.m_sqlType);
                return false;
            }
            case COLUMN_SIZE: {
                dataWrapper.setInteger(this.m_currentDataType.m_columnSize);
                return false;
            }
            case LITERAL_PREFIX: {
                return DSITypeUtilities.outputVarCharStringData(this.m_currentDataType.m_literalPrefix, dataWrapper, l, l2);
            }
            case LITERAL_SUFFIX: {
                return DSITypeUtilities.outputVarCharStringData(this.m_currentDataType.m_literalSuffix, dataWrapper, l, l2);
            }
            case CREATE_PARAM: {
                return DSITypeUtilities.outputVarCharStringData(this.m_currentDataType.m_createParams, dataWrapper, l, l2);
            }
            case NULLABLE: {
                dataWrapper.setSmallInt(this.m_currentDataType.m_nullable.ordinal());
                return false;
            }
            case CASE_SENSITIVE: {
                dataWrapper.setBoolean(this.m_currentDataType.m_caseSensitive);
                return false;
            }
            case SEARCHABLE: {
                dataWrapper.setSmallInt(this.m_currentDataType.m_searchable.ordinal());
                return false;
            }
            case UNSIGNED_ATTRIBUTE: {
                if (!(TypeUtilities.isApproximateNumericType(this.m_currentDataType.m_sqlType) || TypeUtilities.isExactNumericType(this.m_currentDataType.m_sqlType) || TypeUtilities.isIntegerType(this.m_currentDataType.m_sqlType))) {
                    dataWrapper.setNull(16);
                } else {
                    dataWrapper.setBoolean(this.m_currentDataType.m_unsignedAttr);
                }
                return false;
            }
            case FIXED_PREC_SCALE: {
                dataWrapper.setBoolean(this.m_currentDataType.m_fixedPrecScale);
                return false;
            }
            case AUTO_UNIQUE: {
                if (!(TypeUtilities.isApproximateNumericType(this.m_currentDataType.m_sqlType) || TypeUtilities.isExactNumericType(this.m_currentDataType.m_sqlType) || TypeUtilities.isIntegerType(this.m_currentDataType.m_sqlType))) {
                    dataWrapper.setNull(5);
                } else {
                    dataWrapper.setBoolean(this.m_currentDataType.m_autoUnique);
                }
                return false;
            }
            case LOCAL_TYPE_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_currentDataType.m_typeName, dataWrapper, l, l2);
            }
            case MINIMUM_SCALE: {
                if (TypeUtilities.isExactNumericType(this.m_currentDataType.m_sqlType) || TypeUtilities.isIntegerType(this.m_currentDataType.m_sqlType) || -7 == this.m_currentDataType.m_sqlType || 92 == this.m_currentDataType.m_sqlType || 93 == this.m_currentDataType.m_sqlType) {
                    dataWrapper.setSmallInt(this.m_currentDataType.m_minScale);
                } else {
                    dataWrapper.setNull(5);
                }
                return false;
            }
            case MAXIMUM_SCALE: {
                if (TypeUtilities.isExactNumericType(this.m_currentDataType.m_sqlType) || TypeUtilities.isIntegerType(this.m_currentDataType.m_sqlType) || -7 == this.m_currentDataType.m_sqlType || 92 == this.m_currentDataType.m_sqlType || 93 == this.m_currentDataType.m_sqlType) {
                    dataWrapper.setSmallInt(this.m_currentDataType.m_maxScale);
                } else {
                    dataWrapper.setNull(5);
                }
                return false;
            }
            case SQL_DATA_TYPE: {
                dataWrapper.setInteger(TypeUtilities.getVerboseTypeFromConciseType(this.m_currentDataType.m_sqlType));
                return false;
            }
            case SQL_DATETIME_SUB: {
                short s = TypeUtilities.getIntervalCodeFromConciseType(this.m_currentDataType.m_sqlType);
                if (0 == s) {
                    dataWrapper.setNull(4);
                } else {
                    dataWrapper.setInteger(s);
                }
                return false;
            }
            case NUM_PREC_RADIX: {
                int n = TypeUtilities.getNumPrecRadix((short)this.m_currentDataType.m_sqlType);
                if (0 == n) {
                    dataWrapper.setNull(4);
                } else {
                    dataWrapper.setInteger(n);
                }
                return false;
            }
            case INTERVAL_PRECISION: {
                dataWrapper.setNull(5);
                return false;
            }
            case USER_DATA_TYPE: {
                dataWrapper.setSmallInt(this.m_currentDataType.m_userDefinedDataType);
                return false;
            }
        }
        throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.METADATA_COLUMN_NOT_FOUND.name(), new String[]{metadataSourceColumnTag.toString()});
    }

    @Override
    public boolean hasMoreRows() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_dataTypeIterator.hasNext();
    }

    @Override
    public boolean moveToNextRow() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.hasMoreRows()) {
            this.m_currentDataType = this.m_dataTypeIterator.next();
            return true;
        }
        return false;
    }

    private void initializeDataTypes(int n) {
        TypeInfo typeInfo;
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (0 == n || -7 == n || 16 == n) {
            typeInfo = new TypeInfo(-7, "boolean", 1);
            typeInfo.m_searchable = Searchable.PREDICATE_BASIC;
            this.m_dataTypes.add(typeInfo);
        }
        if (0 == n || -6 == n) {
            typeInfo = new TypeInfo(-6, "tinyint", 3);
            typeInfo.m_searchable = Searchable.PREDICATE_BASIC;
            this.m_dataTypes.add(typeInfo);
        }
        if (0 == n || 5 == n) {
            typeInfo = new TypeInfo(5, "smallint", 5);
            typeInfo.m_searchable = Searchable.PREDICATE_BASIC;
            this.m_dataTypes.add(typeInfo);
        }
        if (0 == n || 4 == n) {
            typeInfo = new TypeInfo(4, "integer", 10);
            typeInfo.m_searchable = Searchable.PREDICATE_BASIC;
            this.m_dataTypes.add(typeInfo);
        }
        if (0 == n || -5 == n) {
            typeInfo = new TypeInfo(-5, "bigint", 19);
            typeInfo.m_searchable = Searchable.PREDICATE_BASIC;
            this.m_dataTypes.add(typeInfo);
        }
        if (0 == n || 7 == n) {
            typeInfo = new TypeInfo(7, "float", 24);
            typeInfo.m_searchable = Searchable.PREDICATE_BASIC;
            this.m_dataTypes.add(typeInfo);
        }
        if (0 == n || 8 == n) {
            typeInfo = new TypeInfo(8, "double", 53);
            typeInfo.m_searchable = Searchable.PREDICATE_BASIC;
            this.m_dataTypes.add(typeInfo);
        }
        if (0 == n || 3 == n) {
            typeInfo = new TypeInfo(3, "decimal", 38);
            typeInfo.m_searchable = Searchable.PREDICATE_BASIC;
            typeInfo.m_minScale = 0;
            typeInfo.m_maxScale = (short)38;
            this.m_dataTypes.add(typeInfo);
        }
        if (0 == n || 91 == n) {
            typeInfo = new TypeInfo(91, "date", 10);
            typeInfo.m_searchable = Searchable.PREDICATE_BASIC;
            this.m_dataTypes.add(typeInfo);
        }
        if (0 == n || 93 == n) {
            typeInfo = new TypeInfo(93, "timestamp", 23);
            typeInfo.m_searchable = Searchable.PREDICATE_BASIC;
            typeInfo.m_minScale = (short)3;
            typeInfo.m_maxScale = (short)3;
            this.m_dataTypes.add(typeInfo);
        }
        if (0 == n || -3 == n) {
            typeInfo = new TypeInfo(-3, "varbinary", this.m_settings.m_binaryColumnLength);
            typeInfo.m_literalPrefix = "0x";
            typeInfo.m_createParams = "max length";
            typeInfo.m_searchable = Searchable.PREDICATE_BASIC;
            this.m_dataTypes.add(typeInfo);
        }
        if (0 == n || 1 == n) {
            typeInfo = new TypeInfo(1, "char", 255);
            typeInfo.m_literalPrefix = "'";
            typeInfo.m_literalSuffix = "'";
            typeInfo.m_createParams = "length";
            typeInfo.m_caseSensitive = true;
            this.m_dataTypes.add(typeInfo);
        }
        if (0 == n || 12 == n) {
            typeInfo = new TypeInfo(12, "varchar", 65535);
            typeInfo.m_literalPrefix = "'";
            typeInfo.m_literalSuffix = "'";
            typeInfo.m_createParams = "max length";
            typeInfo.m_caseSensitive = true;
            this.m_dataTypes.add(typeInfo);
            TypeInfo typeInfo2 = new TypeInfo(12, "string", this.m_settings.m_stringColumnLength);
            typeInfo2.m_literalPrefix = "'";
            typeInfo2.m_literalSuffix = "'";
            typeInfo2.m_createParams = "max length";
            typeInfo2.m_caseSensitive = true;
            typeInfo2.m_userDefinedDataType = (short)16384;
            this.m_dataTypes.add(typeInfo2);
            TypeInfo typeInfo3 = new TypeInfo(12, "map", this.m_settings.m_complexTypeColumnLength);
            typeInfo3.m_literalPrefix = "'";
            typeInfo3.m_literalSuffix = "'";
            typeInfo3.m_createParams = "max length";
            typeInfo3.m_caseSensitive = true;
            typeInfo3.m_userDefinedDataType = (short)16386;
            this.m_dataTypes.add(typeInfo3);
            TypeInfo typeInfo4 = new TypeInfo(12, "struct", this.m_settings.m_complexTypeColumnLength);
            typeInfo4.m_literalPrefix = "'";
            typeInfo4.m_literalSuffix = "'";
            typeInfo4.m_createParams = "max length";
            typeInfo4.m_caseSensitive = true;
            typeInfo4.m_userDefinedDataType = (short)16387;
            this.m_dataTypes.add(typeInfo4);
            if (!this.m_settings.m_useArraySupport) {
                TypeInfo typeInfo5 = new TypeInfo(12, "array", this.m_settings.m_complexTypeColumnLength);
                typeInfo5.m_literalPrefix = "'";
                typeInfo5.m_literalSuffix = "'";
                typeInfo5.m_createParams = "max length";
                typeInfo5.m_caseSensitive = true;
                typeInfo5.m_userDefinedDataType = (short)16385;
                this.m_dataTypes.add(typeInfo5);
            }
        }
        if (this.m_settings.m_useArraySupport && (0 == n || 2003 == n)) {
            typeInfo = new TypeInfo(2003, "array", this.m_settings.m_complexTypeColumnLength);
            typeInfo.m_searchable = Searchable.PREDICATE_NONE;
            typeInfo.m_caseSensitive = true;
            typeInfo.m_userDefinedDataType = (short)16385;
            this.m_dataTypes.add(typeInfo);
        }
        this.m_dataTypeIterator = this.m_dataTypes.listIterator(0);
    }

    class TypeInfo {
        public String m_typeName;
        public int m_sqlType;
        public int m_columnSize;
        public String m_literalPrefix;
        public String m_literalSuffix;
        public String m_createParams;
        public Nullable m_nullable;
        public boolean m_caseSensitive;
        public Searchable m_searchable;
        public boolean m_unsignedAttr;
        public boolean m_fixedPrecScale;
        public boolean m_autoUnique;
        public short m_minScale;
        public short m_maxScale;
        public short m_userDefinedDataType;

        public TypeInfo(int n, String string, int n2) {
            this.m_sqlType = n;
            this.m_typeName = string;
            this.m_columnSize = n2;
            this.m_literalPrefix = null;
            this.m_literalSuffix = null;
            this.m_createParams = null;
            this.m_nullable = Nullable.NULLABLE;
            this.m_caseSensitive = false;
            this.m_searchable = Searchable.SEARCHABLE;
            this.m_unsignedAttr = true;
            this.m_fixedPrecScale = false;
            this.m_autoUnique = false;
            this.m_minScale = 0;
            this.m_maxScale = 0;
            this.m_userDefinedDataType = 0;
        }
    }
}

