/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.trees.iadem;

import com.github.javacliparser.IntOption;
import com.yahoo.labs.samoa.instances.Instance;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import moa.classifiers.MultiClassClassifier;
import moa.classifiers.core.conditionaltests.InstanceConditionalTest;
import moa.classifiers.core.conditionaltests.NominalAttributeMultiwayTest;
import moa.classifiers.core.conditionaltests.NumericAttributeBinaryTest;
import moa.classifiers.core.driftdetection.AbstractChangeDetector;
import moa.classifiers.trees.iadem.Iadem2;
import moa.classifiers.trees.iadem.Iadem3Subtree;
import moa.classifiers.trees.iadem.IademAttributeSplitSuggestion;
import moa.classifiers.trees.iadem.IademCommonProcedures;
import moa.classifiers.trees.iadem.IademException;
import moa.classifiers.trees.iadem.IademNominalAttributeBinaryTest;
import moa.classifiers.trees.iadem.IademNumericAttributeObserver;
import moa.classifiers.trees.iadem.IademVFMLNumericAttributeClassObserver;
import moa.core.AutoExpandVector;
import moa.core.DoubleVector;
import moa.core.Measurement;
import weka.core.Utils;

public class Iadem3
extends Iadem2
implements MultiClassClassifier {
    private static final long serialVersionUID = 1L;
    public IntOption maxNestingLevelOption = new IntOption("maxNestingLevel", 'p', "Maximum level of nesting for alternative subtrees (-1 => unbounded).", 1, -1, Integer.MAX_VALUE);
    public IntOption maxSubtreesPerNodeOption = new IntOption("maxSubtreesPerNode", 'w', "Maximum number of alternative subtrees per split node (-1 => unbounded).", 1, -1, Integer.MAX_VALUE);
    protected final boolean restartAtDrift = true;
    protected int interchangedTrees = 0;
    protected int deletedTrees = 0;
    protected int numTrees = 0;
    protected int lastPrediction = -1;
    protected int lastPredictionInLeaf = -1;
    protected int treeLevel = 0;
    protected AutoExpandVector<Iadem3Subtree> subtreeList = new AutoExpandVector();
    protected int currentSplitState = -1;
    protected final int SPLIT_BY_TIE_BREAKING = 0;
    protected final int SPLIT_WITH_CONFIDENCE = 1;
    public int numSplitsByBreakingTies = 0;

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        return new Measurement[]{new Measurement("tree size (nodes)", this.getNumberOfNodes()), new Measurement("tree size (leaves)", this.getNumberOfLeaves()), new Measurement("interchanged trees", this.getChangedTrees())};
    }

    public AbstractChangeDetector getEstimatorCopy() {
        return (AbstractChangeDetector)((AbstractChangeDetector)this.getPreparedClassOption(this.driftDetectionMethodOption)).copy();
    }

    @Override
    public void createRoot(Instance instance) {
        double[] arrayCont = new double[instance.numClasses()];
        Arrays.fill(arrayCont, 0.0);
        this.treeRoot = this.newLeafNode(null, 0L, 0L, arrayCont, instance);
    }

    public void addSubtree(Iadem3Subtree subtree) {
        this.subtreeList.add(subtree);
    }

    public void removeSubtree(Iadem3Subtree subtree) {
        this.subtreeList.remove(subtree);
    }

    public boolean canCreateSubtree() {
        int count;
        return this.maxSubtreesPerNodeOption.getValue() <= 0 || (count = this.getNumberOfSubtrees()) < this.maxSubtreesPerNodeOption.getValue();
    }

    @Override
    public Iadem2.LeafNode newLeafNode(Iadem2.Node parent, long instTreeCountSinceVirtual, long instNodeCountSinceVirtual, double[] initialClassCount, Instance instance) {
        switch (this.leafPredictionOption.getChosenIndex()) {
            case 0: {
                return new AdaptiveLeafNode(this, parent, instTreeCountSinceVirtual, instNodeCountSinceVirtual, initialClassCount, this.newNumericClassObserver(), this.estimator, this.splitTestsOption.getChosenIndex() == 2, this.splitTestsOption.getChosenIndex() == 0, instance);
            }
            case 1: {
                return new AdaptiveLeafNodeNB(this, parent, instTreeCountSinceVirtual, instNodeCountSinceVirtual, initialClassCount, this.newNumericClassObserver(), this.SPLIT_BY_TIE_BREAKING, this.estimator, this.splitTestsOption.getChosenIndex() == 2, this.splitTestsOption.getChosenIndex() == 0, instance);
            }
            case 2: {
                return new AdaptiveLeafNodeNBKirkby(this, parent, instTreeCountSinceVirtual, instNodeCountSinceVirtual, initialClassCount, this.newNumericClassObserver(), this.SPLIT_BY_TIE_BREAKING, this.splitTestsOption.getChosenIndex() == 2, this.splitTestsOption.getChosenIndex() == 0, this.estimator, instance);
            }
        }
        return new AdaptiveLeafNodeWeightedVote(this, parent, instTreeCountSinceVirtual, instNodeCountSinceVirtual, initialClassCount, this.newNumericClassObserver(), this.SPLIT_BY_TIE_BREAKING, this.splitTestsOption.getChosenIndex() == 2, this.splitTestsOption.getChosenIndex() == 0, this.estimator, instance);
    }

    public int getTreeLevel() {
        return this.treeLevel;
    }

    public int getMaxAltSubtreesPerNode() {
        return this.maxSubtreesPerNodeOption.getValue();
    }

    public int getMaxNestingLevels() {
        return this.maxNestingLevelOption.getValue();
    }

    public boolean isRestaurarVectoresPrediccion() {
        return true;
    }

    public int numDeletedTrees() {
        return this.deletedTrees;
    }

    public int numTrees() {
        int subtreeCount;
        if (this.treeRoot instanceof AdaptiveLeafNode) {
            subtreeCount = 0;
        } else {
            AdaptiveSplitNode nodo = (AdaptiveSplitNode)this.treeRoot;
            subtreeCount = nodo.getNumTrees();
        }
        return subtreeCount;
    }

    public void newTreeChange() {
        ++this.interchangedTrees;
        --this.numTrees;
    }

    public void newDeletedTree() {
        ++this.deletedTrees;
        --this.numTrees;
    }

    public int numSubtrees() {
        return this.tmpNumSubtrees(this.treeRoot);
    }

    private int tmpNumSubtrees(Iadem2.Node node) {
        int count = 0;
        if (node instanceof AdaptiveSplitNode) {
            ++count;
            AutoExpandVector<Iadem3Subtree> subtree = ((AdaptiveSplitNode)node).alternativeTree;
            for (Iadem3Subtree currentSubtree : subtree) {
                count += currentSubtree.numSubtrees();
            }
        }
        if (node instanceof AdaptiveSplitNode) {
            AdaptiveSplitNode nodoAuxiliar = (AdaptiveSplitNode)node;
            for (Iadem2.Node child : nodoAuxiliar.children) {
                count += this.tmpNumSubtrees(child);
            }
        }
        return count;
    }

    protected boolean hasTree(Iadem2.Node node) {
        boolean ret = false;
        if (node instanceof AdaptiveSplitNode) {
            AdaptiveSplitNode tmp = (AdaptiveSplitNode)node;
            if (tmp.alternativeTree != null) {
                ret = true;
            }
            for (int i = 0; !ret && i < tmp.children.size(); ++i) {
                ret = ret || this.hasTree((Iadem2.Node)tmp.children.get(i));
            }
        }
        return ret;
    }

    @Override
    public void learnFromInstance(Instance instance) throws IademException {
        this.getClassVotes(instance);
        this.getClassVotesFromLeaf(instance);
        super.learnFromInstance(instance);
    }

    protected void getClassVotesFromLeaf(Instance instance) {
        double[] votes = null;
        Iadem2.Node node = this.treeRoot;
        while (votes == null) {
            if (node instanceof AdaptiveSplitNode) {
                AdaptiveSplitNode splitNode = (AdaptiveSplitNode)node;
                int childIndex = splitNode.instanceChildIndex(instance);
                if (childIndex >= 0) {
                    node = splitNode.getChild(childIndex);
                    continue;
                }
                votes = splitNode.leaf.getClassVotes(instance);
                continue;
            }
            AdaptiveLeafNode leafNode = (AdaptiveLeafNode)node;
            votes = leafNode.getClassVotes(instance);
        }
        this.lastPredictionInLeaf = Utils.maxIndex(votes);
    }

    public void copyTree(Iadem3Subtree arbol) {
        this.treeRoot = arbol.treeRoot;
    }

    void setNewTree() {
        ++this.numTrees;
    }

    public int getChangedTrees() {
        return this.interchangedTrees;
    }

    @Override
    public double[] getClassVotes(Instance instance) {
        double[] votes = super.getClassVotes(instance);
        this.lastPrediction = Utils.maxIndex((double[])votes);
        return votes;
    }

    public int getNumberOfSubtrees() {
        if (this.treeRoot instanceof AdaptiveSplitNode) {
            return ((AdaptiveSplitNode)this.treeRoot).getNumberOfSubtrees();
        }
        return 0;
    }

    protected Iadem3 getMainTree() {
        return this;
    }

    public void updateNumberOfLeaves(int amount) {
        this.numberOfLeaves += amount;
    }

    public void updateNumberOfNodes(int amount) {
        this.numberOfNodes += amount;
    }

    public void updateNumberOfNodesSplitByTieBreaking(int amount) {
        this.numSplitsByBreakingTies += amount;
    }

    public static interface restartsVariablesAtDrift {
        public void resetVariablesAtDrift();
    }

    public class AdaptiveSplitNode
    extends Iadem2.SplitNode
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected AutoExpandVector<Iadem3Subtree> alternativeTree;
        protected AbstractChangeDetector estimator;
        protected int causeOfSplit;
        protected AdaptiveLeafNode leaf;

        public AdaptiveSplitNode(Iadem3 tree, Iadem2.Node parent, Iadem2.Node[] child, double[] freq, InstanceConditionalTest splitTest, AbstractChangeDetector estimator, AdaptiveLeafNode predictionLeaf, int causeOfSplit) {
            super(tree, parent, child, freq, splitTest);
            this.alternativeTree = new AutoExpandVector();
            this.estimator = estimator != null ? (AbstractChangeDetector)estimator.copy() : null;
            this.leaf = predictionLeaf;
            this.leaf.setSplit(false);
            this.causeOfSplit = causeOfSplit;
        }

        @Override
        public Iadem2.Node learnFromInstance(Instance instance) {
            try {
                boolean rightPredicted;
                Iadem2.Node node;
                double thisError = this.estimator.getEstimation();
                double thisSize = this.estimator.getDelay();
                double leafError = this.leaf.estimator.getEstimation();
                double leafSize = this.leaf.estimator.getDelay();
                double m = 1.0 / thisSize + 1.0 / leafSize;
                double delta = 1.0E-4;
                double bound = Math.sqrt(m * Math.log(2.0 / delta) / 2.0);
                double diff = thisError - leafError;
                if (diff > bound && thisSize > 600.0 && leafSize > 600.0) {
                    this.prune();
                    return this.leaf;
                }
                if (-diff > bound) {
                    this.leaf.restartVariablesAtDrift();
                    this.leaf.estimator = (AbstractChangeDetector)this.leaf.estimator.copy();
                }
                if ((node = this.checkAlternativeSubtrees(rightPredicted = (double)((Iadem3)this.tree).lastPredictionInLeaf == instance.classValue(), instance)) == null) {
                    for (Iadem3Subtree subtree : this.alternativeTree) {
                        try {
                            subtree.learnFromInstance(instance);
                            subtree.incrNumberOfInstancesProcessed();
                        }
                        catch (IademException ex) {
                            Logger.getLogger(AdaptiveSplitNode.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                    this.leaf.learnFromInstance(instance);
                    return super.learnFromInstance(instance);
                }
                return node.learnFromInstance(instance);
            }
            catch (IademException ex) {
                Logger.getLogger(AdaptiveSplitNode.class.getName()).log(Level.SEVERE, null, ex);
                return null;
            }
        }

        private Iadem2.Node checkAlternativeSubtrees(boolean acierto, Instance instance) throws IademException {
            if (this.estimator != null) {
                double loss = acierto ? 0.0 : 1.0;
                this.estimator.input(loss);
                if (this.estimator.getChange()) {
                    this.createTree(instance);
                }
                for (int i = 0; i < this.alternativeTree.size(); ++i) {
                    double bound;
                    Iadem3Subtree subtree = this.alternativeTree.get(i);
                    double treeError = subtree.estimacionValorMedio();
                    double thisError = this.estimator.getEstimation();
                    if (thisError - treeError > (bound = IademCommonProcedures.AverageComparitionByHoeffdingCorollary(this.estimator.getDelay(), subtree.windowWidth(), 1.0E-4))) {
                        ++((Iadem3)this.tree).interchangedTrees;
                        return this.changeTrees(i);
                    }
                    if (this.isUseless(i)) {
                        ((Iadem3)this.tree).updateNumberOfLeaves(-subtree.getNumberOfLeaves());
                        ((Iadem3)this.tree).updateNumberOfNodes(-subtree.getNumberOfNodes());
                        ((Iadem3)this.tree).updateNumberOfNodesSplitByTieBreaking(-subtree.numSplitsByBreakingTies);
                        --i;
                        continue;
                    }
                    if (!(this.estimator.getDelay() > 6000.0) || subtree.windowWidth() <= 6000) continue;
                    if (treeError - thisError > bound) {
                        this.alternativeTree.remove(i);
                        ((Iadem3)this.tree).updateNumberOfLeaves(-subtree.getNumberOfLeaves());
                        ((Iadem3)this.tree).updateNumberOfNodes(-subtree.getNumberOfNodes());
                        ((Iadem3)this.tree).updateNumberOfNodesSplitByTieBreaking(-subtree.numSplitsByBreakingTies);
                        --i;
                        continue;
                    }
                    int[] countMain = new int[3];
                    int[] countAlt = new int[3];
                    for (Iadem2.Node child : this.children) {
                        child.getNumberOfNodes(countMain);
                    }
                    subtree.getNumberOfNodes(countAlt);
                    if (countMain[0] + countMain[1] + 1 > countAlt[0] + countAlt[1]) {
                        return this.changeTrees(i);
                    }
                    this.alternativeTree.remove(i);
                    ((Iadem3)this.tree).updateNumberOfLeaves(-subtree.getNumberOfLeaves());
                    ((Iadem3)this.tree).updateNumberOfNodes(-subtree.getNumberOfNodes());
                    ((Iadem3)this.tree).updateNumberOfNodesSplitByTieBreaking(-subtree.numSplitsByBreakingTies);
                    --i;
                }
            }
            return null;
        }

        public boolean isUseless(int i) {
            boolean removed = false;
            Iadem3Subtree subtree = this.alternativeTree.get(i);
            if (subtree.getTreeRoot() instanceof AdaptiveSplitNode) {
                double delta;
                double m;
                double bound;
                AdaptiveSplitNode splitNode = (AdaptiveSplitNode)subtree.getTreeRoot();
                int nMain = (int)this.estimator.getDelay();
                int nAlt = (int)subtree.getEstimador().getDelay();
                double errorMain = this.estimator.getEstimation();
                double errorAlt = subtree.getEstimador().getEstimation();
                double errorDifference = errorAlt - errorMain;
                double absError = Math.abs(errorDifference);
                if (!removed && nMain > 0 && nAlt > 0 && errorDifference > (bound = Math.sqrt((m = 1.0 / (double)nMain + 1.0 / (double)nAlt) * Math.log(2.0 / (delta = 1.0E-4)) / 2.0))) {
                    this.alternativeTree.remove(i);
                    removed = true;
                }
                if (!removed) {
                    InstanceConditionalTest condTest = splitNode.splitTest;
                    if (condTest instanceof IademNominalAttributeBinaryTest && this.splitTest instanceof IademNominalAttributeBinaryTest) {
                        IademNominalAttributeBinaryTest altTest = (IademNominalAttributeBinaryTest)condTest;
                        IademNominalAttributeBinaryTest mainTest = (IademNominalAttributeBinaryTest)this.splitTest;
                        if (mainTest.getAttValue() == altTest.getAttValue() && mainTest.getAttsTestDependsOn()[0] == altTest.getAttsTestDependsOn()[0]) {
                            this.alternativeTree.remove(i);
                            removed = true;
                        }
                    } else if (condTest instanceof NominalAttributeMultiwayTest && this.splitTest instanceof NominalAttributeMultiwayTest) {
                        NominalAttributeMultiwayTest altTest = (NominalAttributeMultiwayTest)condTest;
                        NominalAttributeMultiwayTest mainTest = (NominalAttributeMultiwayTest)this.splitTest;
                        if (mainTest.getAttsTestDependsOn()[0] == altTest.getAttsTestDependsOn()[0]) {
                            this.alternativeTree.remove(i);
                            removed = true;
                        }
                    } else if (condTest instanceof NumericAttributeBinaryTest && this.splitTest instanceof NumericAttributeBinaryTest) {
                        NumericAttributeBinaryTest altTest = (NumericAttributeBinaryTest)condTest;
                        NumericAttributeBinaryTest mainTest = (NumericAttributeBinaryTest)this.splitTest;
                        if (mainTest.getAttsTestDependsOn()[0] == altTest.getAttsTestDependsOn()[0] && mainTest.getSplitValue() == altTest.getSplitValue()) {
                            this.alternativeTree.remove(i);
                            removed = true;
                        }
                    }
                }
            }
            return removed;
        }

        private Iadem2.Node changeTrees(int index) {
            for (int i = 0; i < this.alternativeTree.size(); ++i) {
                if (i == index) continue;
                Iadem3Subtree subtree = this.alternativeTree.get(i);
                ((Iadem3)this.tree).updateNumberOfLeaves(-subtree.getNumberOfLeaves());
                ((Iadem3)this.tree).updateNumberOfNodes(-subtree.getNumberOfNodes());
                ((Iadem3)this.tree).updateNumberOfNodesSplitByTieBreaking(-subtree.numSplitsByBreakingTies);
            }
            Iadem3Subtree subtree = this.alternativeTree.get(index);
            int[] count = new int[3];
            super.getNumberOfNodes(count);
            if (this.causeOfSplit == ((Iadem3)this.tree).SPLIT_BY_TIE_BREAKING) {
                count[2] = count[2] + 1;
            }
            ((Iadem3)this.tree).updateNumberOfLeaves(-count[1]);
            ((Iadem3)this.tree).updateNumberOfNodes(-count[0] - count[1]);
            ((Iadem3)this.tree).updateNumberOfNodesSplitByTieBreaking(-count[2]);
            AdaptiveSplitNode tmpParent = (AdaptiveSplitNode)this.parent;
            Iadem2.Node newNode = subtree.getTreeRoot();
            ((Iadem3)this.tree).newTreeChange();
            if (tmpParent == null) {
                ((Iadem3)this.tree).copyTree(subtree);
            } else {
                for (int i = 0; i < tmpParent.children.size(); ++i) {
                    if (tmpParent.children.get(i) != this) continue;
                    tmpParent.children.set(i, newNode);
                    newNode.parent = tmpParent;
                }
            }
            this.updateAttributes(newNode);
            if (newNode instanceof AdaptiveSplitNode) {
                AdaptiveSplitNode splitNode = (AdaptiveSplitNode)newNode;
                for (Iadem3Subtree currentSubtree : splitNode.alternativeTree) {
                    this.updateSubtreeLevel(currentSubtree.getTreeRoot());
                }
            }
            return newNode;
        }

        void updateAttributes(Iadem2.Node newNode) {
            block4: {
                block3: {
                    if (newNode == null) {
                        return;
                    }
                    newNode.setTree(this.tree);
                    if (!(newNode instanceof AdaptiveSplitNode)) break block3;
                    AdaptiveSplitNode splitNode = (AdaptiveSplitNode)newNode;
                    splitNode.leaf.setTree(this.tree);
                    for (Iadem2.Node child : splitNode.children) {
                        this.updateAttributes(child);
                    }
                    break block4;
                }
                if (!(newNode instanceof AdaptiveLeafNode)) break block4;
                AdaptiveLeafNode leafNode = (AdaptiveLeafNode)newNode;
                AutoExpandVector<Iadem2.VirtualNode> virtualChildren = leafNode.getVirtualChildren();
                for (Iadem2.VirtualNode child : virtualChildren) {
                    if (child == null) continue;
                    child.setTree(this.tree);
                }
            }
        }

        protected void updateSubtreeLevel(Iadem2.Node node) {
            if (node != null) {
                --((Iadem3)node.getTree()).treeLevel;
                if (node instanceof AdaptiveSplitNode) {
                    AdaptiveSplitNode splitNode = (AdaptiveSplitNode)node;
                    for (Iadem2.Node child : splitNode.children) {
                        this.updateSubtreeLevelAux(child);
                    }
                    for (Iadem3Subtree subtree : splitNode.alternativeTree) {
                        this.updateSubtreeLevel(subtree.getTreeRoot());
                    }
                }
            }
        }

        protected void updateSubtreeLevelAux(Iadem2.Node node) {
            if (node != null && node instanceof AdaptiveSplitNode) {
                AdaptiveSplitNode splitNode = (AdaptiveSplitNode)node;
                for (Iadem3Subtree subtree : splitNode.alternativeTree) {
                    this.updateSubtreeLevel(subtree.getTreeRoot());
                }
                for (Iadem2.Node child : splitNode.children) {
                    this.updateSubtreeLevelAux(child);
                }
            }
        }

        void createTree(Instance instance) throws IademException {
            Iadem3 iadem3Tree = (Iadem3)this.tree;
            if (iadem3Tree.canCreateSubtree()) {
                int maxTreeLevel = iadem3Tree.getMaxNestingLevels();
                int maxAltSubtrees = iadem3Tree.getMaxAltSubtreesPerNode();
                if (!(maxTreeLevel != -1 && iadem3Tree.getTreeLevel() >= maxTreeLevel || maxAltSubtrees != -1 && this.alternativeTree.size() >= maxAltSubtrees || this.estimator == null)) {
                    Iadem3Subtree subtree = new Iadem3Subtree(this, iadem3Tree.getTreeLevel() + 1, (Iadem3)this.tree, instance);
                    this.alternativeTree.add(subtree);
                    ((Iadem3)this.tree).setNewTree();
                }
            }
        }

        public int getNumTrees() {
            int trees = this.alternativeTree.size() == 0 ? 0 : 1;
            for (Iadem2.Node child : this.children) {
                if (!(child instanceof AdaptiveSplitNode)) continue;
                trees += ((AdaptiveSplitNode)child).getNumTrees();
            }
            for (Iadem3Subtree subtree : this.alternativeTree) {
                if (!(subtree.getTreeRoot() instanceof AdaptiveSplitNode)) continue;
                AdaptiveSplitNode node = (AdaptiveSplitNode)subtree.getTreeRoot();
                trees += node.getNumTrees();
            }
            return trees;
        }

        @Override
        public double[] getClassVotes(Instance observacion) {
            double[] classDist = this.leaf.getClassVotes(observacion);
            double thisError = this.estimator.getEstimation();
            double leafError = this.leaf.estimator.getEstimation();
            int childIndex = this.instanceChildIndex(observacion);
            if (childIndex >= 0 && thisError < leafError) {
                Iadem2.Node hijo = this.getChild(childIndex);
                classDist = hijo.getClassVotes(observacion);
            }
            for (Iadem3Subtree subtree : this.alternativeTree) {
                double[] tmp = subtree.getClassVotes(observacion);
                double altWeight = 1.0 - subtree.estimacionValorMedio();
                for (int j = 0; j < classDist.length; ++j) {
                    classDist[j] = classDist[j] + tmp[j] * altWeight;
                }
            }
            return classDist;
        }

        @Override
        public int getSubtreeNodeCount() {
            int tmp = super.getSubtreeNodeCount();
            for (Iadem3Subtree subtree : this.alternativeTree) {
                tmp += subtree.getTreeRoot().getSubtreeNodeCount();
            }
            return tmp;
        }

        public double getErrorEstimation() {
            return this.estimator.getEstimation();
        }

        @Override
        public void getNumberOfNodes(int[] count) {
            for (Iadem3Subtree tree : this.alternativeTree) {
                tree.getNumberOfNodes(count);
            }
            if (this.causeOfSplit == ((Iadem3)this.tree).SPLIT_BY_TIE_BREAKING) {
                count[2] = count[2] + 1;
            }
            super.getNumberOfNodes(count);
        }

        public int getNumberOfSubtrees() {
            int count = this.alternativeTree.size();
            for (Iadem3Subtree subtree : this.alternativeTree) {
                count += subtree.getNumberOfSubtrees();
            }
            for (Iadem2.Node child : this.children) {
                if (!(child instanceof AdaptiveSplitNode)) continue;
                count += ((AdaptiveSplitNode)child).getNumberOfSubtrees();
            }
            return count;
        }

        private void prune() {
            this.leaf.setSplit(true);
            Iadem2.Node node = this.parent;
            while (node != null) {
                ((AdaptiveSplitNode)node).leaf.restartVariablesAtDrift();
                this.leaf.estimator = (AbstractChangeDetector)this.leaf.estimator.copy();
                node = node.parent;
            }
            this.leaf.setTree(this.tree);
            AutoExpandVector<Iadem2.VirtualNode> nodeList = this.leaf.getVirtualChildren();
            for (Iadem2.VirtualNode node2 : nodeList) {
                if (node2 == null) continue;
                node2.setTree(this.tree);
            }
            this.leaf.setParent(this.parent);
            if (this.parent == null) {
                this.tree.setTreeRoot(this.leaf);
            } else {
                ((Iadem2.SplitNode)this.parent).changeChildren(this, this.leaf);
            }
            int[] count = new int[3];
            this.getNumberOfNodes(count);
            ((Iadem3)this.tree).updateNumberOfLeaves(-count[1] + 1);
            ((Iadem3)this.tree).updateNumberOfNodes(-count[0] - count[1] + 1);
            ((Iadem3)this.tree).updateNumberOfNodesSplitByTieBreaking(-count[2]);
        }
    }

    public class AdaptiveNumericVirtualNode
    extends Iadem2.NumericVirtualNode
    implements Serializable,
    restartsVariablesAtDrift {
        private static final long serialVersionUID = 1L;
        protected IademNumericAttributeObserver altAttClassObserver;
        protected DoubleVector altClassDist;
        protected AbstractChangeDetector estimator;

        public AdaptiveNumericVirtualNode(Iadem3 tree, Iadem2.Node parent, int attID, IademNumericAttributeObserver observadorContinuos) {
            super(tree, parent, attID, observadorContinuos);
        }

        @Override
        public Iadem2.Node learnFromInstance(Instance inst) {
            this.updateCounters(inst);
            return super.learnFromInstance(inst);
        }

        private void updateCounters(Instance inst) {
            boolean correct;
            double[] classVotes = this.getClassVotes(inst);
            boolean bl = correct = Utils.maxIndex((double[])classVotes) == (int)inst.classValue();
            if (this.estimator != null) {
                Objects.requireNonNull((Iadem3)this.tree);
                double error = correct ? 0.0 : 1.0;
                this.estimator.input(error);
                if (this.estimator.getChange()) {
                    this.resetVariablesAtDrift();
                }
            }
        }

        private long sum(long[] arr) {
            long s = 0L;
            for (int i = 0; i < arr.length; ++i) {
                s += arr[i];
            }
            return s;
        }

        @Override
        public Iadem2.SplitNode getNewSplitNode(long counter, Iadem2.Node parent, IademAttributeSplitSuggestion bestSplit, Instance instance) {
            double[] cutPoints = new double[]{this.bestCutPoint};
            Iadem2.Node[] children = new Iadem2.Node[2];
            long[] newClassDist = this.numericAttClassObserver.getLeftClassDist(this.bestCutPoint);
            long sumClassDist = this.numericAttClassObserver.getValueCount();
            long[] sumAttClassDist = this.numericAttClassObserver.getClassDist();
            boolean equalsPassesTest = true;
            if (this.numericAttClassObserver instanceof IademVFMLNumericAttributeClassObserver) {
                equalsPassesTest = false;
            }
            AdaptiveSplitNode splitNode = new AdaptiveSplitNode((Iadem3)this.tree, parent, null, ((Iadem2.LeafNode)this.parent).getMajorityClassVotes(instance), new NumericAttributeBinaryTest(this.attIndex, cutPoints[0], equalsPassesTest), ((AdaptiveLeafNode)this.parent).estimator, (AdaptiveLeafNode)this.parent, ((Iadem3)this.tree).currentSplitState);
            long leftClassDist = this.sum(newClassDist);
            long rightClassDist = sumClassDist - leftClassDist;
            double[] newLeftClassDist = new double[instance.attribute(instance.classIndex()).numValues()];
            double[] newRightClassDist = new double[instance.attribute(instance.classIndex()).numValues()];
            Arrays.fill(newLeftClassDist, 0.0);
            Arrays.fill(newRightClassDist, 0.0);
            for (int i = 0; i < newClassDist.length; ++i) {
                newLeftClassDist[i] = newClassDist[i];
                newRightClassDist[i] = (double)sumAttClassDist[i] - newLeftClassDist[i];
            }
            splitNode.setChildren(null);
            children[0] = ((Iadem3)this.tree).newLeafNode(splitNode, counter, leftClassDist, newLeftClassDist, instance);
            children[1] = ((Iadem3)this.tree).newLeafNode(splitNode, counter, rightClassDist, newRightClassDist, instance);
            splitNode.setChildren(children);
            return splitNode;
        }

        @Override
        public void resetVariablesAtDrift() {
            this.bestSplitSuggestion = null;
            this.heuristicMeasureUpdated = false;
            this.numericAttClassObserver.reset();
            this.classValueDist = new DoubleVector();
        }
    }

    public class AdaptiveNominalVirtualNode
    extends Iadem2.NominalVirtualNode
    implements Serializable,
    restartsVariablesAtDrift {
        private static final long serialVersionUID = 1L;
        protected AbstractChangeDetector estimador;

        public AdaptiveNominalVirtualNode(Iadem3 tree, Iadem2.Node parent, int attID, boolean onlyMultiwayTest, boolean onlyBinaryTest) {
            super(tree, parent, attID, onlyMultiwayTest, onlyBinaryTest);
        }

        @Override
        public Iadem2.Node learnFromInstance(Instance inst) {
            double attValue = inst.value(this.attIndex);
            if (!Utils.isMissingValue((double)attValue)) {
                this.updateCountersForChange(inst);
            }
            return super.learnFromInstance(inst);
        }

        private void updateCountersForChange(Instance inst) {
            boolean trueClass;
            double[] classVotes = this.getClassVotes(inst);
            boolean bl = trueClass = Utils.maxIndex((double[])classVotes) == (int)inst.classValue();
            if (this.estimador != null) {
                Objects.requireNonNull((Iadem3)this.tree);
                double error = trueClass ? 0.0 : 1.0;
                this.estimador.input(error);
                if (this.estimador.getChange()) {
                    this.resetVariablesAtDrift();
                }
            }
        }

        @Override
        public Iadem2.SplitNode getNewSplitNode(long counter, Iadem2.Node parent, IademAttributeSplitSuggestion bestSplit, Instance instance) {
            Iadem2.Node[] children;
            AdaptiveSplitNode splitNode = new AdaptiveSplitNode((Iadem3)this.tree, parent, null, ((Iadem2.LeafNode)this.parent).getMajorityClassVotes(instance), bestSplit.splitTest, ((AdaptiveLeafNode)this.parent).estimator, (AdaptiveLeafNode)this.parent, ((Iadem3)this.tree).currentSplitState);
            if (bestSplit.splitTest instanceof NominalAttributeMultiwayTest) {
                children = new Iadem2.Node[instance.attribute(this.attIndex).numValues()];
                for (int i = 0; i < children.length; ++i) {
                    long tmpConter = 0L;
                    double[] newClassDist = new double[instance.attribute(instance.classIndex()).numValues()];
                    Arrays.fill(newClassDist, 0.0);
                    for (int j = 0; j < newClassDist.length; ++j) {
                        double tmpAttClassCounter;
                        DoubleVector tmpClassDist = (DoubleVector)this.nominalAttClassObserver.get(i);
                        newClassDist[j] = tmpAttClassCounter = tmpClassDist != null ? tmpClassDist.getValue(j) : 0.0;
                        tmpConter = (long)((double)tmpConter + newClassDist[j]);
                    }
                    children[i] = ((Iadem3)this.tree).newLeafNode(splitNode, counter, tmpConter, newClassDist, instance);
                }
            } else {
                int i;
                children = new Iadem2.Node[2];
                IademNominalAttributeBinaryTest binarySplit = (IademNominalAttributeBinaryTest)bestSplit.splitTest;
                double[] newClassDist = new double[instance.attribute(instance.classIndex()).numValues()];
                double tmpCounter = 0.0;
                Arrays.fill(newClassDist, 0.0);
                DoubleVector classDist = (DoubleVector)this.nominalAttClassObserver.get(binarySplit.getAttValue());
                for (i = 0; i < newClassDist.length; ++i) {
                    newClassDist[i] = classDist.getValue(i);
                    tmpCounter += classDist.getValue(i);
                }
                children[0] = ((Iadem3)this.tree).newLeafNode(splitNode, counter, (int)tmpCounter, newClassDist, instance);
                tmpCounter = this.classValueDist.sumOfValues() - tmpCounter;
                for (i = 0; i < newClassDist.length; ++i) {
                    newClassDist[i] = this.classValueDist.getValue(i) - newClassDist[i];
                }
                children[1] = ((Iadem3)this.tree).newLeafNode(splitNode, counter, (int)tmpCounter, newClassDist, instance);
            }
            splitNode.setChildren(children);
            return splitNode;
        }

        @Override
        public void resetVariablesAtDrift() {
            this.attValueDist = new DoubleVector();
            this.nominalAttClassObserver = new AutoExpandVector();
            this.classValueDist = new DoubleVector();
        }
    }

    public class AdaptiveLeafNodeWeightedVote
    extends AdaptiveLeafNodeNBAdaptive {
        private static final long serialVersionUID = 1L;

        public AdaptiveLeafNodeWeightedVote(Iadem3 tree, Iadem2.Node parent, long instTreeCountSinceVirtual, long instNodeCountSinceVirtual, double[] classDist, IademNumericAttributeObserver observadorContinuos, int naiveBayesLimit, boolean onlyMultiwayTest, boolean onlyBinaryTest, AbstractChangeDetector estimator, Instance instance) {
            super(tree, parent, instTreeCountSinceVirtual, instNodeCountSinceVirtual, classDist, observadorContinuos, naiveBayesLimit, onlyMultiwayTest, onlyBinaryTest, estimator, instance);
        }

        @Override
        public double[] getClassVotes(Instance instance) {
            double NBweight = 1.0 - this.naiveBayesError.getEstimation();
            double MCweight = 1.0 - this.majorityClassError.getEstimation();
            double[] MC = this.getMajorityClassVotes(instance);
            double[] NB = this.getNaiveBayesPrediction(instance);
            double[] votes = new double[MC.length];
            for (int i = 0; i < MC.length; ++i) {
                votes[i] = MC[i] * MCweight + NB[i] * NBweight;
            }
            return votes;
        }

        protected boolean isSignificantlyGreaterThan(double mean1, double mean2, int n1, int n2) {
            double m = 1.0 / (double)n1 + 1.0 / (double)n2;
            double confidence = 0.001;
            double log = Math.log(1.0 / confidence);
            double bound = Math.sqrt(m * log / 2.0);
            return mean1 - mean2 > bound;
        }
    }

    public class AdaptiveLeafNodeNBKirkby
    extends AdaptiveLeafNodeNB {
        private static final long serialVersionUID = 1L;
        protected int naiveBayesError;
        protected int majorityClassError;

        public AdaptiveLeafNodeNBKirkby(Iadem3 tree, Iadem2.Node parent, long instancesProcessedByTheTree, long instancesProcessedByThisLeaf, double[] classDist, IademNumericAttributeObserver observadorContinuos, int naiveBayesLimit, boolean onlyMultiwayTest, boolean onlyBinaryTest, AbstractChangeDetector estimator, Instance instance) {
            super(tree, parent, instancesProcessedByTheTree, instancesProcessedByThisLeaf, classDist, observadorContinuos, naiveBayesLimit, estimator, onlyMultiwayTest, onlyBinaryTest, instance);
            this.naiveBayesError = 0;
            this.majorityClassError = 0;
        }

        @Override
        public double[] getClassVotes(Instance instance) {
            if (this.naiveBayesError > this.majorityClassError) {
                return this.getMajorityClassVotes(instance);
            }
            return this.getNaiveBayesPrediction(instance);
        }

        @Override
        public Iadem2.Node learnFromInstance(Instance inst) {
            double[] classVotes = this.getMajorityClassVotes(inst);
            double error = Utils.maxIndex((double[])classVotes) == (int)inst.classValue() ? 0.0 : 1.0;
            this.majorityClassError = (int)((double)this.majorityClassError + error);
            classVotes = this.getNaiveBayesPrediction(inst);
            error = Utils.maxIndex((double[])classVotes) == (int)inst.classValue() ? 0.0 : 1.0;
            this.naiveBayesError = (int)((double)this.naiveBayesError + error);
            return super.learnFromInstance(inst);
        }
    }

    public class AdaptiveLeafNodeNBAdaptive
    extends AdaptiveLeafNodeNB {
        private static final long serialVersionUID = 1L;
        protected AbstractChangeDetector naiveBayesError;
        protected AbstractChangeDetector majorityClassError;

        public AdaptiveLeafNodeNBAdaptive(Iadem3 tree, Iadem2.Node parent, long instancesProcessedByTheTree, long instancesProcessedByThisLeaf, double[] classDist, IademNumericAttributeObserver observadorContinuos, int naiveBayesLimit, boolean onlyMultiwayTest, boolean onlyBinaryTest, AbstractChangeDetector estimator, Instance instance) {
            super(tree, parent, instancesProcessedByTheTree, instancesProcessedByThisLeaf, classDist, observadorContinuos, naiveBayesLimit, estimator, onlyMultiwayTest, onlyBinaryTest, instance);
            this.naiveBayesError = (AbstractChangeDetector)estimator.copy();
            this.majorityClassError = (AbstractChangeDetector)estimator.copy();
        }

        @Override
        public double[] getClassVotes(Instance instance) {
            double mean2;
            double mean1 = this.naiveBayesError.getEstimation();
            if (mean1 > (mean2 = this.majorityClassError.getEstimation())) {
                return this.getMajorityClassVotes(instance);
            }
            return this.getNaiveBayesPrediction(instance);
        }

        @Override
        public Iadem2.Node learnFromInstance(Instance inst) {
            double[] classVote = this.getMajorityClassVotes(inst);
            double error = Utils.maxIndex((double[])classVote) == (int)inst.classValue() ? 0.0 : 1.0;
            this.majorityClassError.input(error);
            classVote = this.getNaiveBayesPrediction(inst);
            error = Utils.maxIndex((double[])classVote) == (int)inst.classValue() ? 0.0 : 1.0;
            this.naiveBayesError.input(error);
            return super.learnFromInstance(inst);
        }
    }

    public class AdaptiveLeafNodeNB
    extends AdaptiveLeafNode {
        private static final long serialVersionUID = 1L;
        protected int limitNaiveBayes;

        public AdaptiveLeafNodeNB(Iadem3 tree, Iadem2.Node parent, long instTreeCountSinceVirtual, long instNodeCountSinceVirtual, double[] initialClassCount, IademNumericAttributeObserver numericAttClassObserver, int limitNaiveBayes, AbstractChangeDetector estimator, boolean onlyMultiwayTest, boolean onlyBinaryTest, Instance instance) {
            super(tree, parent, instTreeCountSinceVirtual, instNodeCountSinceVirtual, initialClassCount, numericAttClassObserver, estimator, onlyMultiwayTest, onlyBinaryTest, instance);
            this.limitNaiveBayes = limitNaiveBayes;
        }

        @Override
        public double[] getClassVotes(Instance inst) {
            double[] votes = this.instNodeCountSinceVirtual == 0L || this.instNodeCountSinceReal < (long)this.limitNaiveBayes ? this.getMajorityClassVotes(inst) : this.getNaiveBayesPrediction(inst);
            return votes;
        }

        protected double[] getNaiveBayesPrediction(Instance inst) {
            int i;
            double[] classDist = this.getMajorityClassVotes(inst);
            DoubleVector conditionalProbability = null;
            for (int i2 = 0; i2 < this.virtualChildren.size(); ++i2) {
                double currentValue;
                Iadem2.VirtualNode virtual = (Iadem2.VirtualNode)this.virtualChildren.get(i2);
                if (virtual == null || !virtual.hasInformation() || (conditionalProbability = virtual.computeConditionalProbability(currentValue = inst.value(i2))) == null) continue;
                for (int j = 0; j < classDist.length; ++j) {
                    int n = j;
                    classDist[n] = classDist[n] * conditionalProbability.getValue(j);
                }
            }
            double sum = 0.0;
            for (i = 0; i < classDist.length; ++i) {
                sum += classDist[i];
            }
            if (sum == 0.0) {
                for (i = 0; i < classDist.length; ++i) {
                    classDist[i] = 1.0 / (double)classDist.length;
                }
            } else {
                i = 0;
                while (i < classDist.length) {
                    int n = i++;
                    classDist[n] = classDist[n] / sum;
                }
            }
            return classDist;
        }
    }

    public class AdaptiveLeafNode
    extends Iadem2.LeafNode
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected AbstractChangeDetector estimator;

        public AdaptiveLeafNode(Iadem3 arbol, Iadem2.Node parent, long instTreeCountSinceVirtual, long instNodeCountSinceVirtual, double[] initialClassCount, IademNumericAttributeObserver numericAttClassObserver, AbstractChangeDetector estimator, boolean onlyMultiwayTest, boolean onlyBinaryTest, Instance instance) {
            super(arbol, parent, instTreeCountSinceVirtual, instNodeCountSinceVirtual, initialClassCount, numericAttClassObserver, onlyMultiwayTest, onlyBinaryTest, instance);
            this.estimator = estimator != null ? (AbstractChangeDetector)estimator.copy() : null;
        }

        @Override
        protected void createVirtualNodes(IademNumericAttributeObserver numericAttClassObserver, boolean onlyMultiwayTest, boolean onlyBinaryTest, Instance instance) {
            ArrayList<Integer> nominalUsed = this.nominalAttUsed(instance);
            TreeSet<Integer> sort = new TreeSet<Integer>(nominalUsed);
            for (int i = 0; i < instance.numAttributes(); ++i) {
                if (instance.classIndex() != i && instance.attribute(i).isNominal()) {
                    if (!sort.isEmpty() && i == sort.first()) {
                        sort.remove(new Integer(sort.first()));
                        this.virtualChildren.set(i, null);
                        continue;
                    }
                    this.virtualChildren.set(i, new AdaptiveNominalVirtualNode((Iadem3)this.tree, (Iadem2.Node)this, i, onlyMultiwayTest, onlyBinaryTest));
                    continue;
                }
                if (instance.classIndex() != i && instance.attribute(i).isNumeric()) {
                    this.virtualChildren.set(i, new AdaptiveNumericVirtualNode((Iadem3)this.tree, (Iadem2.Node)this, i, numericAttClassObserver));
                    continue;
                }
                this.virtualChildren.set(i, null);
            }
        }

        private void updateCounters(Instance experiencia) {
            boolean trueClass;
            double[] classVotes = this.getClassVotes(experiencia);
            boolean bl = trueClass = Utils.maxIndex((double[])classVotes) == (int)experiencia.classValue();
            if (this.estimator != null) {
                Objects.requireNonNull((Iadem3)this.tree);
                double error = trueClass ? 0.0 : 1.0;
                this.estimator.input(error);
                if (this.estimator.getChange()) {
                    this.restartVariablesAtDrift();
                }
            }
        }

        @Override
        public void attemptToSplit(Instance instance) {
            if (this.classValueDist.numNonZeroEntries() > 1 && this.hasInformationToSplit()) {
                try {
                    this.instSeenSinceLastSplitAttempt = 0.0;
                    if (this.instNodeCountSinceReal > 5000L) {
                        ((Iadem3)this.tree).updateNumberOfNodesSplitByTieBreaking(1);
                        IademAttributeSplitSuggestion bestSplitSuggestion = this.getFastSplitSuggestion(instance);
                        if (bestSplitSuggestion != null) {
                            ((Iadem3)this.tree).currentSplitState = ((Iadem3)this.tree).SPLIT_BY_TIE_BREAKING;
                            this.doSplit(bestSplitSuggestion, instance);
                        }
                    } else {
                        IademAttributeSplitSuggestion bestSplitSuggestion = this.getBestSplitSuggestion(instance);
                        if (bestSplitSuggestion != null) {
                            Iadem3 iadem3 = (Iadem3)this.tree;
                            Objects.requireNonNull((Iadem3)this.tree);
                            iadem3.currentSplitState = 1;
                            this.doSplit(bestSplitSuggestion, instance);
                        }
                    }
                }
                catch (IademException ex) {
                    Logger.getLogger(Iadem2.LeafNode.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }

        @Override
        public Iadem2.Node learnFromInstance(Instance inst) {
            this.updateCounters(inst);
            return super.learnFromInstance(inst);
        }

        public AdaptiveLeafNode[] doSplit(IademAttributeSplitSuggestion mejorExpansion, Instance instance) {
            AdaptiveSplitNode splitNode = (AdaptiveSplitNode)((Iadem2.VirtualNode)this.virtualChildren.get(mejorExpansion.splitTest.getAttsTestDependsOn()[0])).getNewSplitNode(this.instTreeCountSinceReal, this.parent, mejorExpansion, instance);
            splitNode.setParent(this.parent);
            splitNode.estimator = this.tree.newEstimator();
            if (this.parent == null) {
                this.tree.setTreeRoot(splitNode);
            } else {
                ((Iadem2.SplitNode)this.parent).changeChildren(this, splitNode);
            }
            this.tree.newSplit(splitNode.getLeaves().size());
            return null;
        }

        protected void restartVariablesAtDrift() {
            this.instNodeCountSinceVirtual = 0L;
            this.classValueDist = new DoubleVector();
            this.instTreeCountSinceReal = 0L;
            this.instNodeCountSinceReal = 0L;
            for (int i = 0; i < this.virtualChildren.size(); ++i) {
                if (this.virtualChildren.get(i) == null) continue;
                ((restartsVariablesAtDrift)this.virtualChildren.get(i)).resetVariablesAtDrift();
            }
        }
    }
}

