/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.core.tramo;

import java.util.function.IntToDoubleFunction;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.stats.AutoCovariances;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.api.timeseries.regression.ModellingUtility;
import jdplus.toolkit.base.api.timeseries.regression.Variable;
import jdplus.toolkit.base.core.regsarima.regular.ModelDescription;
import jdplus.toolkit.base.core.stats.likelihood.ConcentratedLikelihood;
import jdplus.toolkit.base.core.stats.samples.Sample;
import jdplus.toolkit.base.core.stats.tests.LjungBox;
import jdplus.toolkit.base.core.stats.tests.Skewness;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class ModelStatistics {
    private final int outliersCount;
    private final int observationsCount;
    private final int effectiveObservationsCount;
    private final double bic;
    private final double se;
    private final double ljungBox;
    private final double ljungBoxPvalue;
    private final double seasonalLjungBox;
    private final double seasonalLjungBoxPvalue;
    private final double skewnessAbsvalue;
    private final double skewnessPvalue;
    private final double stableMean;
    private final double stableMeanPvalue;
    private final double stableVariance;
    private final double stableVariancePvalue;

    private static Builder builder() {
        return new Builder();
    }

    public static ModelStatistics of(ModelDescription m, ConcentratedLikelihood ll) {
        DoubleSeq e = ll.e();
        int p = m.getAnnualFrequency();
        int nres = e.length();
        int nhp = m.getArimaSpec().freeParametersCount();
        int n = LjungBox.defaultAutoCorrelationsCount((int)p, (int)nres);
        IntToDoubleFunction acf = AutoCovariances.autoCorrelationFunction((DoubleSeq)e, (double)0.0);
        StatisticalTest lb = new LjungBox(acf, nres).autoCorrelationsCount(n).hyperParametersCount(nhp).build();
        StatisticalTest sk = new Skewness(e).build();
        int nobs = ll.dim();
        double bic = Math.log(ll.sigma2()) + (double)(nhp + ll.nx()) * Math.log(nobs) / (double)nobs;
        Builder builder = ModelStatistics.builder().outliersCount((int)m.variables().filter(var -> ModellingUtility.isOutlier((Variable)var, (boolean)true)).count()).observationsCount(m.getEstimationDomain().getLength()).effectiveObservationsCount(ll.dim()).bic(bic).se(Math.sqrt(ll.ssq() / (double)(ll.degreesOfFreedom() - nhp))).ljungBox(lb.getValue()).ljungBoxPvalue(lb.getPvalue()).skewnessAbsvalue(Math.abs(sk.getValue())).skewnessPvalue(sk.getPvalue());
        if (p > 1) {
            try {
                StatisticalTest lbs = p == 1 ? null : new LjungBox(acf, nres).autoCorrelationsCount(2).lag(p).build();
                builder.seasonalLjungBox(lbs.getValue()).seasonalLjungBoxPvalue(lbs.getPvalue());
            }
            catch (Exception lbs) {
                // empty catch block
            }
        }
        int nres2 = (1 + nres) / 2;
        int nlast = Math.min(nres2, 10 * p);
        DoubleSeq data0 = e.range(0, nres - nlast);
        DoubleSeq data1 = e.range(nlast, nres);
        Sample s0 = Sample.ofResiduals((DoubleSeq)data0);
        Sample s1 = Sample.ofResiduals((DoubleSeq)data1);
        StatisticalTest means = Sample.compareMeans((Sample)s0, (Sample)s1, (boolean)true);
        StatisticalTest vars = Sample.compareVariances((Sample)s0, (Sample)s1);
        return builder.stableMean(means.getValue()).stableMeanPvalue(means.getPvalue()).stableVariance(vars.getValue()).stableVariancePvalue(vars.getPvalue()).build();
    }

    @Generated
    ModelStatistics(int outliersCount, int observationsCount, int effectiveObservationsCount, double bic, double se, double ljungBox, double ljungBoxPvalue, double seasonalLjungBox, double seasonalLjungBoxPvalue, double skewnessAbsvalue, double skewnessPvalue, double stableMean, double stableMeanPvalue, double stableVariance, double stableVariancePvalue) {
        this.outliersCount = outliersCount;
        this.observationsCount = observationsCount;
        this.effectiveObservationsCount = effectiveObservationsCount;
        this.bic = bic;
        this.se = se;
        this.ljungBox = ljungBox;
        this.ljungBoxPvalue = ljungBoxPvalue;
        this.seasonalLjungBox = seasonalLjungBox;
        this.seasonalLjungBoxPvalue = seasonalLjungBoxPvalue;
        this.skewnessAbsvalue = skewnessAbsvalue;
        this.skewnessPvalue = skewnessPvalue;
        this.stableMean = stableMean;
        this.stableMeanPvalue = stableMeanPvalue;
        this.stableVariance = stableVariance;
        this.stableVariancePvalue = stableVariancePvalue;
    }

    @Generated
    public int getOutliersCount() {
        return this.outliersCount;
    }

    @Generated
    public int getObservationsCount() {
        return this.observationsCount;
    }

    @Generated
    public int getEffectiveObservationsCount() {
        return this.effectiveObservationsCount;
    }

    @Generated
    public double getBic() {
        return this.bic;
    }

    @Generated
    public double getSe() {
        return this.se;
    }

    @Generated
    public double getLjungBox() {
        return this.ljungBox;
    }

    @Generated
    public double getLjungBoxPvalue() {
        return this.ljungBoxPvalue;
    }

    @Generated
    public double getSeasonalLjungBox() {
        return this.seasonalLjungBox;
    }

    @Generated
    public double getSeasonalLjungBoxPvalue() {
        return this.seasonalLjungBoxPvalue;
    }

    @Generated
    public double getSkewnessAbsvalue() {
        return this.skewnessAbsvalue;
    }

    @Generated
    public double getSkewnessPvalue() {
        return this.skewnessPvalue;
    }

    @Generated
    public double getStableMean() {
        return this.stableMean;
    }

    @Generated
    public double getStableMeanPvalue() {
        return this.stableMeanPvalue;
    }

    @Generated
    public double getStableVariance() {
        return this.stableVariance;
    }

    @Generated
    public double getStableVariancePvalue() {
        return this.stableVariancePvalue;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModelStatistics)) {
            return false;
        }
        ModelStatistics other = (ModelStatistics)o;
        if (this.getOutliersCount() != other.getOutliersCount()) {
            return false;
        }
        if (this.getObservationsCount() != other.getObservationsCount()) {
            return false;
        }
        if (this.getEffectiveObservationsCount() != other.getEffectiveObservationsCount()) {
            return false;
        }
        if (Double.compare(this.getBic(), other.getBic()) != 0) {
            return false;
        }
        if (Double.compare(this.getSe(), other.getSe()) != 0) {
            return false;
        }
        if (Double.compare(this.getLjungBox(), other.getLjungBox()) != 0) {
            return false;
        }
        if (Double.compare(this.getLjungBoxPvalue(), other.getLjungBoxPvalue()) != 0) {
            return false;
        }
        if (Double.compare(this.getSeasonalLjungBox(), other.getSeasonalLjungBox()) != 0) {
            return false;
        }
        if (Double.compare(this.getSeasonalLjungBoxPvalue(), other.getSeasonalLjungBoxPvalue()) != 0) {
            return false;
        }
        if (Double.compare(this.getSkewnessAbsvalue(), other.getSkewnessAbsvalue()) != 0) {
            return false;
        }
        if (Double.compare(this.getSkewnessPvalue(), other.getSkewnessPvalue()) != 0) {
            return false;
        }
        if (Double.compare(this.getStableMean(), other.getStableMean()) != 0) {
            return false;
        }
        if (Double.compare(this.getStableMeanPvalue(), other.getStableMeanPvalue()) != 0) {
            return false;
        }
        if (Double.compare(this.getStableVariance(), other.getStableVariance()) != 0) {
            return false;
        }
        return Double.compare(this.getStableVariancePvalue(), other.getStableVariancePvalue()) == 0;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getOutliersCount();
        result = result * 59 + this.getObservationsCount();
        result = result * 59 + this.getEffectiveObservationsCount();
        long $bic = Double.doubleToLongBits(this.getBic());
        result = result * 59 + (int)($bic >>> 32 ^ $bic);
        long $se = Double.doubleToLongBits(this.getSe());
        result = result * 59 + (int)($se >>> 32 ^ $se);
        long $ljungBox = Double.doubleToLongBits(this.getLjungBox());
        result = result * 59 + (int)($ljungBox >>> 32 ^ $ljungBox);
        long $ljungBoxPvalue = Double.doubleToLongBits(this.getLjungBoxPvalue());
        result = result * 59 + (int)($ljungBoxPvalue >>> 32 ^ $ljungBoxPvalue);
        long $seasonalLjungBox = Double.doubleToLongBits(this.getSeasonalLjungBox());
        result = result * 59 + (int)($seasonalLjungBox >>> 32 ^ $seasonalLjungBox);
        long $seasonalLjungBoxPvalue = Double.doubleToLongBits(this.getSeasonalLjungBoxPvalue());
        result = result * 59 + (int)($seasonalLjungBoxPvalue >>> 32 ^ $seasonalLjungBoxPvalue);
        long $skewnessAbsvalue = Double.doubleToLongBits(this.getSkewnessAbsvalue());
        result = result * 59 + (int)($skewnessAbsvalue >>> 32 ^ $skewnessAbsvalue);
        long $skewnessPvalue = Double.doubleToLongBits(this.getSkewnessPvalue());
        result = result * 59 + (int)($skewnessPvalue >>> 32 ^ $skewnessPvalue);
        long $stableMean = Double.doubleToLongBits(this.getStableMean());
        result = result * 59 + (int)($stableMean >>> 32 ^ $stableMean);
        long $stableMeanPvalue = Double.doubleToLongBits(this.getStableMeanPvalue());
        result = result * 59 + (int)($stableMeanPvalue >>> 32 ^ $stableMeanPvalue);
        long $stableVariance = Double.doubleToLongBits(this.getStableVariance());
        result = result * 59 + (int)($stableVariance >>> 32 ^ $stableVariance);
        long $stableVariancePvalue = Double.doubleToLongBits(this.getStableVariancePvalue());
        result = result * 59 + (int)($stableVariancePvalue >>> 32 ^ $stableVariancePvalue);
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "ModelStatistics(outliersCount=" + this.getOutliersCount() + ", observationsCount=" + this.getObservationsCount() + ", effectiveObservationsCount=" + this.getEffectiveObservationsCount() + ", bic=" + this.getBic() + ", se=" + this.getSe() + ", ljungBox=" + this.getLjungBox() + ", ljungBoxPvalue=" + this.getLjungBoxPvalue() + ", seasonalLjungBox=" + this.getSeasonalLjungBox() + ", seasonalLjungBoxPvalue=" + this.getSeasonalLjungBoxPvalue() + ", skewnessAbsvalue=" + this.getSkewnessAbsvalue() + ", skewnessPvalue=" + this.getSkewnessPvalue() + ", stableMean=" + this.getStableMean() + ", stableMeanPvalue=" + this.getStableMeanPvalue() + ", stableVariance=" + this.getStableVariance() + ", stableVariancePvalue=" + this.getStableVariancePvalue() + ")";
    }

    @Generated
    public static class Builder {
        @Generated
        private int outliersCount;
        @Generated
        private int observationsCount;
        @Generated
        private int effectiveObservationsCount;
        @Generated
        private double bic;
        @Generated
        private double se;
        @Generated
        private double ljungBox;
        @Generated
        private double ljungBoxPvalue;
        @Generated
        private double seasonalLjungBox;
        @Generated
        private double seasonalLjungBoxPvalue;
        @Generated
        private double skewnessAbsvalue;
        @Generated
        private double skewnessPvalue;
        @Generated
        private double stableMean;
        @Generated
        private double stableMeanPvalue;
        @Generated
        private double stableVariance;
        @Generated
        private double stableVariancePvalue;

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder outliersCount(int outliersCount) {
            this.outliersCount = outliersCount;
            return this;
        }

        @Generated
        public @NonNull Builder observationsCount(int observationsCount) {
            this.observationsCount = observationsCount;
            return this;
        }

        @Generated
        public @NonNull Builder effectiveObservationsCount(int effectiveObservationsCount) {
            this.effectiveObservationsCount = effectiveObservationsCount;
            return this;
        }

        @Generated
        public @NonNull Builder bic(double bic) {
            this.bic = bic;
            return this;
        }

        @Generated
        public @NonNull Builder se(double se) {
            this.se = se;
            return this;
        }

        @Generated
        public @NonNull Builder ljungBox(double ljungBox) {
            this.ljungBox = ljungBox;
            return this;
        }

        @Generated
        public @NonNull Builder ljungBoxPvalue(double ljungBoxPvalue) {
            this.ljungBoxPvalue = ljungBoxPvalue;
            return this;
        }

        @Generated
        public @NonNull Builder seasonalLjungBox(double seasonalLjungBox) {
            this.seasonalLjungBox = seasonalLjungBox;
            return this;
        }

        @Generated
        public @NonNull Builder seasonalLjungBoxPvalue(double seasonalLjungBoxPvalue) {
            this.seasonalLjungBoxPvalue = seasonalLjungBoxPvalue;
            return this;
        }

        @Generated
        public @NonNull Builder skewnessAbsvalue(double skewnessAbsvalue) {
            this.skewnessAbsvalue = skewnessAbsvalue;
            return this;
        }

        @Generated
        public @NonNull Builder skewnessPvalue(double skewnessPvalue) {
            this.skewnessPvalue = skewnessPvalue;
            return this;
        }

        @Generated
        public @NonNull Builder stableMean(double stableMean) {
            this.stableMean = stableMean;
            return this;
        }

        @Generated
        public @NonNull Builder stableMeanPvalue(double stableMeanPvalue) {
            this.stableMeanPvalue = stableMeanPvalue;
            return this;
        }

        @Generated
        public @NonNull Builder stableVariance(double stableVariance) {
            this.stableVariance = stableVariance;
            return this;
        }

        @Generated
        public @NonNull Builder stableVariancePvalue(double stableVariancePvalue) {
            this.stableVariancePvalue = stableVariancePvalue;
            return this;
        }

        @Generated
        public @NonNull ModelStatistics build() {
            return new ModelStatistics(this.outliersCount, this.observationsCount, this.effectiveObservationsCount, this.bic, this.se, this.ljungBox, this.ljungBoxPvalue, this.seasonalLjungBox, this.seasonalLjungBoxPvalue, this.skewnessAbsvalue, this.skewnessPvalue, this.stableMean, this.stableMeanPvalue, this.stableVariance, this.stableVariancePvalue);
        }

        @Generated
        public @NonNull String toString() {
            return "ModelStatistics.Builder(outliersCount=" + this.outliersCount + ", observationsCount=" + this.observationsCount + ", effectiveObservationsCount=" + this.effectiveObservationsCount + ", bic=" + this.bic + ", se=" + this.se + ", ljungBox=" + this.ljungBox + ", ljungBoxPvalue=" + this.ljungBoxPvalue + ", seasonalLjungBox=" + this.seasonalLjungBox + ", seasonalLjungBoxPvalue=" + this.seasonalLjungBoxPvalue + ", skewnessAbsvalue=" + this.skewnessAbsvalue + ", skewnessPvalue=" + this.skewnessPvalue + ", stableMean=" + this.stableMean + ", stableMeanPvalue=" + this.stableMeanPvalue + ", stableVariance=" + this.stableVariance + ", stableVariancePvalue=" + this.stableVariancePvalue + ")";
        }
    }
}

