/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.discrete;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.data.normalizer.SafeNormalizer;
import jdplus.toolkit.base.core.discrete.DiscreteModel;
import jdplus.toolkit.base.core.discrete.DiscreteModelEvaluation;
import jdplus.toolkit.base.core.discrete.llFn;
import jdplus.toolkit.base.core.math.functions.FunctionMinimizer;
import jdplus.toolkit.base.core.math.functions.bfgs.Bfgs;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.stats.linearmodel.LeastSquaresResults;
import jdplus.toolkit.base.core.stats.linearmodel.LinearModel;
import jdplus.toolkit.base.core.stats.linearmodel.Ols;
import lombok.Generated;

public final class DiscreteModelKernel {
    static DiscreteModelEvaluation process(DiscreteModel model, FunctionMinimizer minimizer) {
        SafeNormalizer normalizer = new SafeNormalizer();
        FastMatrix Xnorm = model.X.deepClone();
        double[] xnorm = new double[Xnorm.getColumnsCount()];
        DataBlockIterator columns = Xnorm.columnsIterator();
        int pos = 0;
        while (columns.hasNext()) {
            xnorm[pos++] = normalizer.normalize(columns.next());
        }
        DiscreteModel modelc = new DiscreteModel(model.y, Xnorm, model.cdf);
        DoubleSeq c = DiscreteModelKernel.initialize(model.y, Xnorm);
        llFn fn = new llFn(modelc);
        if (minimizer == null) {
            minimizer = Bfgs.builder().build();
        }
        if (!minimizer.minimize(fn.evaluate(c))) {
            return null;
        }
        llFn.Point rslt = (llFn.Point)minimizer.getResult();
        double[] coeff = rslt.getParameters().toArray();
        for (int i = 0; i < coeff.length; ++i) {
            int n = i;
            coeff[n] = coeff[n] * xnorm[i];
        }
        DoubleSeq b = DoubleSeq.of((double[])coeff);
        llFn ll = new llFn(model);
        double[] grad = ll.loglikelihoodGradient(b);
        double[] probabilities = ll.probabilities(b);
        return DiscreteModelEvaluation.builder().model(model).coefficients(b).probabilities(DoubleSeq.of((double[])probabilities)).gradient(DoubleSeq.of((double[])grad)).build();
    }

    private static DoubleSeq initialize(int[] y, FastMatrix X) {
        double[] dy = new double[y.length];
        for (int i = 0; i < y.length; ++i) {
            dy[i] = y[i];
        }
        LinearModel model = LinearModel.builder().y(DoubleSeq.of((double[])dy)).addX((Matrix)X).build();
        LeastSquaresResults ls = Ols.compute(model);
        return ls.getCoefficients();
    }

    @Generated
    private DiscreteModelKernel() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

