/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.visu;

import choco.kernel.common.IDotty;
import choco.kernel.visu.AbstractVisuManager;
import choco.kernel.visu.VisuFactory;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

class DotManager
extends AbstractVisuManager {
    private static final DotManager SINGLOTON = new DotManager();

    private DotManager() {
    }

    public static final DotManager getInstance() {
        return SINGLOTON;
    }

    @Override
    protected String getFileExtension() {
        return "dot";
    }

    @Override
    protected boolean doExport(File file, Object chart, int width, int height) throws IOException {
        if (chart instanceof IDotty) {
            IDotty source = (IDotty)chart;
            FileWriter fw = new FileWriter(file);
            fw.write("digraph g {\n\n");
            fw.write(source.toDotty());
            fw.write("\n}");
            fw.close();
            return true;
        }
        return false;
    }

    @Override
    protected boolean doShow(Object chart, int width, int height) {
        File file = this.export(null, null, chart, width, height);
        if (file != null) {
            VisuFactory.launchCommand(false, "/home/nono/bin/xdot", file.getAbsolutePath());
            return true;
        }
        return false;
    }
}

