/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.stat;

import cern.colt.list.DoubleArrayList;
import cern.jet.stat.Descriptive;
import java.util.logging.Level;
import java.util.logging.Logger;
import umontreal.iro.lecuyer.stat.Tally;
import umontreal.iro.lecuyer.util.PrintfFormat;

public class TallyStore
extends Tally {
    private DoubleArrayList array = null;
    private Logger log = Logger.getLogger("umontreal.iro.lecuyer.stat");

    public TallyStore() {
        this.array = new DoubleArrayList();
    }

    public TallyStore(String string) {
        super(string);
        this.array = new DoubleArrayList();
    }

    public TallyStore(int n) {
        this.array = new DoubleArrayList(n);
    }

    public TallyStore(String string, int n) {
        super(string);
        this.array = new DoubleArrayList(n);
    }

    public TallyStore(DoubleArrayList doubleArrayList) {
        this.array = doubleArrayList;
        this.array.clear();
    }

    public void init() {
        super.init();
        if (this.array != null) {
            this.array.clear();
        }
    }

    public void add(double d) {
        if (this.collect) {
            this.array.add(d);
        }
        super.add(d);
    }

    public double[] getArray() {
        this.array.trimToSize();
        return this.array.elements();
    }

    public DoubleArrayList getDoubleArrayList() {
        this.array.trimToSize();
        return this.array;
    }

    public void quickSort() {
        this.array.quickSort();
    }

    public double covariance(TallyStore tallyStore) {
        if (this.numberObs() != tallyStore.numberObs()) {
            this.log.logp(Level.WARNING, "TallyStore", "covariance", "This tally, with name " + this.getName() + ", contains " + this.numberObs() + " observations while " + "the given tally, with name " + tallyStore.getName() + ", contains " + tallyStore.numberObs() + "observations");
            return Double.NaN;
        }
        if (this.numberObs() < 2 || tallyStore.numberObs() < 2) {
            this.log.logp(Level.WARNING, "TallyStore", "covariance", "This tally, with name " + this.getName() + ", contains " + this.numberObs() + " observation");
            return Double.NaN;
        }
        return Descriptive.covariance((DoubleArrayList)this.getDoubleArrayList(), (DoubleArrayList)tallyStore.getDoubleArrayList());
    }

    public TallyStore clone() {
        TallyStore tallyStore = (TallyStore)super.clone();
        tallyStore.array = (DoubleArrayList)this.array.clone();
        return tallyStore;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.numberObs(); ++i) {
            stringBuffer.append(i + "    " + this.array.getQuick(i) + PrintfFormat.NEWLINE);
        }
        return stringBuffer.toString();
    }
}

