/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SingleIndex;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.Utils;
import weka.core.WeightedAttributesHandler;
import weka.core.WeightedInstancesHandler;
import weka.filters.Filter;
import weka.filters.StreamableFilter;
import weka.filters.UnsupervisedFilter;

public class SwapValues
extends Filter
implements UnsupervisedFilter,
StreamableFilter,
OptionHandler,
WeightedInstancesHandler,
WeightedAttributesHandler {
    static final long serialVersionUID = 6155834679414275855L;
    private final SingleIndex m_AttIndex = new SingleIndex("last");
    private final SingleIndex m_FirstIndex = new SingleIndex("first");
    private final SingleIndex m_SecondIndex = new SingleIndex("last");

    public String globalInfo() {
        return "Swaps two values of a nominal attribute.";
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        this.m_AttIndex.setUpper(instanceInfo.numAttributes() - 1);
        this.m_FirstIndex.setUpper(instanceInfo.attribute(this.m_AttIndex.getIndex()).numValues() - 1);
        this.m_SecondIndex.setUpper(instanceInfo.attribute(this.m_AttIndex.getIndex()).numValues() - 1);
        if (!instanceInfo.attribute(this.m_AttIndex.getIndex()).isNominal()) {
            throw new UnsupportedAttributeTypeException("Chosen attribute not nominal.");
        }
        if (instanceInfo.attribute(this.m_AttIndex.getIndex()).numValues() < 2) {
            throw new UnsupportedAttributeTypeException("Chosen attribute has less than two values.");
        }
        this.setOutputFormat();
        return true;
    }

    @Override
    public boolean input(Instance instance) {
        Instance newInstance;
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (!(newInstance = (Instance)instance.copy()).isMissing(this.m_AttIndex.getIndex())) {
            if ((int)newInstance.value(this.m_AttIndex.getIndex()) == this.m_SecondIndex.getIndex()) {
                newInstance.setValue(this.m_AttIndex.getIndex(), (double)this.m_FirstIndex.getIndex());
            } else if ((int)newInstance.value(this.m_AttIndex.getIndex()) == this.m_FirstIndex.getIndex()) {
                newInstance.setValue(this.m_AttIndex.getIndex(), (double)this.m_SecondIndex.getIndex());
            }
        }
        this.push(newInstance, false);
        return true;
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(3);
        newVector.addElement(new Option("\tSets the attribute index (default last).", "C", 1, "-C <col>"));
        newVector.addElement(new Option("\tSets the first value's index (default first).", "F", 1, "-F <value index>"));
        newVector.addElement(new Option("\tSets the second value's index (default last).", "S", 1, "-S <value index>"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String attIndex = Utils.getOption('C', options);
        if (attIndex.length() != 0) {
            this.setAttributeIndex(attIndex);
        } else {
            this.setAttributeIndex("last");
        }
        String firstValIndex = Utils.getOption('F', options);
        if (firstValIndex.length() != 0) {
            this.setFirstValueIndex(firstValIndex);
        } else {
            this.setFirstValueIndex("first");
        }
        String secondValIndex = Utils.getOption('S', options);
        if (secondValIndex.length() != 0) {
            this.setSecondValueIndex(secondValIndex);
        } else {
            this.setSecondValueIndex("last");
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        options.add("-C");
        options.add("" + this.getAttributeIndex());
        options.add("-F");
        options.add("" + this.getFirstValueIndex());
        options.add("-S");
        options.add("" + this.getSecondValueIndex());
        return options.toArray(new String[0]);
    }

    public String attributeIndexTipText() {
        return "Sets which attribute to process. This attribute must be nominal (\"first\" and \"last\" are valid values)";
    }

    public String getAttributeIndex() {
        return this.m_AttIndex.getSingleIndex();
    }

    public void setAttributeIndex(String attIndex) {
        this.m_AttIndex.setSingleIndex(attIndex);
    }

    public String firstValueIndexTipText() {
        return "The index of the first value (\"first\" and \"last\" are valid values).";
    }

    public String getFirstValueIndex() {
        return this.m_FirstIndex.getSingleIndex();
    }

    public void setFirstValueIndex(String firstIndex) {
        this.m_FirstIndex.setSingleIndex(firstIndex);
    }

    public String secondValueIndexTipText() {
        return "The index of the second value (\"first\" and \"last\" are valid values).";
    }

    public String getSecondValueIndex() {
        return this.m_SecondIndex.getSingleIndex();
    }

    public void setSecondValueIndex(String secondIndex) {
        this.m_SecondIndex.setSingleIndex(secondIndex);
    }

    private void setOutputFormat() {
        ArrayList<Attribute> newAtts = new ArrayList<Attribute>(this.getInputFormat().numAttributes());
        for (int j = 0; j < this.getInputFormat().numAttributes(); ++j) {
            Attribute att = this.getInputFormat().attribute(j);
            if (j != this.m_AttIndex.getIndex()) {
                newAtts.add((Attribute)att.copy());
                continue;
            }
            ArrayList<String> newVals = new ArrayList<String>(att.numValues());
            for (int i = 0; i < att.numValues(); ++i) {
                if (i == this.m_FirstIndex.getIndex()) {
                    newVals.add(att.value(this.m_SecondIndex.getIndex()));
                    continue;
                }
                if (i == this.m_SecondIndex.getIndex()) {
                    newVals.add(att.value(this.m_FirstIndex.getIndex()));
                    continue;
                }
                newVals.add(att.value(i));
            }
            Attribute newAtt = new Attribute(att.name(), newVals);
            newAtt.setWeight(att.weight());
            newAtts.add(newAtt);
        }
        Instances newData = new Instances(this.getInputFormat().relationName(), newAtts, 0);
        newData.setClassIndex(this.getInputFormat().classIndex());
        this.setOutputFormat(newData);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 14508 $");
    }

    public static void main(String[] argv) {
        SwapValues.runFilter(new SwapValues(), argv);
    }
}

