/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.NICGAR;

import java.io.PrintWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.NICGAR.AssociationRule;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.NICGAR.Chromosome;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.NICGAR.Gene;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.NICGAR.Specie;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.NICGAR.myDataset;
import org.core.Randomize;

public class NICGARProcess {
    private String rulesEP;
    private static myDataset dataset;
    private int nTrials;
    private double minSupport;
    private double pm;
    private double af;
    private int uPopSize;
    private int nAttr;
    private int nTrans;
    private int trials;
    private double nichMin;
    private double evMin;
    private double sumFitnessPop;
    private double sumFitnessEP;
    private double updatePop;
    private double percentUpdate;
    private double countReinc;
    private int trialsFirstRestart;
    private double[] wTrans;
    private double avgDistPop;
    private boolean coverallEP;
    private ArrayList<Chromosome> uPop;
    private ArrayList<Chromosome> child_pop;
    private ArrayList<Chromosome> EP;
    private ArrayList<Specie> speciesList;

    public NICGARProcess(myDataset dataset, int nTrials, int popSize, double pm, double af, double nichMin, double evMin, double percentUpdate) {
        NICGARProcess.dataset = dataset;
        this.nTrials = nTrials;
        this.uPopSize = popSize;
        this.pm = pm;
        this.af = af;
        this.minSupport = 0.0;
        this.nichMin = nichMin;
        this.evMin = evMin;
        this.percentUpdate = percentUpdate;
        this.trialsFirstRestart = 0;
        this.nAttr = NICGARProcess.dataset.getnVars();
        this.nTrans = NICGARProcess.dataset.getnTrans();
        this.trials = 0;
        this.rulesEP = new String("");
        this.sumFitnessEP = 0.0;
        this.wTrans = new double[this.nTrans];
        for (int i = 0; i < this.wTrans.length; ++i) {
            this.wTrans[i] = 1.0;
        }
        this.uPop = new ArrayList();
        this.child_pop = new ArrayList();
        this.EP = new ArrayList();
    }

    public static myDataset getMyDataset() {
        return dataset;
    }

    public void run() {
        int nGn = 0;
        this.trials = 0;
        this.rulesEP = new String("");
        this.countReinc = 0.0;
        this.coverallEP = false;
        this.updatePop = 0.0;
        this.initializePopulation();
        do {
            System.out.println("Computing Generation " + (nGn + 1) + "... ");
            this.updatePop = 0.0;
            this.selection();
            this.createNextPop();
            this.checkRestart();
            ++nGn;
        } while (this.trials < this.nTrials);
        this.updateEPall();
        this.avgDistPop = this.avgDistanceChrPop(this.EP);
        this.printPop();
        System.out.println("done.\n");
        System.out.println("Number of trials = " + this.trials + "\n");
    }

    public void createNextPop() {
        int i;
        ArrayList<Chromosome> allChr = new ArrayList<Chromosome>();
        for (i = 0; i < this.uPop.size(); ++i) {
            if (this.equalChromotoPop(this.uPop.get(i), allChr)) continue;
            allChr.add(this.uPop.get(i).copy());
        }
        for (i = 0; i < this.child_pop.size(); ++i) {
            if (this.equalChromotoPop(this.child_pop.get(i), allChr)) continue;
            allChr.add(this.child_pop.get(i).copy());
        }
        Collections.sort(allChr);
        this.uPop = new ArrayList();
        for (i = 0; i < allChr.size() && this.uPop.size() < this.uPopSize; ++i) {
            if (allChr.get(i).isSpecieChild()) {
                this.updatePop += 1.0;
            }
            allChr.get(i).setProceed(false);
            allChr.get(i).setSeed(false);
            allChr.get(i).setSpecieChild(false);
            allChr.get(i).setTournSelect(false);
            this.uPop.add(allChr.get(i).copy());
        }
    }

    public void updateEPCovered() {
        int i;
        for (i = 0; i < this.EP.size(); ++i) {
            this.EP.get(i).setProceed(false);
            this.EP.get(i).setSeed(false);
        }
        this.identifySpeciesNewImp(this.EP);
        ArrayList<Chromosome> nextEP = new ArrayList<Chromosome>();
        for (i = 0; i < this.speciesList.size(); ++i) {
            nextEP.add(this.speciesList.get(i).getBestChr().copy());
        }
        this.sumFitnessEP = 0.0;
        this.EP = new ArrayList();
        for (i = 0; i < nextEP.size(); ++i) {
            this.sumFitnessEP += ((Chromosome)nextEP.get(i)).getFitness();
            ((Chromosome)nextEP.get(i)).setSpecieChild(false);
            this.EP.add(((Chromosome)nextEP.get(i)).copy());
        }
        this.sumFitnessEP /= (double)this.EP.size() * 1.0;
    }

    private void checkRestart() {
        double numberPercUpdate = (double)this.uPopSize * this.percentUpdate / 100.0;
        if (this.updatePop < numberPercUpdate) {
            if (this.countReinc == 0.0) {
                this.trialsFirstRestart = this.trials * 2;
            }
            if (this.nTrials - this.trials > this.trialsFirstRestart) {
                this.updateEPall();
                this.restartPopEP();
                this.countReinc += 1.0;
            }
        }
    }

    public void updateEPall() {
        this.identifySpeciesNewImp(this.uPop);
        for (int i = 0; i < this.speciesList.size(); ++i) {
            Chromosome bestChr = this.speciesList.get(i).getBestChr().copy();
            if (this.equalChromotoPop(bestChr, this.EP)) continue;
            if (this.updatePop != -1.0) {
                bestChr.setSpecieChild(true);
            } else {
                bestChr.setSpecieChild(false);
            }
            double fitnessAchive = this.sumFitnessEP - this.sumFitnessEP * (1.0 - this.evMin);
            if (!(bestChr.getFitness() >= fitnessAchive)) continue;
            this.EP.add(bestChr);
        }
        if (this.updatePop != -1.0) {
            this.updateEPCovered();
        }
    }

    private ArrayList<Integer> tr_notCoveredPop(ArrayList<Chromosome> pop) {
        int i;
        ArrayList<Integer> tr_not_marked = new ArrayList<Integer>();
        for (i = 0; i < this.nTrans; ++i) {
            tr_not_marked.add(i);
        }
        for (i = 0; i < pop.size(); ++i) {
            this.deleteTransCovered(pop.get(i), tr_not_marked);
        }
        return tr_not_marked;
    }

    private void restartPopEP() {
        int i;
        this.sumFitnessPop = 0.0;
        this.coverallEP = false;
        ArrayList<Integer> tr_not_markedEP = this.tr_notCoveredPop(this.EP);
        ArrayList<Integer> tr_not_marked = new ArrayList<Integer>();
        if (tr_not_markedEP.size() == 0) {
            for (i = 0; i < this.nTrans; ++i) {
                tr_not_markedEP.add(i);
                tr_not_marked.add(i);
            }
        } else {
            for (i = 0; i < tr_not_markedEP.size(); ++i) {
                tr_not_marked.add(tr_not_markedEP.get(i));
            }
        }
        this.uPop = new ArrayList();
        int k = 0;
        int cont = 0;
        while (k < this.uPopSize) {
            int random_pos;
            int pos;
            Chromosome chromo;
            if (tr_not_marked.size() == 0) {
                for (i = 0; i < this.nTrans; ++i) {
                    tr_not_marked.add(i);
                }
                this.coverallEP = true;
            }
            if (!this.equalChromotoPop(chromo = this.generateChromoCoveredPosNegAmp(pos = ((Integer)tr_not_marked.get(random_pos = Randomize.Randint(0, tr_not_marked.size()))).intValue()), this.uPop) && chromo.getSupport() > this.minSupport && !(chromo.getSupport() > 1.0 - this.minSupport) && this.roundDoubleDown(chromo.getCF(), 2) > 0.0 && this.roundDoubleDown(chromo.getLift(), 2) > 1.0) {
                this.sumFitnessPop += chromo.getFitness();
                this.adjustFitnessCloseEP(chromo);
                if (!this.coverallEP) {
                    chromo.setReinicio(true);
                }
                this.uPop.add(chromo);
                this.deleteTransCovered(this.uPop.get(k), tr_not_marked);
                ++k;
                cont = 0;
                continue;
            }
            if (cont > 1000) {
                System.out.println("cont = 100");
                tr_not_marked.clear();
                cont = 0;
                continue;
            }
            ++cont;
        }
        this.sumFitnessPop /= (double)this.uPop.size();
    }

    private Chromosome generateChromoCoveredPosNegAmp(int pos_example) {
        double ub;
        double lb;
        double value;
        int i;
        double[] example = dataset.getExample(pos_example);
        Gene[] rnd_genes = new Gene[this.nAttr];
        int[] sample = new int[this.nAttr];
        for (i = 0; i < this.nAttr; ++i) {
            rnd_genes[i] = new Gene();
        }
        for (i = 0; i < this.nAttr; ++i) {
            sample[i] = i;
        }
        rnd_genes = new Gene[this.nAttr];
        for (i = 0; i < this.nAttr; ++i) {
            rnd_genes[i] = new Gene();
        }
        for (i = 0; i < this.nAttr; ++i) {
            int j = Randomize.Randint(0, this.nAttr);
            int tmp = sample[i];
            sample[i] = sample[j];
            sample[j] = tmp;
        }
        int nAnts = Randomize.Randint(1, this.nAttr);
        if (nAnts > 5) {
            nAnts = Randomize.Randint(1, 5);
        }
        for (i = 0; i < nAnts; ++i) {
            rnd_genes[sample[i]].setAttr(sample[i]);
            rnd_genes[sample[i]].setActAs(0);
            rnd_genes[sample[i]].setIsPositiveInterval(Randomize.RandintClosed(0, 1) == 1);
            value = example[sample[i]];
            if (dataset.getAttributeType(sample[i]) != 0) {
                if (dataset.getAttributeType(sample[i]) == 2) {
                    if (rnd_genes[sample[i]].getIsPositiveInterval()) {
                        lb = Math.max(value - dataset.getAmplitude(sample[i]) / (this.af * 2.0), dataset.getMin(sample[i]));
                        ub = Math.min(value + dataset.getAmplitude(sample[i]) / (this.af * 2.0), dataset.getMax(sample[i]));
                    } else if (value - dataset.getMin(sample[i]) > dataset.getMax(sample[i]) - value) {
                        lb = value - (value - dataset.getMin(sample[i]) - dataset.getAmplitude(sample[i]) / (this.af * 2.0));
                        ub = dataset.getMin(sample[i]) + (value - dataset.getMin(sample[i]) - dataset.getAmplitude(sample[i]) / (this.af * 2.0));
                    } else {
                        lb = dataset.getMax(sample[i]) - (dataset.getMax(sample[i]) - value - dataset.getAmplitude(sample[i]) / (this.af * 2.0));
                        ub = value + (dataset.getMax(sample[i]) - value - dataset.getAmplitude(sample[i]) / (this.af * 2.0));
                    }
                } else if (rnd_genes[sample[i]].getIsPositiveInterval()) {
                    lb = Math.max((double)((int)(value - dataset.getAmplitude(sample[i]) / (this.af * 2.0))), dataset.getMin(sample[i]));
                    ub = Math.min((double)((int)(value + dataset.getAmplitude(sample[i]) / (this.af * 2.0))), dataset.getMax(sample[i]));
                } else if (value - dataset.getMin(sample[i]) > dataset.getMax(sample[i]) - value) {
                    lb = (double)((int)value) - (value - dataset.getMin(sample[i]) - dataset.getAmplitude(sample[i]) / (this.af * 2.0));
                    ub = (double)((int)dataset.getMin(sample[i])) + (value - dataset.getMin(sample[i]) - dataset.getAmplitude(sample[i]) / (this.af * 2.0));
                } else {
                    lb = (double)((int)dataset.getMax(sample[i])) - (dataset.getMax(sample[i]) - value - dataset.getAmplitude(sample[i]) / (this.af * 2.0));
                    ub = (double)((int)value) + (dataset.getMax(sample[i]) - value - dataset.getAmplitude(sample[i]) / (this.af * 2.0));
                }
            } else {
                lb = ub = (double)((int)value);
            }
            rnd_genes[sample[i]].setLowerBound(lb);
            rnd_genes[sample[i]].setUpperBound(ub);
            rnd_genes[sample[i]].setType(dataset.getAttributeType(sample[i]));
            rnd_genes[sample[i]].setMin_attr(dataset.getMin(sample[i]));
            rnd_genes[sample[i]].setMax_attr(dataset.getMax(sample[i]));
        }
        rnd_genes[sample[i]].setAttr(sample[i]);
        rnd_genes[sample[i]].setActAs(1);
        value = example[sample[i]];
        if (dataset.getAttributeType(sample[i]) != 0) {
            if (dataset.getAttributeType(sample[i]) == 2) {
                lb = Math.max(value - dataset.getAmplitude(sample[i]) / (this.af * 2.0), dataset.getMin(sample[i]));
                ub = Math.min(value + dataset.getAmplitude(sample[i]) / (this.af * 2.0), dataset.getMax(sample[i]));
            } else {
                lb = Math.max((double)((int)(value - dataset.getAmplitude(sample[i]) / (this.af * 2.0))), dataset.getMin(sample[i]));
                ub = Math.min((double)((int)(value + dataset.getAmplitude(sample[i]) / (this.af * 2.0))), dataset.getMax(sample[i]));
            }
        } else {
            lb = ub = (double)((int)value);
        }
        rnd_genes[sample[i]].setLowerBound(lb);
        rnd_genes[sample[i]].setUpperBound(ub);
        rnd_genes[sample[i]].setType(dataset.getAttributeType(sample[i]));
        rnd_genes[sample[i]].setMin_attr(dataset.getMin(sample[i]));
        rnd_genes[sample[i]].setMax_attr(dataset.getMax(sample[i]));
        rnd_genes[sample[i]].setIsPositiveInterval(Randomize.RandintClosed(0, 1) == 1);
        for (i = nAnts + 1; i < this.nAttr; ++i) {
            rnd_genes[sample[i]].setAttr(sample[i]);
            rnd_genes[sample[i]].setActAs(-1);
            if (dataset.getAttributeType(sample[i]) != 0) {
                if (dataset.getAttributeType(sample[i]) == 2) {
                    value = Randomize.RanddoubleClosed(dataset.getMin(sample[i]), dataset.getMax(sample[i]));
                    lb = Math.max(value - dataset.getAmplitude(sample[i]) / (this.af * 2.0), dataset.getMin(sample[i]));
                    ub = Math.min(value + dataset.getAmplitude(sample[i]) / (this.af * 2.0), dataset.getMax(sample[i]));
                } else {
                    value = Randomize.RandintClosed((int)dataset.getMin(sample[i]), (int)dataset.getMax(sample[i]));
                    lb = (int)Math.max((double)((int)(value - dataset.getAmplitude(sample[i]) / (this.af * 2.0))), dataset.getMin(sample[i]));
                    ub = (int)Math.min((double)((int)(value + dataset.getAmplitude(sample[i]) / (this.af * 2.0))), dataset.getMax(sample[i]));
                }
            } else {
                value = Randomize.RandintClosed((int)dataset.getMin(sample[i]), (int)dataset.getMax(sample[i]));
                lb = ub = (double)((int)value);
            }
            rnd_genes[sample[i]].setLowerBound(lb);
            rnd_genes[sample[i]].setUpperBound(ub);
            rnd_genes[sample[i]].setType(dataset.getAttributeType(sample[i]));
            rnd_genes[sample[i]].setMin_attr(dataset.getMin(sample[i]));
            rnd_genes[sample[i]].setMax_attr(dataset.getMax(sample[i]));
            rnd_genes[sample[i]].setIsPositiveInterval(Randomize.RandintClosed(0, 1) == 1);
        }
        Chromosome chromo = new Chromosome(rnd_genes);
        chromo.computeObjetives(dataset, this.wTrans);
        ++this.trials;
        return chromo;
    }

    public void adjustFitnessCloseEP(Chromosome chr) {
        int posCloseChr = -1;
        double distMinChr = Double.MAX_VALUE;
        double distCommon = 1.0;
        for (int i = 0; i < this.EP.size(); ++i) {
            this.EP.get(i).distanceChromosome(chr);
            double distChr = this.EP.get(i).getDistCoverGenes();
            if (!(this.EP.get(i).getDistCommonGenes() < this.nichMin) || !(this.EP.get(i).getDistCoverGenes() < this.nichMin)) continue;
            if (distChr < distMinChr) {
                distMinChr = distChr;
                posCloseChr = i;
                distCommon = this.EP.get(i).getDistCommonGenes();
                continue;
            }
            if (distChr != distMinChr || !(this.EP.get(i).getFitness() > this.EP.get(posCloseChr).getFitness())) continue;
            posCloseChr = i;
            distCommon = this.EP.get(i).getDistCommonGenes();
        }
        if (posCloseChr != -1 && chr.getFitness() <= this.EP.get(posCloseChr).getFitness()) {
            distMinChr = (distCommon + distMinChr) / 2.0;
            chr.setFitness(chr.getFitness() - (1.0 - distMinChr) * (chr.getFitness() * 0.2));
        }
    }

    public void identifySpeciesNewImp(ArrayList<Chromosome> popSpecie) {
        int i;
        ArrayList pop = new ArrayList();
        this.identifySeeds(popSpecie);
        for (i = 0; i < pop.size(); ++i) {
            if (((Chromosome)pop.get(i)).isSeed()) continue;
            ((Chromosome)pop.get(i)).setProceed(false);
        }
        for (i = 0; i < pop.size(); ++i) {
            if (((Chromosome)pop.get(i)).isSeed()) continue;
            double distMinChrNiche = Double.MAX_VALUE;
            int posCloseNiche = -1;
            for (int j = 0; j < this.speciesList.size(); ++j) {
                Chromosome seed = this.speciesList.get(j).getSeedSpecie();
                seed.distanceChromosome((Chromosome)pop.get(i));
                double distChrNiche = seed.getDistCoverGenes();
                if (!(seed.getDistCommonGenes() < this.nichMin) || !(seed.getDistCoverGenes() < this.nichMin)) continue;
                if (distChrNiche < distMinChrNiche) {
                    distMinChrNiche = distChrNiche;
                    posCloseNiche = j;
                    continue;
                }
                if (distChrNiche != distMinChrNiche || !(this.speciesList.get(j).getSeedSpecie().getFitness() > this.speciesList.get(posCloseNiche).getSeedSpecie().getFitness())) continue;
                posCloseNiche = j;
            }
            if (posCloseNiche == -1) continue;
            ((Chromosome)pop.get(i)).setProceed(true);
            this.speciesList.get(posCloseNiche).getChrList().add(((Chromosome)pop.get(i)).copy());
            this.speciesList.get(posCloseNiche).incrementCountParents();
        }
        for (i = 0; i < this.speciesList.size(); ++i) {
            this.speciesList.get(i).findBestChr();
        }
    }

    public void identifySeeds(ArrayList<Chromosome> pop) {
        this.speciesList = new ArrayList();
        Collections.sort(pop);
        for (int i = 0; i < pop.size(); ++i) {
            if (pop.get((int)i).proceed) continue;
            pop.get(i).setProceed(true);
            boolean found = false;
            for (int j = 0; j < this.speciesList.size(); ++j) {
                Chromosome seed = this.speciesList.get(j).getSeedSpecie();
                pop.get(i).distanceChromosome(seed);
                if (!(pop.get(i).getDistCommonGenes() < this.nichMin) || !(pop.get(i).getDistCoverGenes() < this.nichMin)) continue;
                found = true;
            }
            if (found) continue;
            Specie specie = new Specie();
            pop.get(i).setSeed(true);
            pop.get(i).setProceed(true);
            specie.getChrList().add(pop.get(i).copy());
            specie.incrementCountParents();
            this.speciesList.add(specie);
        }
    }

    public double avgDistanceChrPop(ArrayList<Chromosome> pop) {
        double avgDistPop = 0.0;
        for (int i = 0; i < pop.size(); ++i) {
            double avgdistChrPop = 0.0;
            for (int j = 0; j < pop.size(); ++j) {
                if (i == j) continue;
                double dist = pop.get(i).distanceChromosome(pop.get(j));
                avgdistChrPop += dist;
            }
            pop.get(i).setDistChrToPop(avgdistChrPop /= (double)pop.size() - 1.0);
            avgDistPop += avgdistChrPop;
        }
        return avgDistPop /= (double)pop.size();
    }

    private void initializePopulation() {
        int i;
        this.uPop.clear();
        ArrayList<Integer> tr_not_marked = new ArrayList<Integer>();
        Gene[] rnd_genes = new Gene[this.nAttr];
        int[] sample = new int[this.nAttr];
        this.trials = 0;
        boolean cont = false;
        for (i = 0; i < this.nAttr; ++i) {
            rnd_genes[i] = new Gene();
        }
        for (i = 0; i < this.nAttr; ++i) {
            sample[i] = i;
        }
        for (i = 0; i < this.nTrans; ++i) {
            tr_not_marked.add(i);
        }
        while (this.uPop.size() < this.uPopSize) {
            double ub;
            double lb;
            double value;
            if (tr_not_marked.size() == 0) {
                for (i = 0; i < this.nTrans; ++i) {
                    tr_not_marked.add(i);
                }
            }
            int pos = (Integer)tr_not_marked.get(Randomize.Randint(0, tr_not_marked.size()));
            double[] example = dataset.getExample(pos);
            for (i = 0; i < this.nAttr; ++i) {
                int j = Randomize.Randint(0, this.nAttr);
                int tmp = sample[i];
                sample[i] = sample[j];
                sample[j] = tmp;
            }
            int nAnts = Randomize.Randint(1, this.nAttr);
            if (nAnts > 5) {
                nAnts = Randomize.Randint(1, 5);
            }
            for (i = 0; i < nAnts; ++i) {
                rnd_genes[sample[i]].setAttr(sample[i]);
                rnd_genes[sample[i]].setActAs(0);
                rnd_genes[sample[i]].setIsPositiveInterval(Randomize.RandintClosed(0, 1) == 1);
                value = example[sample[i]];
                if (dataset.getAttributeType(sample[i]) != 0) {
                    if (dataset.getAttributeType(sample[i]) == 2) {
                        if (rnd_genes[sample[i]].getIsPositiveInterval()) {
                            lb = Math.max(value - dataset.getAmplitude(sample[i]) / (this.af * 2.0), dataset.getMin(sample[i]));
                            ub = Math.min(value + dataset.getAmplitude(sample[i]) / (this.af * 2.0), dataset.getMax(sample[i]));
                        } else if (value - dataset.getMin(sample[i]) > dataset.getMax(sample[i]) - value) {
                            lb = value - (value - dataset.getMin(sample[i]) - dataset.getAmplitude(sample[i]) / (this.af * 2.0));
                            ub = dataset.getMin(sample[i]) + (value - dataset.getMin(sample[i]) - dataset.getAmplitude(sample[i]) / (this.af * 2.0));
                        } else {
                            lb = dataset.getMax(sample[i]) - (dataset.getMax(sample[i]) - value - dataset.getAmplitude(sample[i]) / (this.af * 2.0));
                            ub = value + (dataset.getMax(sample[i]) - value - dataset.getAmplitude(sample[i]) / (this.af * 2.0));
                        }
                    } else if (rnd_genes[sample[i]].getIsPositiveInterval()) {
                        lb = Math.max((double)((int)(value - dataset.getAmplitude(sample[i]) / (this.af * 2.0))), dataset.getMin(sample[i]));
                        ub = Math.min((double)((int)(value + dataset.getAmplitude(sample[i]) / (this.af * 2.0))), dataset.getMax(sample[i]));
                    } else if (value - dataset.getMin(sample[i]) > dataset.getMax(sample[i]) - value) {
                        lb = (double)((int)value) - (value - dataset.getMin(sample[i]) - dataset.getAmplitude(sample[i]) / (this.af * 2.0));
                        ub = (double)((int)dataset.getMin(sample[i])) + (value - dataset.getMin(sample[i]) - dataset.getAmplitude(sample[i]) / (this.af * 2.0));
                    } else {
                        lb = (double)((int)dataset.getMax(sample[i])) - (dataset.getMax(sample[i]) - value - dataset.getAmplitude(sample[i]) / (this.af * 2.0));
                        ub = (double)((int)value) + (dataset.getMax(sample[i]) - value - dataset.getAmplitude(sample[i]) / (this.af * 2.0));
                    }
                } else {
                    lb = ub = (double)((int)value);
                }
                rnd_genes[sample[i]].setLowerBound(lb);
                rnd_genes[sample[i]].setUpperBound(ub);
                rnd_genes[sample[i]].setType(dataset.getAttributeType(sample[i]));
                rnd_genes[sample[i]].setMin_attr(dataset.getMin(sample[i]));
                rnd_genes[sample[i]].setMax_attr(dataset.getMax(sample[i]));
            }
            rnd_genes[sample[i]].setAttr(sample[i]);
            rnd_genes[sample[i]].setActAs(1);
            value = example[sample[i]];
            if (dataset.getAttributeType(sample[i]) != 0) {
                if (dataset.getAttributeType(sample[i]) == 2) {
                    lb = Math.max(value - dataset.getAmplitude(sample[i]) / (this.af * 2.0), dataset.getMin(sample[i]));
                    ub = Math.min(value + dataset.getAmplitude(sample[i]) / (this.af * 2.0), dataset.getMax(sample[i]));
                } else {
                    lb = Math.max((double)((int)(value - dataset.getAmplitude(sample[i]) / (this.af * 2.0))), dataset.getMin(sample[i]));
                    ub = Math.min((double)((int)(value + dataset.getAmplitude(sample[i]) / (this.af * 2.0))), dataset.getMax(sample[i]));
                }
            } else {
                lb = ub = (double)((int)value);
            }
            rnd_genes[sample[i]].setLowerBound(lb);
            rnd_genes[sample[i]].setUpperBound(ub);
            rnd_genes[sample[i]].setType(dataset.getAttributeType(sample[i]));
            rnd_genes[sample[i]].setMin_attr(dataset.getMin(sample[i]));
            rnd_genes[sample[i]].setMax_attr(dataset.getMax(sample[i]));
            rnd_genes[sample[i]].setIsPositiveInterval(Randomize.RandintClosed(0, 1) == 1);
            for (i = nAnts + 1; i < this.nAttr; ++i) {
                rnd_genes[sample[i]].setAttr(sample[i]);
                rnd_genes[sample[i]].setActAs(-1);
                if (dataset.getAttributeType(sample[i]) != 0) {
                    if (dataset.getAttributeType(sample[i]) == 2) {
                        value = Randomize.RanddoubleClosed(dataset.getMin(sample[i]), dataset.getMax(sample[i]));
                        lb = Math.max(value - dataset.getAmplitude(sample[i]) / (this.af * 2.0), dataset.getMin(sample[i]));
                        ub = Math.min(value + dataset.getAmplitude(sample[i]) / (this.af * 2.0), dataset.getMax(sample[i]));
                    } else {
                        value = Randomize.RandintClosed((int)dataset.getMin(sample[i]), (int)dataset.getMax(sample[i]));
                        lb = (int)Math.max((double)((int)(value - dataset.getAmplitude(sample[i]) / (this.af * 2.0))), dataset.getMin(sample[i]));
                        ub = (int)Math.min((double)((int)(value + dataset.getAmplitude(sample[i]) / (this.af * 2.0))), dataset.getMax(sample[i]));
                    }
                } else {
                    value = Randomize.RandintClosed((int)dataset.getMin(sample[i]), (int)dataset.getMax(sample[i]));
                    lb = ub = (double)((int)value);
                }
                rnd_genes[sample[i]].setLowerBound(lb);
                rnd_genes[sample[i]].setUpperBound(ub);
                rnd_genes[sample[i]].setType(dataset.getAttributeType(sample[i]));
                rnd_genes[sample[i]].setMin_attr(dataset.getMin(sample[i]));
                rnd_genes[sample[i]].setMax_attr(dataset.getMax(sample[i]));
                rnd_genes[sample[i]].setIsPositiveInterval(Randomize.RandintClosed(0, 1) == 1);
            }
            Chromosome chromo = new Chromosome(rnd_genes);
            chromo.computeObjetives(dataset, this.wTrans);
            ++this.trials;
            if (this.equalChromotoPop(chromo, this.uPop) || !(chromo.getSupport() > this.minSupport) || chromo.getSupport() > 1.0 - this.minSupport || !(this.roundDoubleDown(chromo.getCF(), 2) > 0.0) || !(this.roundDoubleDown(chromo.getLift(), 2) > 1.0)) continue;
            this.uPop.add(chromo);
            this.deleteTransCovered(chromo, tr_not_marked);
            this.sumFitnessPop += chromo.getFitness();
        }
        this.sumFitnessPop /= (double)this.uPop.size();
    }

    private void deleteTransCovered(Chromosome chromo, ArrayList<Integer> tr_not_marked) {
        for (int i = tr_not_marked.size() - 1; i >= 0; --i) {
            double[] example = dataset.getExample(tr_not_marked.get(i));
            if (!chromo.isCovered(example)) continue;
            tr_not_marked.remove(i);
        }
    }

    private boolean equalChromotoPop(Chromosome chromo, ArrayList<Chromosome> pop) {
        boolean value = false;
        for (int i = 0; !value && i < pop.size(); ++i) {
            Chromosome aux = pop.get(i);
            if (!chromo.equals(aux)) continue;
            value = true;
        }
        return value;
    }

    private int getPosChrPop(Chromosome chromo, ArrayList<Chromosome> pop) {
        boolean value = false;
        int posChr = -1;
        for (int i = 0; !value && i < pop.size(); ++i) {
            Chromosome aux = pop.get(i);
            if (!chromo.equals(aux)) continue;
            posChr = i;
        }
        return posChr;
    }

    private void selection() {
        this.child_pop = new ArrayList();
        while (this.child_pop.size() < this.uPopSize) {
            int dad = this.tournamentSelection();
            int mom = this.tournamentSelection();
            while (dad == mom) {
                mom = this.tournamentSelection();
            }
            this.crossover(this.uPop.get(dad), this.uPop.get(mom));
        }
    }

    private void crossover(Chromosome dad, Chromosome mom) {
        int i;
        Gene[] genesSon1 = new Gene[this.nAttr];
        Gene[] genesSon2 = new Gene[this.nAttr];
        for (i = 0; i < this.nAttr; ++i) {
            if (dad.getGene(i).getActAs() != 1 && mom.getGene(i).getActAs() != 1) continue;
            genesSon1[i] = dad.getGene(i).copy();
            genesSon2[i] = mom.getGene(i).copy();
            if (dataset.getAttributeType(i) == 0) continue;
            this.crossInterval05(genesSon1[i], genesSon2[i]);
        }
        for (i = 0; i < this.nAttr; ++i) {
            if (dad.getGene(i).getActAs() == 1 || mom.getGene(i).getActAs() == 1) continue;
            if (Randomize.Rand() < 0.5) {
                genesSon1[i] = dad.getGene(i).copy();
                genesSon2[i] = mom.getGene(i).copy();
                if (dataset.getAttributeType(i) == 0) continue;
                this.crossInterval05(genesSon1[i], genesSon2[i]);
                continue;
            }
            genesSon1[i] = mom.getGene(i).copy();
            genesSon2[i] = dad.getGene(i).copy();
            if (dataset.getAttributeType(i) == 0) continue;
            this.crossInterval05(genesSon1[i], genesSon2[i]);
        }
        Chromosome son1 = new Chromosome(genesSon1);
        Chromosome son2 = new Chromosome(genesSon2);
        if (Randomize.Rand() < this.pm) {
            this.mutate(son1);
        }
        if (Randomize.Rand() < this.pm) {
            this.mutate(son2);
        }
        son1.forceConsistency();
        son2.forceConsistency();
        son1.computeObjetives(dataset, this.wTrans);
        son2.computeObjetives(dataset, this.wTrans);
        this.trials += 2;
        if (!this.equalChromotoPop(son1, this.child_pop) && son1.getSupport() > this.minSupport && !(son1.getSupport() > 1.0 - this.minSupport) && this.roundDoubleDown(son1.getCF(), 2) > 0.0 && this.roundDoubleDown(son1.getLift(), 2) > 1.0) {
            son1.setSpecieChild(true);
            this.adjustFitnessCloseEP(son1);
            this.child_pop.add(son1);
        }
        if (!this.equalChromotoPop(son2, this.child_pop) && son2.getSupport() > this.minSupport && !(son2.getSupport() > 1.0 - this.minSupport) && this.roundDoubleDown(son2.getCF(), 2) > 0.0 && this.roundDoubleDown(son2.getLift(), 2) > 1.0) {
            son2.setSpecieChild(true);
            this.adjustFitnessCloseEP(son2);
            this.child_pop.add(son2);
        }
    }

    private double roundDoubleDown(double number, int decimalPlace) {
        if (!Double.isInfinite(number) && !Double.isNaN(number)) {
            BigDecimal bd = new BigDecimal(number);
            bd = bd.setScale(decimalPlace, 1);
            double numberRound = bd.doubleValue();
            return numberRound;
        }
        return number;
    }

    private void crossInterval05(Gene fromDad, Gene fromMom) {
        double ubGen2;
        double ubGen1;
        double lbGen2;
        double lbGen1;
        double ampLb = Math.abs(fromDad.getLowerBound() - fromMom.getLowerBound());
        double ampUb = Math.abs(fromDad.getUpperBound() - fromMom.getUpperBound());
        if (dataset.getAttributeType(fromDad.getAttr()) == 2) {
            double minLb1 = Math.max(dataset.getMin(fromDad.getAttr()), fromDad.getLowerBound() - ampLb * 0.5);
            double maxLb1 = Math.min(dataset.getMax(fromDad.getAttr()), fromDad.getLowerBound() + ampLb * 0.5);
            lbGen1 = Randomize.Randdouble(minLb1, maxLb1);
            double minLb2 = Math.max(dataset.getMin(fromMom.getAttr()), fromMom.getLowerBound() - ampLb * 0.5);
            double maxLb2 = Math.min(dataset.getMax(fromMom.getAttr()), fromMom.getLowerBound() + ampLb * 0.5);
            lbGen2 = Randomize.Randdouble(minLb2, maxLb2);
            double minUb1 = Math.max(dataset.getMin(fromDad.getAttr()), fromDad.getUpperBound() - ampUb * 0.5);
            double maxUb1 = Math.min(dataset.getMax(fromDad.getAttr()), fromDad.getUpperBound() + ampUb * 0.5);
            ubGen1 = Randomize.Randdouble(minUb1, maxUb1);
            double minUb2 = Math.max(dataset.getMin(fromMom.getAttr()), fromMom.getUpperBound() - ampUb * 0.5);
            double maxUb2 = Math.min(dataset.getMax(fromMom.getAttr()), fromMom.getUpperBound() + ampUb * 0.5);
            ubGen2 = Randomize.Randdouble(minUb2, maxUb2);
        } else {
            double minLb1 = Math.max(dataset.getMin(fromDad.getAttr()), fromDad.getLowerBound() - ampLb * 0.5);
            double maxLb1 = Math.min(dataset.getMax(fromDad.getAttr()), fromDad.getLowerBound() + ampLb * 0.5);
            lbGen1 = Randomize.Randint((int)minLb1, (int)maxLb1);
            double minLb2 = Math.max(dataset.getMin(fromMom.getAttr()), fromMom.getLowerBound() - ampLb * 0.5);
            double maxLb2 = Math.min(dataset.getMax(fromMom.getAttr()), fromMom.getLowerBound() + ampLb * 0.5);
            lbGen2 = Randomize.Randint((int)minLb2, (int)maxLb2);
            double minUb1 = Math.max(dataset.getMin(fromDad.getAttr()), fromDad.getUpperBound() - ampUb * 0.5);
            double maxUb1 = Math.min(dataset.getMax(fromDad.getAttr()), fromDad.getUpperBound() + ampUb * 0.5);
            ubGen1 = Randomize.Randint((int)minUb1, (int)maxUb1);
            double minUb2 = Math.max(dataset.getMin(fromMom.getAttr()), fromMom.getUpperBound() - ampUb * 0.5);
            double maxUb2 = Math.min(dataset.getMax(fromMom.getAttr()), fromMom.getUpperBound() + ampUb * 0.5);
            ubGen2 = Randomize.Randint((int)minUb2, (int)maxUb2);
        }
        if (lbGen1 < ubGen1) {
            fromDad.setLowerBound(lbGen1);
            fromDad.setUpperBound(ubGen1);
        } else {
            fromDad.setLowerBound(ubGen1);
            fromDad.setUpperBound(lbGen1);
        }
        if (lbGen2 < ubGen2) {
            fromMom.setLowerBound(lbGen2);
            fromMom.setUpperBound(ubGen2);
        } else {
            fromMom.setLowerBound(ubGen2);
            fromMom.setUpperBound(lbGen2);
        }
    }

    private void mutate(Chromosome chr) {
        int i = Randomize.Randint(0, this.nAttr);
        Gene gene = chr.getGene(i);
        double type_attr = dataset.getAttributeType(i);
        double min_attr = dataset.getMin(i);
        double max_attr = dataset.getMax(i);
        if (type_attr != 0.0) {
            if (type_attr == 2.0) {
                if (Randomize.Rand() < 0.5) {
                    if (Randomize.Rand() < 0.5) {
                        double top = Math.max(gene.getUpperBound() - dataset.getAmplitude(i) / this.af, min_attr);
                        gene.setLowerBound(Randomize.RanddoubleClosed(top, gene.getLowerBound()));
                    } else {
                        gene.setLowerBound(Randomize.Randdouble(gene.getLowerBound(), gene.getUpperBound()));
                    }
                } else if (Randomize.Rand() < 0.5) {
                    double top = Math.min(gene.getLowerBound() + dataset.getAmplitude(i) / this.af, max_attr);
                    gene.setUpperBound(Randomize.RanddoubleClosed(gene.getUpperBound(), top));
                } else {
                    gene.setUpperBound(Randomize.RanddoubleClosed(gene.getLowerBound() + 1.0E-4, gene.getUpperBound()));
                }
            } else if (Randomize.Rand() < 0.5) {
                if (Randomize.Rand() < 0.5) {
                    double top = Math.max(gene.getUpperBound() - dataset.getAmplitude(i) / this.af, min_attr);
                    gene.setLowerBound(Randomize.RandintClosed((int)top, (int)gene.getLowerBound()));
                } else {
                    gene.setLowerBound(Randomize.Randint((int)gene.getLowerBound(), (int)gene.getUpperBound()));
                }
            } else if (Randomize.Rand() < 0.5) {
                double top = Math.min(gene.getLowerBound() + dataset.getAmplitude(i) / this.af, max_attr);
                gene.setUpperBound(Randomize.RandintClosed((int)gene.getUpperBound(), (int)top));
            } else {
                gene.setUpperBound(Randomize.RandintClosed((int)gene.getLowerBound() + 1, (int)gene.getUpperBound()));
            }
        } else {
            double top = Randomize.RandintClosed((int)min_attr, (int)max_attr);
            gene.setLowerBound(top);
            gene.setUpperBound(top);
        }
        gene.setIsPositiveInterval(Randomize.RandintClosed(0, 1) == 1);
        gene.setActAs(gene.randAct());
    }

    private int tournamentSelection() {
        int chromo1 = Randomize.Randint(0, this.uPop.size());
        while (this.uPop.get(chromo1).getFitness() == 0.0) {
            chromo1 = Randomize.Randint(0, this.uPop.size());
        }
        int chromo2 = Randomize.Randint(0, this.uPop.size());
        while (chromo1 == chromo2 || this.uPop.get(chromo2).getFitness() == 0.0) {
            chromo2 = Randomize.Randint(0, this.uPop.size());
        }
        if (this.uPop.get(chromo1).isBetter(this.uPop.get(chromo2)) >= 0) {
            return chromo1;
        }
        return chromo2;
    }

    private double roundDouble(double number, int decimalPlace) {
        if (!Double.isInfinite(number) && !Double.isNaN(number)) {
            BigDecimal bd = new BigDecimal(number);
            bd = bd.setScale(decimalPlace, 0);
            double numberRound = bd.doubleValue();
            return numberRound;
        }
        return number;
    }

    public double percentTransCovered(ArrayList<AssociationRule> rules) {
        int i;
        int[] covered = new int[this.nTrans];
        for (i = 0; i < this.nTrans; ++i) {
            covered[i] = 0;
        }
        for (int r = 0; r < rules.size(); ++r) {
            AssociationRule rule = rules.get(r);
            for (int j = 0; j < this.nTrans; ++j) {
                if (covered[j] >= 1) continue;
                if (!rule.isCovered(dataset.getExample(j))) continue;
                covered[j] = 1;
            }
        }
        int cnt_cov_rec = 0;
        for (i = 0; i < this.nTrans; ++i) {
            cnt_cov_rec += covered[i];
        }
        double percentCov = 100.0 * (double)cnt_cov_rec / (double)this.nTrans;
        return percentCov;
    }

    public void saveReport(ArrayList<AssociationRule> rules, PrintWriter w) {
        int i;
        double avg_yulesQ = 0.0;
        double avg_sup = 0.0;
        double avg_conf = 0.0;
        double avg_percentInterv = 0.0;
        double avg_ant_length = 0.0;
        double avg_lift = 0.0;
        double avg_conv = 0.0;
        double avg_CF = 0.0;
        double avg_netConf = 0.0;
        int[] covered = new int[this.nTrans];
        for (i = 0; i < this.nTrans; ++i) {
            covered[i] = 0;
        }
        for (int r = 0; r < rules.size(); ++r) {
            AssociationRule rule = rules.get(r);
            avg_sup += rule.getSupport();
            avg_conf += rule.getConfidence();
            avg_lift += rule.getLift();
            avg_ant_length += (double)(rule.getnAnts() + 1);
            avg_percentInterv += rule.getPercentInterval();
            avg_conv += rule.getConv();
            avg_CF += rule.getCF();
            avg_netConf += rule.getNetConf();
            avg_yulesQ += rule.getYulesQ();
            for (int j = 0; j < this.nTrans; ++j) {
                if (covered[j] >= 1) continue;
                if (!rule.isCovered(dataset.getExample(j))) continue;
                covered[j] = 1;
            }
        }
        int cnt_cov_rec = 0;
        for (i = 0; i < this.nTrans; ++i) {
            cnt_cov_rec += covered[i];
        }
        w.println("\nNumber of Frequent Itemsets found: 0");
        System.out.println("\nNumber of Frequent Itemsets found: 0");
        w.println("\nNumber of Association Rules generated: " + rules.size());
        System.out.println("Number of Association Rules generated: " + rules.size());
        if (!rules.isEmpty()) {
            w.println("Average Support: " + this.roundDouble(avg_sup / (double)rules.size(), 2));
            System.out.println("Average Support: " + this.roundDouble(avg_sup / (double)rules.size(), 2));
            w.println("Average Confidence: " + this.roundDouble(avg_conf / (double)rules.size(), 2));
            System.out.println("Average Confidence: " + this.roundDouble(avg_conf / (double)rules.size(), 2));
            w.println("Average Lift: " + this.roundDouble(avg_lift / (double)rules.size(), 2));
            System.out.println("Average Lift: " + this.roundDouble(avg_lift / (double)rules.size(), 2));
            w.println("Average Conviction: " + this.roundDouble(avg_conv / (double)rules.size(), 2));
            System.out.println("Average Conviction: " + this.roundDouble(avg_conv / (double)rules.size(), 2));
            w.println("Average Certain Factor: " + this.roundDouble(avg_CF / (double)rules.size(), 2));
            System.out.println("Average Certain Factor: " + this.roundDouble(avg_CF / (double)rules.size(), 2));
            w.println("Average Netconf: " + this.roundDouble(avg_netConf / (double)rules.size(), 2));
            System.out.println("Average Netconf: " + this.roundDouble(avg_netConf / (double)rules.size(), 2));
            w.println("Average yulesQ: " + this.roundDouble(avg_yulesQ / (double)rules.size(), 2));
            System.out.println("Average yulesQ: " + this.roundDouble(avg_yulesQ / (double)rules.size(), 2));
            w.println("Average Number of Antecedents: " + this.roundDouble(avg_ant_length / (double)rules.size(), 2));
            System.out.println("Average Number of Antecedents: " + this.roundDouble(avg_ant_length / (double)rules.size(), 2));
            w.println("Average Distance Pop: " + this.roundDouble(this.avgDistPop, 2));
            System.out.println("Average Distance Pop: " + this.roundDouble(this.avgDistPop, 2));
            w.println("Number of Covered Records (%): " + this.roundDouble(100.0 * (double)cnt_cov_rec / (double)this.nTrans, 2));
            System.out.println("Number of Covered Records (%): " + this.roundDouble(100.0 * (double)cnt_cov_rec / (double)this.nTrans, 2));
        }
    }

    public void printPop() {
        boolean stop = false;
        this.rulesEP = this.rulesEP + "Support\tantecedent_support\tconsequent_support\tConfidence\tLift\tConv\tCF\tNetConf\tYulesQ\tnAttributes\tnDistChrPop\n";
        for (int i = 0; i < this.EP.size() && !stop; ++i) {
            Chromosome chromo = this.EP.get(i);
            this.rulesEP = this.rulesEP + "" + this.roundDouble(chromo.getSupport(), 2) + "\t" + this.roundDouble(chromo.getAntsSupport(), 2) + "\t" + this.roundDouble(chromo.getConsSupport(), 2) + "\t" + this.roundDouble(chromo.getConfidence(), 2) + "\t" + this.roundDouble(chromo.getLift(), 2) + "\t" + this.roundDouble(chromo.getConv(), 2) + "\t" + this.roundDouble(chromo.getCF(), 2) + "\t" + this.roundDouble(chromo.getNetConf(), 2) + "\t" + this.roundDouble(chromo.getYulesQ(), 2) + "\t" + (chromo.getnAnts() + 1) + "\t" + this.roundDouble(chromo.getDistChrToPop(), 2) + "\n";
        }
    }

    public ArrayList<AssociationRule> generateRulesEP() {
        ArrayList<AssociationRule> rulesEP = new ArrayList<AssociationRule>();
        boolean stop = false;
        for (int i = 0; i < this.EP.size() && !stop; ++i) {
            Chromosome chromo = this.EP.get(i);
            rulesEP.add(new AssociationRule(chromo));
        }
        return rulesEP;
    }

    public String getrulesEP() {
        return this.rulesEP;
    }
}

