/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Preprocess.Basic;

import java.util.StringTokenizer;
import keel.Algorithms.Preprocess.Basic.CheckException;
import keel.Dataset.Attribute;
import keel.Dataset.Attributes;
import keel.Dataset.Instance;
import keel.Dataset.InstanceSet;

public class Metodo {
    protected String ficheroTraining;
    protected String ficheroValidation;
    protected String ficheroTest;
    protected String[] ficheroSalida;
    protected InstanceSet training;
    protected InstanceSet test;
    protected Attribute[] entradas;
    protected Attribute salida;
    protected int nEntradas;
    protected String relation;
    protected double[][] datosTrain;
    protected int[] clasesTrain;
    protected double[][] datosTest;
    protected double[][] realTest;
    protected int[] clasesTest;
    protected boolean[][] nulosTrain;
    protected int[][] nominalTrain;
    protected double[][] realTrain;
    protected boolean distanceEu;
    protected static double[][][] nominalDistance;
    protected static double[] stdDev;

    public Metodo() {
    }

    public Metodo(String ficheroScript) {
        this.distanceEu = false;
        this.leerConfiguracion(ficheroScript);
        try {
            this.training = new InstanceSet();
            this.training.readSet(this.ficheroTraining, true);
        }
        catch (Exception e) {
            System.err.println(e);
            System.exit(1);
        }
        try {
            this.test = new InstanceSet();
            this.test.readSet(this.ficheroTest, false);
        }
        catch (Exception e) {
            System.err.println(e);
            System.exit(1);
        }
        try {
            this.normalizar();
        }
        catch (Exception e) {
            System.err.println(e);
            System.exit(1);
        }
        if (!this.distanceEu) {
            stdDev = new double[Attributes.getInputNumAttributes()];
            nominalDistance = new double[Attributes.getInputNumAttributes()][][];
            int nClases = Attributes.getOutputAttribute(0).getNumNominalValues();
            for (int i = 0; i < nominalDistance.length; ++i) {
                int j;
                if (Attributes.getInputAttribute(i).getType() == 0) {
                    Metodo.nominalDistance[i] = new double[Attributes.getInputAttribute(i).getNumNominalValues()][Attributes.getInputAttribute(i).getNumNominalValues()];
                    for (j = 0; j < Attributes.getInputAttribute(i).getNumNominalValues(); ++j) {
                        Metodo.nominalDistance[i][j][j] = 0.0;
                    }
                    for (j = 0; j < Attributes.getInputAttribute(i).getNumNominalValues(); ++j) {
                        for (int l = j + 1; l < Attributes.getInputAttribute(i).getNumNominalValues(); ++l) {
                            int m;
                            double VDM = 0.0;
                            int Nay = 0;
                            int Nax = 0;
                            for (m = 0; m < this.training.getNumInstances(); ++m) {
                                if (this.nominalTrain[m][i] == j) {
                                    ++Nax;
                                }
                                if (this.nominalTrain[m][i] != l) continue;
                                ++Nay;
                            }
                            for (m = 0; m < nClases; ++m) {
                                int Nayc = 0;
                                int Naxc = 0;
                                for (int n = 0; n < this.training.getNumInstances(); ++n) {
                                    if (this.nominalTrain[n][i] == j && this.clasesTrain[n] == m) {
                                        ++Naxc;
                                    }
                                    if (this.nominalTrain[n][i] != l || this.clasesTrain[n] != m) continue;
                                    ++Nayc;
                                }
                                VDM += ((double)Naxc / (double)Nax - (double)Nayc / (double)Nay) * ((double)Naxc / (double)Nax - (double)Nayc / (double)Nay);
                            }
                            Metodo.nominalDistance[i][j][l] = Math.sqrt(VDM);
                            Metodo.nominalDistance[i][l][j] = Math.sqrt(VDM);
                        }
                    }
                    continue;
                }
                double media = 0.0;
                double SD = 0.0;
                for (j = 0; j < this.training.getNumInstances(); ++j) {
                    media += this.realTrain[j][i];
                    SD += this.realTrain[j][i] * this.realTrain[j][i];
                }
                Metodo.stdDev[i] = Math.sqrt(SD / (double)this.realTrain.length - (media /= (double)this.realTrain.length) * media);
            }
        }
    }

    public Metodo(String ficheroScript, InstanceSet train) {
        this.distanceEu = false;
        this.leerConfiguracion(ficheroScript);
        try {
            this.training = new InstanceSet(train);
        }
        catch (Exception e) {
            System.err.println(e);
            System.exit(1);
        }
        try {
            this.test = new InstanceSet(train);
        }
        catch (Exception e) {
            System.err.println(e);
            System.exit(1);
        }
        try {
            this.normalizar();
        }
        catch (Exception e) {
            System.err.println(e);
            System.exit(1);
        }
        if (!this.distanceEu) {
            stdDev = new double[Attributes.getInputNumAttributes()];
            nominalDistance = new double[Attributes.getInputNumAttributes()][][];
            int nClases = Attributes.getOutputAttribute(0).getNumNominalValues();
            for (int i = 0; i < nominalDistance.length; ++i) {
                int j;
                if (Attributes.getInputAttribute(i).getType() == 0) {
                    Metodo.nominalDistance[i] = new double[Attributes.getInputAttribute(i).getNumNominalValues()][Attributes.getInputAttribute(i).getNumNominalValues()];
                    for (j = 0; j < Attributes.getInputAttribute(i).getNumNominalValues(); ++j) {
                        Metodo.nominalDistance[i][j][j] = 0.0;
                    }
                    for (j = 0; j < Attributes.getInputAttribute(i).getNumNominalValues(); ++j) {
                        for (int l = j + 1; l < Attributes.getInputAttribute(i).getNumNominalValues(); ++l) {
                            int m;
                            double VDM = 0.0;
                            int Nay = 0;
                            int Nax = 0;
                            for (m = 0; m < this.training.getNumInstances(); ++m) {
                                if (this.nominalTrain[m][i] == j) {
                                    ++Nax;
                                }
                                if (this.nominalTrain[m][i] != l) continue;
                                ++Nay;
                            }
                            for (m = 0; m < nClases; ++m) {
                                int Nayc = 0;
                                int Naxc = 0;
                                for (int n = 0; n < this.training.getNumInstances(); ++n) {
                                    if (this.nominalTrain[n][i] == j && this.clasesTrain[n] == m) {
                                        ++Naxc;
                                    }
                                    if (this.nominalTrain[n][i] != l || this.clasesTrain[n] != m) continue;
                                    ++Nayc;
                                }
                                VDM += ((double)Naxc / (double)Nax - (double)Nayc / (double)Nay) * ((double)Naxc / (double)Nax - (double)Nayc / (double)Nay);
                            }
                            Metodo.nominalDistance[i][j][l] = Math.sqrt(VDM);
                            Metodo.nominalDistance[i][l][j] = Math.sqrt(VDM);
                        }
                    }
                    continue;
                }
                double media = 0.0;
                double SD = 0.0;
                for (j = 0; j < this.training.getNumInstances(); ++j) {
                    media += this.realTrain[j][i];
                    SD += this.realTrain[j][i] * this.realTrain[j][i];
                }
                Metodo.stdDev[i] = Math.sqrt(SD / (double)this.realTrain.length - (media /= (double)this.realTrain.length) * media);
            }
        }
    }

    protected void normalizar() throws CheckException {
        int k;
        int j;
        boolean[] nulls;
        Instance temp;
        int i;
        if (Attributes.getOutputNumAttributes() < 1) {
            throw new CheckException("This dataset haven?t outputs, so it not corresponding to a classification problem.");
        }
        if (Attributes.getOutputNumAttributes() > 1) {
            throw new CheckException("This dataset have more of one output.");
        }
        if (Attributes.getOutputAttribute(0).getType() == 2) {
            throw new CheckException("This dataset have an input attribute with floating values, so it not corresponding to a classification problem.");
        }
        this.entradas = Attributes.getInputAttributes();
        this.salida = Attributes.getOutputAttribute(0);
        this.nEntradas = Attributes.getInputNumAttributes();
        StringTokenizer tokens = new StringTokenizer(this.training.getHeader(), " \n\r");
        tokens.nextToken();
        this.relation = tokens.nextToken();
        this.datosTrain = new double[this.training.getNumInstances()][Attributes.getInputNumAttributes()];
        this.clasesTrain = new int[this.training.getNumInstances()];
        double[] caja = new double[1];
        this.nulosTrain = new boolean[this.training.getNumInstances()][Attributes.getInputNumAttributes()];
        this.nominalTrain = new int[this.training.getNumInstances()][Attributes.getInputNumAttributes()];
        this.realTrain = new double[this.training.getNumInstances()][Attributes.getInputNumAttributes()];
        for (i = 0; i < this.training.getNumInstances(); ++i) {
            temp = this.training.getInstance(i);
            nulls = temp.getInputMissingValues();
            this.datosTrain[i] = this.training.getInstance(i).getAllInputValues();
            for (j = 0; j < nulls.length; ++j) {
                if (!nulls[j]) continue;
                this.datosTrain[i][j] = 0.0;
                this.nulosTrain[i][j] = true;
            }
            caja[0] = this.training.getInstance(i).getOutputNominalValuesInt(0);
            this.clasesTrain[i] = (int)caja[0];
            for (k = 0; k < this.datosTrain[i].length; ++k) {
                if (Attributes.getInputAttribute(k).getType() == 0) {
                    this.nominalTrain[i][k] = (int)this.datosTrain[i][k];
                    double[] dArray = this.datosTrain[i];
                    int n = k;
                    dArray[n] = dArray[n] / (double)(Attributes.getInputAttribute(k).getNominalValuesList().size() - 1);
                    continue;
                }
                this.realTrain[i][k] = this.datosTrain[i][k];
                double[] dArray = this.datosTrain[i];
                int n = k;
                dArray[n] = dArray[n] - Attributes.getInputAttribute(k).getMinAttribute();
                double[] dArray2 = this.datosTrain[i];
                int n2 = k;
                dArray2[n2] = dArray2[n2] / (Attributes.getInputAttribute(k).getMaxAttribute() - Attributes.getInputAttribute(k).getMinAttribute());
                if (!Double.isNaN(this.datosTrain[i][k])) continue;
                this.datosTrain[i][k] = this.realTrain[i][k];
            }
        }
        this.datosTest = new double[this.test.getNumInstances()][Attributes.getInputNumAttributes()];
        this.realTest = new double[this.test.getNumInstances()][Attributes.getInputNumAttributes()];
        this.clasesTest = new int[this.test.getNumInstances()];
        caja = new double[1];
        for (i = 0; i < this.test.getNumInstances(); ++i) {
            temp = this.test.getInstance(i);
            nulls = temp.getInputMissingValues();
            this.datosTest[i] = (double[])this.test.getInstance(i).getAllInputValues().clone();
            for (k = 0; k < this.datosTest[i].length; ++k) {
                if (Attributes.getInputAttribute(k).getType() == 0) continue;
                this.realTest[i][k] = this.datosTest[i][k];
                double[] dArray = this.datosTest[i];
                int n = k;
                dArray[n] = dArray[n] - Attributes.getInputAttribute(k).getMinAttribute();
                double[] dArray3 = this.datosTest[i];
                int n3 = k;
                dArray3[n3] = dArray3[n3] / (Attributes.getInputAttribute(k).getMaxAttribute() - Attributes.getInputAttribute(k).getMinAttribute());
                if (!Double.isNaN(this.datosTest[i][k])) continue;
                this.datosTest[i][k] = this.realTest[i][k];
            }
            for (j = 0; j < nulls.length; ++j) {
                if (!nulls[j]) continue;
                this.datosTest[i][j] = 0.0;
            }
            caja = this.test.getInstance(i).getAllOutputValues();
            this.clasesTest[i] = (int)caja[0];
        }
    }

    public void leerConfiguracion(String ficheroScript) {
    }
}

