/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.syntaxtree.mut;

import java.util.ArrayList;
import net.sf.jclec.IPopulation;
import net.sf.jclec.syntaxtree.AbstractSyntaxTreeSpecies;
import net.sf.jclec.syntaxtree.ISyntaxTreeSpecies;
import net.sf.jclec.syntaxtree.NonTerminalNode;
import net.sf.jclec.syntaxtree.SyntaxTree;
import net.sf.jclec.syntaxtree.SyntaxTreeIndividual;
import net.sf.jclec.syntaxtree.SyntaxTreeMutator;
import org.apache.commons.lang.builder.EqualsBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecurseNTMutator<I extends SyntaxTreeIndividual>
extends SyntaxTreeMutator<I> {
    private static final long serialVersionUID = -2706522794304044852L;

    public RecurseNTMutator() {
    }

    public RecurseNTMutator(IPopulation<I> context) {
        this.contextualize(context);
    }

    public boolean equals(Object other) {
        if (other instanceof RecurseNTMutator) {
            RecurseNTMutator o = (RecurseNTMutator)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append(this.targetTreeIndex, o.targetTreeIndex);
            return eb.isEquals();
        }
        return false;
    }

    @Override
    protected SyntaxTree mutateTree(SyntaxTree parent, ISyntaxTreeSpecies.ISyntaxTreeSchema schema) {
        SyntaxTree son = new SyntaxTree();
        int p0_branchStart = this.selectSymbol(parent, schema);
        if (p0_branchStart == -1) {
            int i = 0;
            while (i < parent.size()) {
                son.addNode(parent.getNode(i).copy());
                ++i;
            }
            return son;
        }
        NonTerminalNode selectedProduction = this.chooseRecursiveProduction(parent.getNode(p0_branchStart).getSymbol(), schema);
        int p0_branchEnd = parent.subTree(p0_branchStart);
        int i = 0;
        while (i < p0_branchStart) {
            son.addNode(parent.getNode(i).copy());
            ++i;
        }
        this.addProduction(parent, son, selectedProduction, schema, p0_branchStart, p0_branchEnd);
        int j = p0_branchEnd;
        while (j < parent.size()) {
            son.addNode(parent.getNode(j).copy());
            ++j;
        }
        if (son.derivSize() > schema.getMaxDerivSize()) {
            son.clear();
            i = 0;
            while (i < parent.size()) {
                son.addNode(parent.getNode(i).copy());
                ++i;
            }
        }
        return son;
    }

    private final int selectSymbol(SyntaxTree tree, ISyntaxTreeSpecies.ISyntaxTreeSchema schema) {
        int startPos;
        int treeLength = tree.size();
        int actPos = startPos = this.randgen.choose(0, treeLength);
        int i = 0;
        while (i < treeLength) {
            actPos = (startPos + i) % treeLength;
            if (!((AbstractSyntaxTreeSpecies.SyntaxTreeSchema)schema).isTerminal(tree.getNode(actPos).getSymbol())) {
                NonTerminalNode nonTerminalSymbols = (NonTerminalNode)tree.getNode(actPos);
                int j = 0;
                while (j < nonTerminalSymbols.production.length) {
                    if (tree.getNode(actPos).getSymbol().equalsIgnoreCase(nonTerminalSymbols.production[j])) {
                        int p = actPos + 1;
                        while (p < tree.size()) {
                            if (tree.getNode(p).getSymbol().equalsIgnoreCase(nonTerminalSymbols.production[j])) {
                                return p;
                            }
                            ++p;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return -1;
    }

    public void addProduction(SyntaxTree parent, SyntaxTree son, NonTerminalNode selectedProduction, ISyntaxTreeSpecies.ISyntaxTreeSchema schema, int initialPoint, int finalPoint) {
        son.addNode(selectedProduction);
        boolean visited = false;
        int selProdSize = selectedProduction.production.length;
        int i = 0;
        while (i < selProdSize) {
            if (selectedProduction.production[i].equalsIgnoreCase(selectedProduction.getSymbol()) && !visited) {
                visited = true;
                int endBranch = parent.subTree(initialPoint);
                int h = initialPoint;
                while (h < endBranch) {
                    son.addNode(parent.getNode(h).copy());
                    ++h;
                }
            } else {
                schema.fillSyntaxBranch(son, selectedProduction.production[i], this.randgen);
            }
            ++i;
        }
    }

    public NonTerminalNode chooseRecursiveProduction(String selectedSymbol, ISyntaxTreeSpecies.ISyntaxTreeSchema schema) {
        NonTerminalNode[] nonTerminalNodes = schema.getNonTerminals();
        ArrayList<NonTerminalNode> recursiveNonTerminalNodes = new ArrayList<NonTerminalNode>();
        boolean recursive = false;
        int h = 0;
        while (h < nonTerminalNodes.length) {
            if (nonTerminalNodes[h].getSymbol().equalsIgnoreCase(selectedSymbol)) {
                recursive = false;
                int j = 0;
                while (j < nonTerminalNodes[h].production.length && !recursive) {
                    if (selectedSymbol.equalsIgnoreCase(nonTerminalNodes[h].production[j])) {
                        recursive = true;
                        recursiveNonTerminalNodes.add(nonTerminalNodes[h]);
                    }
                    ++j;
                }
            }
            ++h;
        }
        int nOfProduction = this.randgen.choose(0, recursiveNonTerminalNodes.size() - 1);
        return (NonTerminalNode)recursiveNonTerminalNodes.get(nOfProduction);
    }
}

