/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.algorithm.classic;

import java.util.ArrayList;
import java.util.List;
import net.sf.jclec.IConfigure;
import net.sf.jclec.IIndividual;
import net.sf.jclec.IMutator;
import net.sf.jclec.IRecombinator;
import net.sf.jclec.ISelector;
import net.sf.jclec.algorithm.PopulationAlgorithm;
import net.sf.jclec.base.FilteredMutator;
import net.sf.jclec.base.FilteredRecombinator;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.lang.builder.EqualsBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SG<I extends IIndividual>
extends PopulationAlgorithm<I> {
    private static final long serialVersionUID = -2649346083463795286L;
    protected ISelector<I> parentsSelector;
    protected FilteredMutator<I> mutator;
    protected FilteredRecombinator<I> recombinator;

    public ISelector<I> getParentsSelector() {
        return this.parentsSelector;
    }

    public void setParentsSelector(ISelector<I> parentsSelector) {
        this.parentsSelector = parentsSelector;
        parentsSelector.contextualize(this);
    }

    public IRecombinator<I> getRecombinator() {
        return this.recombinator.getDecorated();
    }

    public void setRecombinator(IRecombinator<I> recombinator) {
        if (this.recombinator == null) {
            this.recombinator = new FilteredRecombinator(this);
        }
        this.recombinator.setDecorated(recombinator);
    }

    public double getRecombinationProb() {
        return this.recombinator.getRecProb();
    }

    public void setRecombinationProb(double recProb) {
        if (this.recombinator == null) {
            this.recombinator = new FilteredRecombinator(this);
        }
        this.recombinator.setRecProb(recProb);
    }

    public IMutator<I> getMutator() {
        return this.mutator.getDecorated();
    }

    public void setMutator(IMutator<I> mutator) {
        if (this.mutator == null) {
            this.mutator = new FilteredMutator(this);
        }
        this.mutator.setDecorated(mutator);
    }

    public double getMutationProb() {
        return this.mutator.getMutProb();
    }

    public void setMutationProb(double mutProb) {
        if (this.mutator == null) {
            this.mutator = new FilteredMutator(this);
        }
        this.mutator.setMutProb(mutProb);
    }

    @Override
    public void configure(Configuration configuration) {
        super.configure(configuration);
        try {
            String parentsSelectorClassname = configuration.getString("parents-selector[@type]");
            Class<?> parentsSelectorClass = Class.forName(parentsSelectorClassname);
            ISelector parentsSelector = (ISelector)parentsSelectorClass.newInstance();
            if (parentsSelector instanceof IConfigure) {
                Configuration parentsSelectorConfiguration = configuration.subset("parents-selector");
                ((IConfigure)((Object)parentsSelector)).configure(parentsSelectorConfiguration);
            }
            this.setParentsSelector(parentsSelector);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationRuntimeException("Illegal parents selector classname");
        }
        catch (InstantiationException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of parents selector", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of parents selector", e);
        }
        try {
            String recombinatorClassname = configuration.getString("recombinator[@type]");
            Class<?> recombinatorClass = Class.forName(recombinatorClassname);
            IRecombinator recombinator = (IRecombinator)recombinatorClass.newInstance();
            if (recombinator instanceof IConfigure) {
                Configuration recombinatorConfiguration = configuration.subset("recombinator");
                ((IConfigure)((Object)recombinator)).configure(recombinatorConfiguration);
            }
            this.setRecombinator(recombinator);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationRuntimeException("Illegal recombinator classname");
        }
        catch (InstantiationException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of recombinator", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of recombinator", e);
        }
        double recProb = configuration.getDouble("recombinator[@rec-prob]");
        this.setRecombinationProb(recProb);
        try {
            String mutatorClassname = configuration.getString("mutator[@type]");
            Class<?> mutatorClass = Class.forName(mutatorClassname);
            IMutator mutator = (IMutator)mutatorClass.newInstance();
            if (mutator instanceof IConfigure) {
                Configuration mutatorConfiguration = configuration.subset("mutator");
                ((IConfigure)((Object)mutator)).configure(mutatorConfiguration);
            }
            this.setMutator(mutator);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationRuntimeException("Illegal mutator classname");
        }
        catch (InstantiationException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of mutator", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of mutator", e);
        }
        double mutProb = configuration.getDouble("mutator[@mut-prob]");
        this.setMutationProb(mutProb);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof SG) {
            SG cother = (SG)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.appendSuper(super.equals(other));
            eb.append(this.parentsSelector, cother.parentsSelector);
            eb.append(this.mutator, cother.mutator);
            eb.append(this.recombinator, cother.recombinator);
            return eb.isEquals();
        }
        return false;
    }

    @Override
    protected void doSelection() {
        this.pset = this.parentsSelector.select(this.bset);
    }

    @Override
    protected void doGeneration() {
        this.rset = this.recombinator.recombine(this.pset);
        for (IIndividual ind : this.recombinator.getSterile()) {
            this.rset.add(ind);
        }
        List<I> mset = this.mutator.mutate(this.rset);
        for (IIndividual ind : this.mutator.getSterile()) {
            mset.add(ind);
        }
        this.cset = new ArrayList();
        for (IIndividual ind : mset) {
            if (this.pset.contains(ind)) {
                IIndividual indc = ind.copy();
                this.cset.add(indc);
                continue;
            }
            this.cset.add(ind);
        }
        this.evaluator.evaluate(this.cset);
    }

    @Override
    protected void doReplacement() {
        this.rset = this.bset;
    }

    @Override
    protected void doUpdate() {
        this.bset = this.cset;
        this.pset = null;
        this.rset = null;
        this.cset = null;
    }
}

