/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Neural_Networks.NNEP_Common;

import keel.Algorithms.Neural_Networks.NNEP_Common.AbstractNeuralNetSpecies;
import keel.Algorithms.Neural_Networks.NNEP_Common.NeuralNetIndividual;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.INeuralNet;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.InputLayer;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.LinkedLayer;
import net.sf.jclec.IConfigure;
import net.sf.jclec.util.range.Interval;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.lang.builder.EqualsBuilder;

public class NeuralNetIndividualSpecies
extends AbstractNeuralNetSpecies<NeuralNetIndividual>
implements IConfigure {
    private static final long serialVersionUID = 2813451004932981929L;

    public void setNOfHiddenLayers(int nOfHiddenLayers) {
        this.nOfHiddenLayers = nOfHiddenLayers;
    }

    public void setNOfInputs(int nOfInputs) {
        this.nOfInputs = nOfInputs;
    }

    public void setNOfOutputs(int nOfOutputs) {
        this.nOfOutputs = nOfOutputs;
    }

    public void setHiddenLayerWeightRange(int index, int indexRange, Interval hiddenLayerWeightRange) {
        this.weightRanges[index][indexRange] = hiddenLayerWeightRange;
    }

    public void setOutputLayerWeightRange(int indexRange, Interval outputLayerWeightRange) {
        this.weightRanges[this.weightRanges.length - 1][indexRange] = outputLayerWeightRange;
    }

    public void setHiddenLayerMaxNofneurons(int index, int hiddenLayerMaxNofneurons) {
        this.maxNofneurons[index] = hiddenLayerMaxNofneurons;
    }

    public void setHiddenLayerMinNofneurons(int index, int hiddenLayerMinNofneurons) {
        this.minNofneurons[index] = hiddenLayerMinNofneurons;
    }

    public void setHiddenLayerInitialNofneurons(int index, int hiddenLayerInitialMaxNofneurons) {
        this.initialMaxNofneurons[index] = hiddenLayerInitialMaxNofneurons;
    }

    public void setHiddenLayerType(int index, String hiddenLayerType) {
        this.type[index] = hiddenLayerType;
    }

    public void setOutputLayerType(String outputLayerType) {
        this.type[this.type.length - 1] = outputLayerType;
    }

    public void setHiddenLayerInitiator(int index, String hiddenLayerInitiator) {
        this.initiator[index] = hiddenLayerInitiator;
    }

    public void setOutputLayerInitiator(String outputLayerInitiator) {
        this.initiator[this.initiator.length - 1] = outputLayerInitiator;
    }

    public void setHiddenLayerBiased(int index, boolean hiddenLayerBiased) {
        this.biased[index] = hiddenLayerBiased;
    }

    public void setOutputLayerBiased(boolean outputLayerBiased) {
        this.biased[this.biased.length - 1] = outputLayerBiased;
    }

    public void setNeuronTypes(int index, String[] neuronTypes) {
        this.neuronTypes[index] = neuronTypes;
    }

    public void setPercentages(int index, double[] percentages) {
        this.percentages[index] = percentages;
    }

    public void setInitiatorNeuronTypes(int index, String[] initiatorNeuronTypes) {
        this.initiatorNeuronTypes[index] = initiatorNeuronTypes;
    }

    @Override
    public NeuralNetIndividual createIndividual() {
        return new NeuralNetIndividual();
    }

    @Override
    public NeuralNetIndividual createIndividual(INeuralNet genotype) {
        return new NeuralNetIndividual(genotype);
    }

    @Override
    public INeuralNet createGenotype() {
        INeuralNet result = null;
        try {
            Class<?> neuralNetClass = Class.forName(this.neuralNetType);
            result = (INeuralNet)neuralNetClass.newInstance();
            this.generateTopology(result);
            result.getInputLayer().setMaxnofneurons(this.nOfInputs);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationRuntimeException("Illegal neural net classname");
        }
        catch (InstantiationException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of " + this.type, e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of " + this.type, e);
        }
        return result;
    }

    private void generateTopology(INeuralNet neuralNet) {
        InputLayer inputLayer = new InputLayer();
        neuralNet.setInputLayer(inputLayer);
        try {
            for (int i = 0; i < this.nOfHiddenLayers; ++i) {
                LinkedLayer hiddenLayer = (LinkedLayer)Class.forName(this.getHiddenLayerType(i)).newInstance();
                hiddenLayer.setType(1);
                neuralNet.addHlayer(hiddenLayer);
            }
            LinkedLayer outputLayer = (LinkedLayer)Class.forName(this.getOutputLayerType()).newInstance();
            outputLayer.setType(2);
            neuralNet.setOutputLayer(outputLayer);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public boolean equals(Object other) {
        if (other instanceof NeuralNetIndividualSpecies) {
            EqualsBuilder eb = new EqualsBuilder();
            NeuralNetIndividualSpecies nnoth = (NeuralNetIndividualSpecies)other;
            eb.append(this.neuralNetType, nnoth.neuralNetType);
            eb.append(this.nOfInputs, nnoth.nOfInputs);
            eb.append(this.nOfHiddenLayers, nnoth.nOfHiddenLayers);
            eb.append(this.nOfOutputs, nnoth.nOfOutputs);
            eb.append((Object[])this.weightRanges, (Object[])nnoth.weightRanges);
            eb.append(this.maxNofneurons, nnoth.maxNofneurons);
            eb.append(this.minNofneurons, nnoth.minNofneurons);
            eb.append(this.initialMaxNofneurons, nnoth.initialMaxNofneurons);
            eb.append(this.type, nnoth.type);
            eb.append(this.initiator, nnoth.initiator);
            eb.append(this.biased, nnoth.biased);
            eb.append((Object[])this.neuronTypes, (Object[])nnoth.neuronTypes);
            eb.append((Object[])this.percentages, (Object[])nnoth.percentages);
            eb.append((Object[])this.initiatorNeuronTypes, (Object[])nnoth.initiatorNeuronTypes);
            return eb.isEquals();
        }
        return false;
    }

    @Override
    public void configure(Configuration configuration) {
        this.neuralNetType = configuration.getString("neural-net-type");
        this.nOfHiddenLayers = configuration.getList("hidden-layer[@type]").size();
        this.maxNofneurons = new int[this.nOfHiddenLayers];
        this.minNofneurons = new int[this.nOfHiddenLayers];
        this.initialMaxNofneurons = new int[this.nOfHiddenLayers];
        this.type = new String[this.nOfHiddenLayers + 1];
        this.initiator = new String[this.nOfHiddenLayers + 1];
        this.biased = new boolean[this.nOfHiddenLayers + 1];
        this.weightRanges = new Interval[this.nOfHiddenLayers + 1][];
        this.neuronTypes = new String[this.nOfHiddenLayers + 1][];
        this.percentages = new double[this.nOfHiddenLayers + 1][];
        this.initiatorNeuronTypes = new String[this.nOfHiddenLayers + 1][];
        for (int i = 0; i < this.nOfHiddenLayers + 1; ++i) {
            String header;
            if (i != this.nOfHiddenLayers) {
                header = "hidden-layer(" + i + ")";
                this.maxNofneurons[i] = configuration.getInt(header + ".maximum-number-of-neurons");
                this.minNofneurons[i] = configuration.getInt(header + ".minimum-number-of-neurons");
                this.initialMaxNofneurons[i] = configuration.getInt(header + ".initial-maximum-number-of-neurons");
                this.initiator[i] = configuration.getString(header + ".initiator-of-links");
            } else {
                header = "output-layer";
                this.initiator[i] = configuration.getString(header + ".initiator-of-links");
            }
            this.type[i] = configuration.getString(header + "[@type]");
            this.biased[i] = configuration.getBoolean(header + "[@biased]");
            this.weightRanges[i] = new Interval[1];
            try {
                String rangeName = header + ".weight-range";
                String rangeClassname = configuration.getString(rangeName + "[@type]");
                Class<?> rangeClass = Class.forName(rangeClassname);
                Interval range = (Interval)rangeClass.newInstance();
                range.configure(configuration.subset(rangeName));
                if (i != this.nOfHiddenLayers) {
                    this.setHiddenLayerWeightRange(i, 0, range);
                    continue;
                }
                this.setOutputLayerWeightRange(0, range);
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationRuntimeException("Illegal range classname");
            }
            catch (InstantiationException e) {
                throw new ConfigurationRuntimeException("Problems creating an instance of range", e);
            }
            catch (IllegalAccessException e) {
                throw new ConfigurationRuntimeException("Problems creating an instance of range", e);
            }
        }
    }
}

