/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Genetic_Rule_Learning.M5Rules;

import java.util.Vector;
import keel.Algorithms.Genetic_Rule_Learning.M5Rules.M5;
import keel.Algorithms.Genetic_Rule_Learning.M5Rules.M5TreeNode;
import keel.Algorithms.Genetic_Rule_Learning.M5Rules.MyDataset;
import keel.Algorithms.Genetic_Rule_Learning.M5Rules.Rule;
import keel.Algorithms.Genetic_Rule_Learning.M5Rules.SimpleRule;
import keel.Algorithms.Genetic_Rule_Learning.M5Rules.parseParameters;
import org.core.Fichero;

class M5Rules {
    public static int COVERAGE = 0;
    public static int RMS = 1;
    public static int MAE = 2;
    public static int CC = 3;
    MyDataset train;
    MyDataset val;
    MyDataset test;
    String outputTr;
    String outputTst;
    String outputRules;
    private Vector classification_rules;
    private String default_class_name;
    private double pruningFactor;
    private int verbosity;
    private boolean unsmoothed = true;
    private int heuristic = COVERAGE;

    private Vector convert(M5TreeNode node, Rule base_rule, SimpleRule link_to_father) {
        Rule node_rule = base_rule.getCopy();
        if (link_to_father != null) {
            node_rule.grow(link_to_father);
        }
        Vector<Rule> output = new Vector<Rule>();
        if (node != null) {
            if (node.isLeaf()) {
                if (this.unsmoothed) {
                    node_rule.setFunction(node.getUnsmoothedFunction());
                } else {
                    node_rule.setFunction(node.getSmoothedFunction());
                }
                output.add(node_rule);
            } else {
                int cut_attribute = node.getSplitingAttribute();
                SimpleRule left_link = new SimpleRule();
                SimpleRule right_link = new SimpleRule();
                left_link.setAttribute(cut_attribute);
                left_link.setValue(node.getSplitingValue());
                right_link.setAttribute(cut_attribute);
                right_link.setValue(node.getSplitingValue());
                left_link.setOperator(SimpleRule.LOWER);
                right_link.setOperator(SimpleRule.GREATER);
                Vector right_rules = this.convert(node.getRightChild(), node_rule, right_link);
                Vector left_rules = this.convert(node.getLeftChild(), node_rule, left_link);
                output.addAll(right_rules);
                output.addAll(left_rules);
            }
        }
        return output;
    }

    private void doOutput(MyDataset dataset, String filename, double[] classification) {
        String output = new String("");
        output = dataset.copyHeader();
        for (int i = 0; i < dataset.size(); ++i) {
            double class_name = dataset.itemset(i).getClassValue();
            output = output + class_name + " " + classification[i] + "\n";
        }
        Fichero.escribeFichero(filename, output);
    }

    private void doRulesOutput(String filename, Vector rules) {
        String output = new String("");
        output = output + "@Number of rules: " + rules.size() + "\n\n";
        for (int i = 0; i < rules.size(); ++i) {
            output = output + "Rule " + (i + 1) + ": " + (Rule)rules.elementAt(i) + "\n";
        }
        Fichero.escribeFichero(filename, output);
    }

    public M5Rules(parseParameters paramFile) throws Exception {
        String trainFileName = paramFile.getTrainingInputFile();
        String valFileName = paramFile.getValidationInputFile();
        String testFileName = paramFile.getTestInputFile();
        this.outputTr = paramFile.getTrainingOutputFile();
        this.outputTst = paramFile.getTestOutputFile();
        this.outputRules = paramFile.getOutputFile(0);
        this.pruningFactor = Double.parseDouble(paramFile.getParameter(0));
        this.unsmoothed = true;
        this.verbosity = Integer.parseInt(paramFile.getParameter(1));
        String heuristic_name = paramFile.getParameter(2);
        if (this.pruningFactor < 0.0 || this.pruningFactor > 10.0) {
            this.pruningFactor = 2.0;
            System.err.println("Error: Pruning Factor must be in the interval [0,10]");
            System.err.println("Using default value: 2");
        }
        if (this.verbosity < 0 || this.verbosity > 2) {
            this.verbosity = 0;
            System.err.println("Error: Verbosity must be 0, 1 or 2");
            System.err.println("Using default value: 0");
        }
        if (heuristic_name.equalsIgnoreCase("Coverage")) {
            this.heuristic = COVERAGE;
        } else if (heuristic_name.equalsIgnoreCase("RMS")) {
            this.heuristic = RMS;
        } else if (heuristic_name.equalsIgnoreCase("MAE")) {
            this.heuristic = MAE;
        } else if (heuristic_name.equalsIgnoreCase("CC")) {
            this.heuristic = CC;
        } else {
            this.heuristic = COVERAGE;
            System.err.println("Error: heuristic must be Coverage, RMS, MAE or CC");
            System.err.println("Using default value: Coverage");
        }
        this.train = new MyDataset(trainFileName, true);
        this.val = new MyDataset(valFileName, false);
        this.test = new MyDataset(testFileName, false);
        if (this.train.getClassAttribute().isDiscret()) {
            throw new Exception("Class has to be numeric.");
        }
        this.classification_rules = null;
        this.default_class_name = null;
    }

    public Vector treeToRules(M5TreeNode tree) {
        Vector<Rule> output = null;
        if (!tree.isLeaf()) {
            output = this.convert(tree, new Rule(), null);
        } else {
            Rule r = new Rule();
            if (this.unsmoothed) {
                r.setFunction(tree.getUnsmoothedFunction());
            } else {
                r.setFunction(tree.getSmoothedFunction());
            }
            output = new Vector<Rule>();
            output.add(r);
        }
        return output;
    }

    public void removeDuplicates(Vector rules) {
        for (int i = 0; i < rules.size(); ++i) {
            Rule current = (Rule)rules.elementAt(i);
            if (current.size() != 0) {
                for (int j = i + 1; j < rules.size(); ++j) {
                    if (!current.isEqual((Rule)rules.elementAt(j))) continue;
                    rules.remove(j);
                    --j;
                }
                continue;
            }
            rules.remove(i);
            --i;
        }
    }

    public void executeAlgorithm(MyDataset remained_data) throws Exception {
        this.classification_rules = new Vector();
        while (remained_data.numItemsets() > 0) {
            M5 subtree = null;
            subtree = new M5(remained_data, this.pruningFactor, this.unsmoothed, this.verbosity);
            System.out.println("The partial tree\n" + subtree);
            Vector rules = this.treeToRules(subtree.getTree());
            System.out.println("The rules");
            for (int i = 0; i < rules.size(); ++i) {
                System.out.println((Rule)rules.elementAt(i));
            }
            int best_rule = -1;
            double best_value = Double.MAX_VALUE;
            for (int i = 0; i < rules.size(); ++i) {
                double curr_value = Double.MAX_VALUE;
                Rule ri = (Rule)rules.elementAt(i);
                if (this.heuristic == COVERAGE) {
                    curr_value = -ri.apply(remained_data);
                } else if (this.heuristic == RMS) {
                    curr_value = remained_data.ruleDeviation(ri) / remained_data.classSTD();
                } else if (this.heuristic == MAE) {
                    curr_value = remained_data.ruleMeanAbsoluteError(ri);
                } else if (this.heuristic == CC) {
                    curr_value = remained_data.ruleCorrelation(ri);
                }
                if (!(curr_value < best_value)) continue;
                best_rule = i;
                best_value = curr_value;
            }
            this.classification_rules.add((Rule)rules.elementAt(best_rule));
            MyDataset[] division = remained_data.split((Rule)rules.elementAt(best_rule));
            remained_data = division[1];
        }
    }

    public void execute() throws Exception {
        this.executeAlgorithm(this.train);
        double[] classification_train = this.train.classify(this.classification_rules);
        double[] classification_val = this.val.classify(this.classification_rules);
        double[] classification_test = this.test.classify(this.classification_rules);
        this.doOutput(this.val, this.outputTr, classification_val);
        this.doOutput(this.test, this.outputTst, classification_test);
        this.doRulesOutput(this.outputRules, this.classification_rules);
        System.out.println("Algorithm Finished");
    }
}

