/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf.arima;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.IDataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.data.SubArrayOfInt;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.maths.realfunctions.IParametricMapping;
import ec.tstoolkit.maths.realfunctions.ParamValidation;
import ec.tstoolkit.maths.realfunctions.SingleParameter;
import ec.tstoolkit.ssf.ISsf;

public class SsfRwAr1
implements ISsf {
    private double m_rho = 0.2;
    private boolean m_zeroinit;

    public SsfRwAr1() {
    }

    public SsfRwAr1(double rho) {
        this.m_rho = rho;
    }

    @Override
    public void diffuseConstraints(SubMatrix b) {
        this.Pi0(b);
    }

    @Override
    public void fullQ(int pos, SubMatrix qm) {
        qm.set(1, 1, 1.0);
    }

    @Override
    public int getNonStationaryDim() {
        return this.m_zeroinit ? 0 : 1;
    }

    public double getRho() {
        return this.m_rho;
    }

    @Override
    public int getStateDim() {
        return 2;
    }

    @Override
    public int getTransitionResCount() {
        return 1;
    }

    @Override
    public int getTransitionResDim() {
        return 1;
    }

    @Override
    public boolean hasR() {
        return true;
    }

    @Override
    public boolean hasTransitionRes(int pos) {
        return true;
    }

    @Override
    public boolean hasW() {
        return false;
    }

    @Override
    public boolean isDiffuse() {
        return !this.m_zeroinit;
    }

    @Override
    public boolean isMeasurementEquationTimeInvariant() {
        return true;
    }

    @Override
    public boolean isTimeInvariant() {
        return true;
    }

    @Override
    public boolean isTransitionEquationTimeInvariant() {
        return true;
    }

    @Override
    public boolean isTransitionResidualTimeInvariant() {
        return true;
    }

    public boolean isUseZeroInitialization() {
        return this.m_zeroinit;
    }

    @Override
    public boolean isValid() {
        return Math.abs(this.m_rho) < 1.0;
    }

    @Override
    public void L(int pos, DataBlock k, SubMatrix lm) {
        double k0 = k.get(0);
        double k1 = k.get(1);
        lm.set(0, 0, 1.0 - k0);
        lm.set(0, 1, 1.0 - k0);
        lm.set(1, 0, -k1);
        lm.set(1, 1, this.m_rho - k1);
    }

    @Override
    public void Pf0(SubMatrix pf0) {
        if (!this.m_zeroinit) {
            pf0.set(1, 1, 1.0 / (1.0 - this.m_rho * this.m_rho));
        } else {
            pf0.set(1, 1, 1.0);
        }
    }

    @Override
    public void Pi0(SubMatrix pi0) {
        if (!this.m_zeroinit) {
            pi0.set(0, 0, 1.0);
        }
    }

    @Override
    public void Q(int pos, SubMatrix qm) {
        qm.set(0, 0, 1.0);
    }

    @Override
    public void R(int pos, SubArrayOfInt rv) {
        rv.set(0, 1);
    }

    public void setRho(double value) {
        this.m_rho = value;
    }

    @Override
    public void T(int pos, SubMatrix tr) {
        tr.set(0, 0, 1.0);
        tr.set(0, 1, 1.0);
        tr.set(1, 1, this.m_rho);
    }

    @Override
    public void TVT(int pos, SubMatrix vm) {
        double v00 = vm.get(0, 0);
        double v01 = vm.get(0, 1);
        double v10 = vm.get(1, 0);
        double v11 = vm.get(1, 1);
        vm.set(0, 0, v00 + v01 + v10 + v11);
        vm.set(0, 1, this.m_rho * (v01 + v11));
        vm.set(1, 0, this.m_rho * (v10 + v11));
        vm.set(1, 1, this.m_rho * this.m_rho * v11);
    }

    @Override
    public void TX(int pos, DataBlock x) {
        x.set(0, x.sum());
        x.mul(1, this.m_rho);
    }

    public void useZeroInitialization(boolean value) {
        this.m_zeroinit = value;
    }

    @Override
    public void VpZdZ(int pos, SubMatrix vm, double d) {
        vm.add(d);
    }

    @Override
    public void W(int pos, SubMatrix wv) {
    }

    @Override
    public void XpZd(int pos, DataBlock x, double d) {
        x.add(d);
    }

    @Override
    public void XT(int pos, DataBlock x) {
        x.set(1, x.get(0) + this.m_rho * x.get(1));
    }

    @Override
    public void Z(int pos, DataBlock x) {
        x.set(1.0);
    }

    @Override
    public void ZM(int pos, SubMatrix m, DataBlock x) {
        x.sum(m.row(0), m.row(1));
    }

    @Override
    public double ZVZ(int pos, SubMatrix vm) {
        return vm.sum();
    }

    @Override
    public double ZX(int pos, DataBlock x) {
        return x.sum();
    }

    public static class Mapping
    implements IParametricMapping<SsfRwAr1> {
        public static final String RHO = "rho";
        public final boolean zeroInit;
        public final double a_;
        public final double b_;
        public static final double EPS = Math.sqrt(2.220446E-16);
        public static final double BOUND = 0.99999999;

        public Mapping(boolean zeroInit) {
            this.zeroInit = zeroInit;
            this.a_ = -0.99999999;
            this.b_ = 0.99999999;
        }

        public Mapping(boolean zeroInit, double a, double b) {
            this.zeroInit = zeroInit;
            this.a_ = Math.max(a, -0.99999999);
            this.b_ = Math.min(b, 0.99999999);
        }

        @Override
        public boolean checkBoundaries(IReadDataBlock inparams) {
            double p = inparams.get(0);
            return p > this.a_ && p < this.b_;
        }

        @Override
        public double epsilon(IReadDataBlock inparams, int idx) {
            return EPS;
        }

        @Override
        public int getDim() {
            return 1;
        }

        @Override
        public double lbound(int idx) {
            return this.a_;
        }

        @Override
        public SsfRwAr1 map(IReadDataBlock p) {
            if (p.getLength() != 1) {
                return null;
            }
            SsfRwAr1 ssf = new SsfRwAr1(p.get(0));
            ssf.m_zeroinit = this.zeroInit;
            return ssf;
        }

        @Override
        public IReadDataBlock map(SsfRwAr1 t) {
            return new SingleParameter(t.getRho());
        }

        @Override
        public double ubound(int idx) {
            return this.b_;
        }

        @Override
        public ParamValidation validate(IDataBlock ioparams) {
            double p = ioparams.get(0);
            ParamValidation rslt = ParamValidation.Valid;
            if (p < this.a_) {
                p = this.a_;
                ioparams.set(0, p);
                rslt = ParamValidation.Changed;
            } else if (p > this.b_) {
                p = this.b_;
                ioparams.set(0, p);
                rslt = ParamValidation.Changed;
            }
            return rslt;
        }

        @Override
        public String getDescription(int idx) {
            return RHO;
        }
    }
}

