/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.seats;

import ec.satoolkit.seats.IModelEstimator;
import ec.satoolkit.seats.IModelValidator;
import ec.satoolkit.seats.ModelStatus;
import ec.satoolkit.seats.SeatsModel;
import ec.tstoolkit.arima.estimation.LikelihoodStatistics;
import ec.tstoolkit.arima.estimation.RegArimaEstimation;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.maths.realfunctions.ProxyMinimizer;
import ec.tstoolkit.maths.realfunctions.levmar.LevenbergMarquardtMethod;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.estimation.GlsSarimaMonitor;

public class DefaultModelEstimator
implements IModelEstimator {
    private final IModelValidator validator;

    public DefaultModelEstimator(IModelValidator validator) {
        this.validator = validator;
    }

    @Override
    public boolean estimate(boolean ml, SeatsModel model, InformationSet info) {
        GlsSarimaMonitor monitor = new GlsSarimaMonitor();
        monitor.setMinimizer(new ProxyMinimizer(new LevenbergMarquardtMethod()));
        monitor.setPrecision(1.0E-7);
        monitor.useMaximumLikelihood(ml);
        RegArimaEstimation<SarimaModel> estimation = monitor.process(model.getRegarima());
        if (estimation == null) {
            return false;
        }
        SarimaModel arima = (SarimaModel)estimation.model.getArima();
        if (this.validator != null && ModelStatus.Changed == this.validator.validate(arima, info)) {
            arima = this.validator.getNewModel();
        }
        model.setModel(arima);
        LikelihoodStatistics stat = estimation.statistics(arima.getParametersCount(), 0.0);
        model.setSer(Math.sqrt(stat.SsqErr / (double)(stat.effectiveObservationsCount - stat.estimatedParametersCount)));
        info.subSet("gls").set("likelihood", estimation.likelihood);
        return true;
    }
}

