/*
 * Decompiled with CFR 0.152.
 */
package ec.benchmarking.simplets;

import ec.benchmarking.simplets.AbstractTsBenchmarking;
import ec.benchmarking.ssf.SsfCholette;
import ec.benchmarking.ssf.SsfDenton;
import ec.tstoolkit.ssf.DisturbanceSmoother;
import ec.tstoolkit.ssf.SmoothingResults;
import ec.tstoolkit.ssf.SsfData;
import ec.tstoolkit.ssf.WeightedSsf;
import ec.tstoolkit.ssf.arima.SsfAr1;
import ec.tstoolkit.ssf.arima.SsfRw;
import ec.tstoolkit.timeseries.TsAggregationType;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDataBlock;

public class TsCholette
extends AbstractTsBenchmarking {
    private BiasCorrection bias_ = BiasCorrection.None;
    private double rho_ = 0.9;
    private double lambda_;

    private TsData correctBias(TsData s, TsData target) {
        TsAggregationType agg = this.getAggregationType();
        if (this.bias_ == BiasCorrection.None || agg != TsAggregationType.Average && agg != TsAggregationType.Sum) {
            return s;
        }
        TsData sy = s.changeFrequency(target.getFrequency(), this.getAggregationType(), true);
        sy = sy.fittoDomain(target.getDomain());
        if (this.bias_ == BiasCorrection.Multiplicative) {
            return s.times(TsDataBlock.all((TsData)target).data.sum() / TsDataBlock.all((TsData)sy).data.sum());
        }
        double b = (TsDataBlock.all((TsData)target).data.sum() - TsDataBlock.all((TsData)sy).data.sum()) / (double)target.getLength();
        if (agg == TsAggregationType.Average) {
            int hfreq = s.getFrequency().intValue();
            int lfreq = target.getFrequency().intValue();
            b *= (double)(hfreq / lfreq);
        }
        return s.plus(b);
    }

    public double getRho() {
        return this.rho_;
    }

    public BiasCorrection getBiasCorrection() {
        return this.bias_;
    }

    public void setBiasCorrection(BiasCorrection bias) {
        this.bias_ = bias;
    }

    private TsData archolette(TsData s, TsData target) {
        int lfreq = target.getFrequency().intValue();
        int hfreq = s.getFrequency().intValue();
        int c = hfreq / lfreq;
        TsData obj = s.changeFrequency(target.getFrequency(), this.getAggregationType(), true).minus(target);
        if (this.getAggregationType() == TsAggregationType.Average) {
            obj = obj.times(c);
        }
        double[] y = TsCholette.expand(s.getDomain(), obj, this.getAggregationType());
        double[] w = null;
        if (this.lambda_ == 1.0) {
            w = s.internalStorage();
        } else {
            w = new double[s.getLength()];
            TsDataBlock.all((TsData)s).data.copyTo(w, 0);
            for (int i = 0; i < w.length; ++i) {
                w[i] = Math.pow(Math.abs(w[i]), this.lambda_);
            }
        }
        if (this.getAggregationType() == TsAggregationType.Average || this.getAggregationType() == TsAggregationType.Sum) {
            double[] b;
            SsfCholette cholette = new SsfCholette(c, s.getStart().getPosition() % c, this.rho_, w);
            DisturbanceSmoother dsmoother = new DisturbanceSmoother();
            dsmoother.setSsf(cholette);
            dsmoother.process(new SsfData(y, null));
            SmoothingResults drslts = dsmoother.calcSmoothedStates();
            if (w != null) {
                b = new double[s.getLength()];
                for (int i = 0; i < b.length; ++i) {
                    b[i] = w[i] * drslts.A(i).get(1);
                }
            } else {
                b = drslts.component(1);
            }
            return s.minus(new TsData(s.getStart(), b, false));
        }
        WeightedSsf<SsfAr1> ssf = new WeightedSsf<SsfAr1>(w, new SsfAr1());
        DisturbanceSmoother dsmoother = new DisturbanceSmoother();
        dsmoother.setSsf(ssf);
        dsmoother.process(new SsfData(y, null));
        SmoothingResults drslts = dsmoother.calcSmoothedStates();
        double[] b = new double[s.getLength()];
        for (int i = 0; i < b.length; ++i) {
            b[i] = ssf.ZX(i, drslts.A(i));
        }
        return s.minus(new TsData(s.getStart(), b, false));
    }

    private TsData rwcholette(TsData s, TsData target) {
        int lfreq = target.getFrequency().intValue();
        int hfreq = s.getFrequency().intValue();
        int c = hfreq / lfreq;
        TsData obj = s.changeFrequency(target.getFrequency(), this.getAggregationType(), true).minus(target);
        if (this.getAggregationType() == TsAggregationType.Average) {
            obj = obj.times(c);
        }
        double[] y = TsCholette.expand(s.getDomain(), obj, this.getAggregationType());
        double[] w = null;
        if (this.lambda_ == 1.0) {
            w = s.internalStorage();
        } else {
            w = new double[s.getLength()];
            TsDataBlock.all((TsData)s).data.copyTo(w, 0);
            for (int i = 0; i < w.length; ++i) {
                w[i] = Math.pow(Math.abs(w[i]), this.lambda_);
            }
        }
        if (this.getAggregationType() == TsAggregationType.Average || this.getAggregationType() == TsAggregationType.Sum) {
            double[] b;
            SsfDenton denton = new SsfDenton(c, s.getStart().getPosition() % c, w);
            DisturbanceSmoother dsmoother = new DisturbanceSmoother();
            dsmoother.setSsf(denton);
            dsmoother.process(new SsfData(y, null));
            SmoothingResults drslts = dsmoother.calcSmoothedStates();
            if (w != null) {
                b = new double[s.getLength()];
                for (int i = 0; i < b.length; ++i) {
                    b[i] = w[i] * drslts.A(i).get(1);
                }
            } else {
                b = drslts.component(1);
            }
            return s.minus(new TsData(s.getStart(), b, false));
        }
        WeightedSsf<SsfRw> denton = new WeightedSsf<SsfRw>(w, new SsfRw());
        DisturbanceSmoother dsmoother = new DisturbanceSmoother();
        dsmoother.setSsf(denton);
        dsmoother.process(new SsfData(y, null));
        SmoothingResults drslts = dsmoother.calcSmoothedStates();
        double[] b = new double[s.getLength()];
        for (int i = 0; i < b.length; ++i) {
            b[i] = denton.ZX(i, drslts.A(i));
        }
        return s.minus(new TsData(s.getStart(), b, false));
    }

    public void setRho(double value) {
        this.rho_ = value;
    }

    public void setLambda(double lambda) {
        this.lambda_ = lambda;
    }

    @Override
    protected TsData benchmark(TsData s, TsData constraints) {
        s = this.correctBias(s, constraints);
        if (this.rho_ == 1.0) {
            return this.rwcholette(s, constraints);
        }
        return this.archolette(s, constraints);
    }

    public static enum BiasCorrection {
        None,
        Additive,
        Multiplicative;

    }
}

