/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong;

import cern.colt.PersistentObject;
import cern.colt.matrix.tlong.LongMatrix3D;
import cern.colt.matrix.tlong.impl.DenseLongMatrix3D;
import cern.colt.matrix.tlong.impl.SparseLongMatrix3D;
import cern.jet.math.tlong.LongFunctions;

public class LongFactory3D
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    public static final LongFactory3D dense = new LongFactory3D();
    public static final LongFactory3D sparse = new LongFactory3D();

    protected LongFactory3D() {
    }

    public LongMatrix3D ascending(int n, int n2, int n3) {
        LongFunctions longFunctions = LongFunctions.longFunctions;
        return this.descending(n, n2, n3).assign(LongFunctions.chain(LongFunctions.neg, LongFunctions.minus(n * n2 * n3)));
    }

    public LongMatrix3D descending(int n, int n2, int n3) {
        LongMatrix3D longMatrix3D = this.make(n, n2, n3);
        int n4 = 0;
        int n5 = n;
        while (--n5 >= 0) {
            int n6 = n2;
            while (--n6 >= 0) {
                int n7 = n3;
                while (--n7 >= 0) {
                    longMatrix3D.setQuick(n5, n6, n7, n4++);
                }
            }
        }
        return longMatrix3D;
    }

    public LongMatrix3D make(long[][][] lArray) {
        if (this == sparse) {
            return new SparseLongMatrix3D(lArray);
        }
        return new DenseLongMatrix3D(lArray);
    }

    public LongMatrix3D make(int n, int n2, int n3) {
        if (this == sparse) {
            return new SparseLongMatrix3D(n, n2, n3);
        }
        return new DenseLongMatrix3D(n, n2, n3);
    }

    public LongMatrix3D make(int n, int n2, int n3, long l) {
        return this.make(n, n2, n3).assign(l);
    }

    public LongMatrix3D random(int n, int n2, int n3) {
        return this.make(n, n2, n3).assign(LongFunctions.random());
    }
}

