/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dsi.core.impl;

import com.amazon.dsi.core.impl.DSIMessageSource;
import com.amazon.dsi.core.interfaces.IDriver;
import com.amazon.dsi.core.interfaces.IEventHandler;
import com.amazon.dsi.core.utilities.AttributeDataMap;
import com.amazon.dsi.core.utilities.Variant;
import com.amazon.dsi.exceptions.BadPropertyKeyException;
import com.amazon.dsi.exceptions.IncorrectTypeException;
import com.amazon.dsi.exceptions.NumericOverflowException;
import com.amazon.dsi.utilities.DSIMessageKey;
import com.amazon.support.IMessageSource;
import com.amazon.support.LogUtilities;
import com.amazon.support.SettingReader;
import com.amazon.support.channels.AbstractSocketChannel;
import com.amazon.support.exceptions.ErrorException;
import com.amazon.support.exceptions.ExceptionBuilder;
import com.amazon.support.exceptions.ExceptionType;
import com.amazon.support.exceptions.ExceptionUtilities;
import com.amazon.support.security.ICredentialFactory;
import com.amazon.support.security.SimbaCredentialFactory;
import java.util.Locale;

public abstract class DSIDriver
implements IDriver {
    public static final ExceptionBuilder s_DSIMessages = new ExceptionBuilder(2);
    private final AttributeDataMap m_settings = new AttributeDataMap();
    protected DSIMessageSource m_msgSrc = new DSIMessageSource(true, true);

    protected DSIDriver() throws ErrorException {
        try {
            this.loadProperties();
        }
        catch (NumericOverflowException numericOverflowException) {
            throw s_DSIMessages.createGeneralException(DSIMessageKey.PROP_NUMERIC_OVERFLOW.name(), ExceptionType.DEFAULT);
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw s_DSIMessages.createGeneralException(DSIMessageKey.PROP_VALTYPE_MISMATCH.name(), ExceptionType.DEFAULT);
        }
        this.registerMessages();
    }

    @Override
    public ICredentialFactory createCredentialFactory() {
        return new SimbaCredentialFactory(this.getDriverLog());
    }

    @Override
    public IEventHandler getEventHandler() {
        return null;
    }

    @Override
    public Locale getLocale() {
        String string = SettingReader.readSetting("DriverLocale");
        return ExceptionUtilities.createLocale(string);
    }

    @Override
    public IMessageSource getMessageSource() {
        return this.m_msgSrc;
    }

    @Override
    public Variant getProperty(int n) throws BadPropertyKeyException, ErrorException {
        LogUtilities.logFunctionEntrance(this.getDriverLog(), n);
        if (this.m_settings.isProperty(n)) {
            return this.m_settings.getProperty(n);
        }
        throw new BadPropertyKeyException(2, DSIMessageKey.INVALID_PROPKEY.name(), String.valueOf(n));
    }

    @Override
    public void deregister() {
    }

    protected void setProperty(int n, Variant variant) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getDriverLog(), n, variant);
        this.m_settings.setProperty(n, variant);
    }

    private void loadProperties() throws IncorrectTypeException, NumericOverflowException {
        this.m_settings.setProperty(1, 2, Character.valueOf('\u0000'));
        this.m_settings.setProperty(29, 3, 1L);
        this.m_settings.setProperty(28, 3, 1L);
        this.m_settings.setProperty(2, 3, 2L);
        this.m_settings.setProperty(3, 0, "");
        this.m_settings.setProperty(4, 0, "03.80");
        this.m_settings.setProperty(5, 0, "10.1.11.1090");
        this.m_settings.setProperty(6, 2, Character.valueOf('\u0000'));
        this.m_settings.setProperty(7, 6, 65532);
        this.m_settings.setProperty(9, 6, 65532);
        this.m_settings.setProperty(8, 6, 65532);
        this.m_settings.setProperty(10, 6, 1);
        this.m_settings.setProperty(11, 3, 1L);
        this.m_settings.setProperty(12, 5, (short)1);
        this.m_settings.setProperty(13, 3, 2L);
        this.m_settings.setProperty(16, 0, "1995");
        this.m_settings.setProperty(17, 3, 0L);
        this.m_settings.setProperty(18, 2, Character.valueOf('\u0002'));
        this.m_settings.setProperty(19, 4, 1024L);
        this.m_settings.setProperty(20, 3, 0L);
        this.m_settings.setProperty(21, 3, 0L);
        this.m_settings.setProperty(22, 3, 1L);
        this.m_settings.setProperty(1000, 5, (short)0);
        this.m_settings.setProperty(1001, 5, (short)0);
        this.m_settings.setProperty(1002, 5, (short)0);
        this.m_settings.setProperty(1003, 5, (short)0);
        this.m_settings.setProperty(1004, 5, (short)0);
        this.m_settings.setProperty(23, 2, Character.valueOf('P'));
        this.m_settings.setProperty(24, 0, null);
        this.m_settings.setProperty(25, 3, 0L);
        this.m_settings.setProperty(26, 3, 0L);
        this.m_settings.setProperty(27, 3, 1L);
        this.m_settings.setProperty(30, 3, 1L);
        this.m_settings.setProperty(31, 4, 0L);
        this.m_settings.setProperty(1006, 0, "");
        this.m_settings.setProperty(32, 3, 0L);
        this.m_settings.setProperty(33, 3, 0L);
        this.m_settings.setProperty(34, 3, 1L);
        this.m_settings.setProperty(35, 3, 0L);
        this.m_settings.setProperty(36, 3, 0L);
        this.m_settings.setProperty(37, 3, 0L);
        this.m_settings.setProperty(38, 3, 1L);
        this.m_settings.setProperty(39, 3, 0L);
        this.m_settings.setProperty(40, 6, 4);
    }

    private void registerMessages() {
        String string = ExceptionUtilities.getPackageName(DSIDriver.class);
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append(".");
        stringBuilder.append("DSIMessages");
        this.m_msgSrc.registerMessages(stringBuilder.toString(), 2, "JDSI");
        StringBuilder stringBuilder2 = new StringBuilder(string);
        stringBuilder2.append(".");
        stringBuilder2.append("JDBCMessages");
        this.m_msgSrc.registerMessages(stringBuilder2.toString(), 1, "JDBC");
        StringBuilder stringBuilder3 = new StringBuilder(ExceptionUtilities.getPackageName(AbstractSocketChannel.class));
        stringBuilder3.append(".");
        stringBuilder3.append("messages");
        this.m_msgSrc.registerMessages(stringBuilder3.toString(), 8, "SupportChannels");
    }
}

