/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.inference.model.GradientProvider;
import dr.inference.model.HessianProvider;
import dr.inference.model.Likelihood;
import dr.math.distributions.GaussianProcessRandomGenerator;
import dr.math.distributions.MultivariateDistribution;
import dr.math.matrixAlgebra.CholeskyDecomposition;
import dr.math.matrixAlgebra.IllegalDimension;
import dr.math.matrixAlgebra.Matrix;
import dr.math.matrixAlgebra.SymmetricMatrix;

public class OldGaussianMarkovRandomField
implements MultivariateDistribution,
GaussianProcessRandomGenerator,
GradientProvider,
HessianProvider {
    public static final String TYPE = "GaussianProcess";
    private final int dim;
    private final double incrementPrecision;
    private final double start;
    private final double[] mean;
    private final double[][] precision;
    private double[][] variance = null;
    private double[][] cholesky = null;
    private Double logDet = null;
    private static final double logNormalize = -0.5 * Math.log(Math.PI * 2);

    public OldGaussianMarkovRandomField(int n, double d, double d2) {
        int n2;
        this.dim = n;
        this.start = d2;
        this.mean = new double[n];
        for (n2 = 0; n2 < n; ++n2) {
            this.mean[n2] = d2;
        }
        this.incrementPrecision = d;
        this.precision = new double[n][n];
        this.precision[0][0] = d;
        this.precision[0][1] = -1.0 * d;
        this.precision[n - 1][n - 1] = d;
        this.precision[n - 1][n - 2] = -1.0 * d;
        for (n2 = 1; n2 < n - 1; ++n2) {
            this.precision[n2][n2] = 2.0 * d;
            this.precision[n2][n2 - 1] = -1.0 * d;
            this.precision[n2][n2 + 1] = -1.0 * d;
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public double[][] getVariance() {
        if (this.variance == null) {
            for (int i = 0; i < this.dim; ++i) {
                for (int j = 0; j < this.dim; ++j) {
                    if (j == i) {
                        this.variance[j][j] = (double)j / this.incrementPrecision;
                        continue;
                    }
                    this.variance[i][j] = (double)Math.abs(j - i) / this.incrementPrecision;
                }
            }
        }
        return this.variance;
    }

    public double[][] getCholeskyDecomposition() {
        if (this.cholesky == null) {
            this.cholesky = OldGaussianMarkovRandomField.getCholeskyDecomposition(this.getVariance());
        }
        return this.cholesky;
    }

    public double getLogDet() {
        if (this.logDet == null) {
            double d = Math.pow(this.incrementPrecision, this.dim);
            for (int i = 2; i <= this.dim; ++i) {
                d *= 2.0 - 2.0 * Math.cos((double)(i - 1) * (Math.PI / (double)this.dim));
            }
            this.logDet = Math.log(d);
        }
        return this.logDet;
    }

    private boolean isDiagonal(double[][] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = i + 1; j < dArray.length; ++j) {
                if (dArray[i][j] == 0.0) continue;
                return false;
            }
        }
        return true;
    }

    private double logDetForDiagonal(double[][] dArray) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += Math.log(dArray[i][i]);
        }
        return d;
    }

    @Override
    public double[][] getScaleMatrix() {
        return this.precision;
    }

    @Override
    public double[] getMean() {
        return this.mean;
    }

    public static double calculatePrecisionMatrixDeterminate(double[][] dArray) {
        try {
            return new Matrix(dArray).determinant();
        }
        catch (IllegalDimension illegalDimension) {
            throw new RuntimeException(illegalDimension.getMessage());
        }
    }

    @Override
    public Object nextRandom() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double logPdf(double[] dArray) {
        return OldGaussianMarkovRandomField.logPdf(dArray, this.mean, this.precision, this.getLogDet());
    }

    public double[] gradLogPdf(double[] dArray) {
        return OldGaussianMarkovRandomField.gradLogPdf(dArray, this.mean, this.precision);
    }

    public static double[] gradLogPdf(double[] dArray, double[] dArray2, double[][] dArray3) {
        int n;
        int n2 = dArray.length;
        double[] dArray4 = new double[n2];
        double[] dArray5 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray5[n] = dArray2[n] - dArray[n];
        }
        dArray4[0] = dArray3[0][0] * dArray5[0] + dArray3[0][1] * dArray5[1];
        dArray4[n2 - 1] = dArray3[n2 - 1][n2 - 2] * dArray5[n2 - 2] + dArray3[n2 - 1][n2 - 1] * dArray5[n2 - 1];
        for (n = 1; n < n2 - 1; ++n) {
            dArray4[n] = dArray3[n][n - 1] * dArray5[n - 1] + dArray3[n][n] * dArray5[n] + dArray3[n][n + 1] * dArray5[n + 1];
        }
        return dArray4;
    }

    public double[][] hessianLogPdf(double[] dArray) {
        return OldGaussianMarkovRandomField.hessianLogPdf(dArray, this.mean, this.precision);
    }

    public static double[][] hessianLogPdf(double[] dArray, double[] dArray2, double[][] dArray3) {
        int n = dArray.length;
        double[][] dArray4 = new double[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray4[i][j] = -dArray3[i][j];
            }
        }
        return dArray4;
    }

    public double[] diagonalHessianLogPdf(double[] dArray) {
        return OldGaussianMarkovRandomField.diagonalHessianLogPdf(dArray, this.mean, this.precision);
    }

    public static double[] diagonalHessianLogPdf(double[] dArray, double[] dArray2, double[][] dArray3) {
        int n = dArray.length;
        double[] dArray4 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray4[i] = -dArray3[i][i];
        }
        return dArray4;
    }

    public static double logPdf(double[] dArray, double[] dArray2, double[][] dArray3, double d) {
        if (d == Double.NEGATIVE_INFINITY) {
            return d;
        }
        int n = dArray.length;
        double[] dArray4 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray4[i] = dArray[i] - dArray2[i];
        }
        double d2 = dArray3[n - 1][n - 1] * dArray4[n - 1] * dArray4[n - 1];
        for (int i = 0; i < n - 1; ++i) {
            d2 += dArray3[i][i] * dArray4[i] * dArray4[i] + 2.0 * dArray3[i][i + 1] * dArray4[i] * dArray4[i + 1];
        }
        return (double)(n - 1) * logNormalize + 0.5 * (d - d2);
    }

    private static double[][] getInverse(double[][] dArray) {
        return new SymmetricMatrix(dArray).inverse().toComponents();
    }

    private static double[][] getCholeskyDecomposition(double[][] dArray) {
        double[][] dArray2;
        try {
            dArray2 = new CholeskyDecomposition(dArray).getL();
        }
        catch (IllegalDimension illegalDimension) {
            throw new RuntimeException("Attempted Cholesky decomposition on non-square matrix");
        }
        return dArray2;
    }

    @Override
    public double logPdf(Object object) {
        double[] dArray = (double[])object;
        return this.logPdf(dArray);
    }

    @Override
    public Likelihood getLikelihood() {
        return null;
    }

    @Override
    public int getDimension() {
        return this.mean.length;
    }

    @Override
    public double[] getGradientLogDensity(Object object) {
        return this.gradLogPdf((double[])object);
    }

    @Override
    public double[][] getPrecisionMatrix() {
        return this.precision;
    }

    @Override
    public double[] getDiagonalHessianLogDensity(Object object) {
        return this.diagonalHessianLogPdf((double[])object);
    }

    @Override
    public double[][] getHessianLogDensity(Object object) {
        return this.hessianLogPdf((double[])object);
    }
}

