/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.bigfasttree.ghosttree;

import dr.evolution.tree.FlexibleNode;
import dr.evolution.tree.FlexibleTree;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.util.Taxon;
import dr.evolution.util.TaxonList;
import dr.evomodel.bigfasttree.BigFastTreeModel;
import dr.evomodel.bigfasttree.ghosttree.CorporealTreeModel;
import dr.util.Citation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class GhostTreeModel
extends BigFastTreeModel {
    public static final String GHOST_TREE_MODEL = "ghostTreeModel";
    private final List<Taxon> ghostLineages;
    private CorporealTreeModel corporealTreeModel;
    private final boolean[] updatedNodes;
    private boolean seenRoot = false;
    Queue<Integer> availableNodeNumbers = new LinkedList<Integer>();
    private int[] corporealToGhostNodeMap;
    private int[] storedCorporealToGhostNodeMap;
    private int[] ghostToCorporealNodeMap;
    private int[] storedGhostToCorporealNodeMap;
    private int[] ghostToNextOfKinMap;
    private int[] storedGhostToNextOfKinMap;

    public GhostTreeModel(Tree tree, TaxonList taxonList) {
        this(GHOST_TREE_MODEL, tree, taxonList);
    }

    public GhostTreeModel(String string, Tree tree, TaxonList taxonList) {
        super(string, tree, false, false);
        this.ghostLineages = taxonList.asList();
        this.corporealToGhostNodeMap = new int[2 * (super.getExternalNodeCount() - taxonList.getTaxonCount()) - 1];
        this.storedCorporealToGhostNodeMap = new int[2 * (super.getExternalNodeCount() - taxonList.getTaxonCount()) - 1];
        this.ghostToCorporealNodeMap = new int[super.getNodeCount()];
        this.storedGhostToCorporealNodeMap = new int[super.getNodeCount()];
        this.ghostToNextOfKinMap = new int[super.getNodeCount()];
        this.storedGhostToNextOfKinMap = new int[super.getNodeCount()];
        for (int i = 0; i < super.getNodeCount(); ++i) {
            this.ghostToCorporealNodeMap[i] = -1;
            this.ghostToNextOfKinMap[i] = -1;
        }
        this.createCorporealTree();
        this.updatedNodes = new boolean[super.getNodeCount()];
        Arrays.fill(this.updatedNodes, false);
    }

    protected void updateNode(NodeRef nodeRef) {
        NodeRef nodeRef2;
        int n;
        this.updatedNodes[nodeRef.getNumber()] = true;
        if (!super.isExternal(nodeRef) && (n = this.ghostToCorporealNodeMap[nodeRef.getNumber()]) > -1) {
            this.availableNodeNumbers.add(n);
            this.ghostToCorporealNodeMap[nodeRef.getNumber()] = -1;
            this.corporealToGhostNodeMap[n] = -1;
        }
        if ((nodeRef2 = super.getParent(nodeRef)) != null && !this.updatedNodes[nodeRef2.getNumber()]) {
            this.updateNode(nodeRef2);
        }
    }

    protected void updateAllNodes() {
        for (int i = 0; i < super.getNodeCount(); ++i) {
            this.updatedNodes[i] = true;
        }
        this.availableNodeNumbers = IntStream.range(this.getExternalNodeCount(), this.getNodeCount()).boxed().collect(Collectors.toCollection(LinkedList::new));
    }

    private NodeRef getSpectralCounterPart(NodeRef nodeRef) {
        return super.getNode(this.corporealToGhostNodeMap[nodeRef.getNumber()]);
    }

    public NodeRef getCorporealCounterPart(NodeRef nodeRef) {
        int n = this.ghostToCorporealNodeMap[nodeRef.getNumber()];
        if (n == -1) {
            return null;
        }
        return this.corporealTreeModel.getNode(n);
    }

    public NodeRef getNextCorporealDescendent(NodeRef nodeRef) {
        if (this.hasCorporealCounterPart(nodeRef)) {
            throw new IllegalArgumentException("Expected a node with degree 0 or 1 in corporeal tree but found degree 2");
        }
        int n = this.ghostToNextOfKinMap[nodeRef.getNumber()];
        return n == -1 ? null : super.getNode(n);
    }

    public boolean hasCorporealCounterPart(NodeRef nodeRef) {
        return this.ghostToCorporealNodeMap[nodeRef.getNumber()] != -1;
    }

    private List<NodeRef> getDescendentsInCorporealTree(NodeRef nodeRef) {
        ArrayList<NodeRef> arrayList = new ArrayList<NodeRef>();
        for (int i = 0; i < super.getChildCount(nodeRef); ++i) {
            NodeRef nodeRef2 = super.getChild(nodeRef, i);
            if (super.isExternal(nodeRef2)) {
                if (this.ghostToCorporealNodeMap[nodeRef2.getNumber()] <= -1) continue;
                arrayList.add(nodeRef2);
                continue;
            }
            List<NodeRef> list = this.getDescendentsInCorporealTree(nodeRef2);
            if (list.size() == 2) {
                arrayList.add(nodeRef2);
                continue;
            }
            if (list.size() != 1) continue;
            arrayList.addAll(list);
        }
        return arrayList;
    }

    @Override
    protected void storeState() {
        super.storeState();
        System.arraycopy(this.corporealToGhostNodeMap, 0, this.storedCorporealToGhostNodeMap, 0, this.corporealToGhostNodeMap.length);
        System.arraycopy(this.ghostToCorporealNodeMap, 0, this.storedGhostToCorporealNodeMap, 0, this.ghostToCorporealNodeMap.length);
        System.arraycopy(this.ghostToNextOfKinMap, 0, this.storedGhostToNextOfKinMap, 0, this.ghostToNextOfKinMap.length);
    }

    @Override
    protected void restoreState() {
        super.restoreState();
        int[] nArray = this.storedCorporealToGhostNodeMap;
        this.storedCorporealToGhostNodeMap = this.corporealToGhostNodeMap;
        this.corporealToGhostNodeMap = nArray;
        int[] nArray2 = this.storedGhostToCorporealNodeMap;
        this.storedGhostToCorporealNodeMap = this.ghostToCorporealNodeMap;
        this.ghostToCorporealNodeMap = nArray2;
        int[] nArray3 = this.storedGhostToNextOfKinMap;
        this.storedGhostToNextOfKinMap = this.ghostToNextOfKinMap;
        this.ghostToNextOfKinMap = nArray3;
    }

    @Override
    public void setRoot(NodeRef nodeRef) {
        super.setRoot(nodeRef);
        this.updateNode(nodeRef);
    }

    @Override
    public void addChild(NodeRef nodeRef, NodeRef nodeRef2) {
        super.addChild(nodeRef, nodeRef2);
        this.updateNode(nodeRef2);
    }

    @Override
    public void removeChild(NodeRef nodeRef, NodeRef nodeRef2) {
        this.updateNode(nodeRef2);
        super.removeChild(nodeRef, nodeRef2);
    }

    @Override
    public boolean beginTreeEdit() {
        return super.beginTreeEdit();
    }

    @Override
    public void endTreeEdit() {
        super.endTreeEdit();
        this.updateCorporealTreeModel();
    }

    @Override
    public void setNodeHeight(NodeRef nodeRef, double d) {
        super.setNodeHeight(nodeRef, d);
        if (this.hasCorporealCounterPart(nodeRef)) {
            this.corporealTreeModel.adjustNodeHeight(this.getCorporealCounterPart(nodeRef), d);
        }
    }

    @Override
    public void setNodeHeightQuietly(NodeRef nodeRef, double d) {
        super.setNodeHeightQuietly(nodeRef, d);
        if (this.hasCorporealCounterPart(nodeRef)) {
            this.corporealTreeModel.adjustNodeHeightQuietly(this.getSpectralCounterPart(nodeRef), d);
        }
    }

    @Override
    public void setNodeRate(NodeRef nodeRef, double d) {
        throw new UnsupportedOperationException("Function not available in GhostTreeModel");
    }

    @Override
    public void setNodeTrait(NodeRef nodeRef, String string, double d) {
        throw new UnsupportedOperationException("Function not available in GhostTreeModel");
    }

    @Override
    public void setMultivariateTrait(NodeRef nodeRef, String string, double[] dArray) {
        throw new UnsupportedOperationException("Function not available in GhostTreeModel");
    }

    private void updateCorporealTreeModel() {
        NodeRef nodeRef;
        this.corporealTreeModel.beginTreeEdit();
        List<NodeRef> list = this.updateCorporealTreeModel(super.getRoot());
        if (list.size() == 2) {
            nodeRef = this.getCorporealCounterPart(super.getRoot());
        } else if (list.size() == 1) {
            nodeRef = this.getCorporealCounterPart(list.get(0));
        } else {
            throw new RuntimeException("Ghost tree root is out of sync. Root should be degree 1 or 2 in corporeal tree");
        }
        if (nodeRef != this.corporealTreeModel.getRoot()) {
            this.corporealTreeModel.makeRoot(nodeRef);
        }
        this.corporealTreeModel.endTreeEdit();
    }

    private List<NodeRef> updateCorporealTreeModel(NodeRef nodeRef) {
        ArrayList<NodeRef> arrayList = new ArrayList<NodeRef>();
        if (this.updatedNodes[nodeRef.getNumber()]) {
            NodeRef nodeRef2;
            for (int i = 0; i < super.getChildCount(nodeRef); ++i) {
                nodeRef2 = super.getChild(nodeRef, i);
                if (super.isExternal(nodeRef2)) {
                    if (this.ghostToCorporealNodeMap[nodeRef2.getNumber()] <= -1) continue;
                    arrayList.add(nodeRef2);
                    continue;
                }
                List<NodeRef> list = this.updateCorporealTreeModel(nodeRef2);
                if (list.size() == 2) {
                    arrayList.add(nodeRef2);
                    continue;
                }
                if (list.size() != 1) continue;
                arrayList.addAll(list);
            }
            if (arrayList.size() == 0) {
                this.ghostToNextOfKinMap[nodeRef.getNumber()] = -1;
            } else if (arrayList.size() == 1) {
                this.ghostToNextOfKinMap[nodeRef.getNumber()] = arrayList.get(0).getNumber();
            } else if (arrayList.size() == 2) {
                Integer n = this.availableNodeNumbers.poll();
                this.updateNodeMaps(nodeRef.getNumber(), n);
                nodeRef2 = this.corporealTreeModel.getNode(n);
                boolean bl = false;
                List list = arrayList.stream().map(this::getCorporealCounterPart).collect(Collectors.toList());
                ArrayList<NodeRef> arrayList2 = new ArrayList<NodeRef>();
                for (int i = 0; i < this.corporealTreeModel.getChildCount(nodeRef2); ++i) {
                    arrayList2.add(this.corporealTreeModel.getChild(nodeRef2, i));
                }
                for (NodeRef nodeRef3 : arrayList2) {
                    if (list.contains(nodeRef3)) continue;
                    this.corporealTreeModel.disownChild(nodeRef2, nodeRef3);
                    bl = true;
                }
                for (NodeRef nodeRef3 : list) {
                    if (arrayList2.contains(nodeRef3)) continue;
                    NodeRef nodeRef4 = this.corporealTreeModel.getParent(nodeRef3);
                    if (nodeRef4 != null) {
                        this.corporealTreeModel.disownChild(nodeRef4, nodeRef3);
                    }
                    this.corporealTreeModel.adoptChild(nodeRef2, nodeRef3);
                    bl = true;
                }
                if (this.corporealTreeModel.getNodeHeight(nodeRef2) != super.getNodeHeight(nodeRef) || bl) {
                    this.corporealTreeModel.adjustNodeHeight(nodeRef2, super.getNodeHeight(nodeRef));
                }
            }
        } else if (this.hasCorporealCounterPart(nodeRef)) {
            arrayList.add(nodeRef);
        } else {
            NodeRef nodeRef5 = this.getNextCorporealDescendent(nodeRef);
            if (nodeRef5 != null) {
                arrayList.add(nodeRef5);
            }
        }
        this.updatedNodes[nodeRef.getNumber()] = false;
        return arrayList;
    }

    private void updateNodeMaps(int n, int n2) {
        this.ghostToCorporealNodeMap[n] = n2;
        this.corporealToGhostNodeMap[n2] = n;
    }

    private void createCorporealTree() {
        Object object;
        int n;
        HashMap<NodeRef, NodeRef> hashMap = new HashMap<NodeRef, NodeRef>();
        FlexibleNode flexibleNode = this.createCorporealTree(this.getRoot(), hashMap);
        FlexibleTree flexibleTree = new FlexibleTree(flexibleNode);
        flexibleTree.adoptTreeModelOrdering();
        this.corporealTreeModel = new CorporealTreeModel(this.getModelName() + "CorporealTree", flexibleTree, this);
        for (Map.Entry entry : hashMap.entrySet()) {
            n = ((NodeRef)entry.getKey()).getNumber();
            this.ghostToCorporealNodeMap[n] = object = ((NodeRef)entry.getValue()).getNumber();
            this.corporealToGhostNodeMap[object] = n;
        }
        Object object2 = this.corporealToGhostNodeMap;
        int n2 = ((Object)object2).length;
        for (n = 0; n < n2; ++n) {
            object = object2[n];
            NodeRef nodeRef = super.getNode((int)object);
            NodeRef nodeRef2 = super.getParent(nodeRef);
            while (nodeRef2 != null && !this.hasCorporealCounterPart(nodeRef2)) {
                this.ghostToNextOfKinMap[nodeRef2.getNumber()] = object;
                nodeRef = nodeRef2;
                nodeRef2 = super.getParent(nodeRef);
            }
        }
    }

    private FlexibleNode createCorporealTree(NodeRef nodeRef, Map<NodeRef, NodeRef> map) {
        if (this.isExternal(nodeRef)) {
            if (this.ghostLineages.contains(this.getNodeTaxon(nodeRef))) {
                return null;
            }
            FlexibleNode flexibleNode = new FlexibleNode(this.getNodeTaxon(nodeRef));
            flexibleNode.setHeight(this.getNodeHeight(nodeRef));
            map.put(nodeRef, flexibleNode);
            return flexibleNode;
        }
        ArrayList<FlexibleNode> arrayList = new ArrayList<FlexibleNode>();
        for (int i = 0; i < this.getChildCount(nodeRef); ++i) {
            FlexibleNode flexibleNode = this.createCorporealTree(this.getChild(nodeRef, i), map);
            if (flexibleNode == null) continue;
            arrayList.add(flexibleNode);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        if (arrayList.size() == 1) {
            return (FlexibleNode)arrayList.get(0);
        }
        FlexibleNode flexibleNode = new FlexibleNode();
        flexibleNode.setHeight(this.getNodeHeight(nodeRef));
        for (FlexibleNode flexibleNode2 : arrayList) {
            flexibleNode2.setParent(flexibleNode);
            flexibleNode.addChild(flexibleNode2);
        }
        map.put(nodeRef, flexibleNode);
        return flexibleNode;
    }

    public CorporealTreeModel getCorporealTreeModel() {
        return this.corporealTreeModel;
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.EMPTY_LIST;
    }
}

