/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.wrightfisher;

import dr.evolution.wrightfisher.Mutation;
import dr.evolution.wrightfisher.Mutator;
import dr.math.MathUtils;
import dr.math.Poisson;

public class SimpleMutator
extends Mutator {
    double muRate = 0.01;
    double poissonMean = -1.0;
    int genomeLength = -1;
    int stateSize = 2;

    public SimpleMutator(double d, int n) {
        this.stateSize = n;
        this.muRate = d;
    }

    @Override
    public Mutation[] mutate(byte[] byArray, byte[] byArray2) {
        if (this.genomeLength != byArray.length) {
            this.genomeLength = byArray.length;
            this.poissonMean = (double)this.genomeLength * this.muRate;
        }
        int n = Poisson.nextPoisson(this.poissonMean);
        Mutation[] mutationArray = new Mutation[n];
        System.arraycopy(byArray, 0, byArray2, 0, this.genomeLength);
        for (int i = 0; i < n; ++i) {
            int n2 = MathUtils.nextInt(this.genomeLength);
            byte by = (byte)MathUtils.nextInt(this.stateSize - 1);
            if (by == byArray[i]) {
                by = (byte)((by + 1) % this.stateSize);
            }
            byArray2[n2] = by;
            mutationArray[i] = new Mutation(n2, by);
        }
        return mutationArray;
    }
}

