/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.regsarima.regular;

import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.regression.ITsVariable;
import jdplus.toolkit.base.api.timeseries.regression.PeriodicContrasts;
import jdplus.toolkit.base.core.arima.estimation.IArimaMapping;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.modelling.regression.Regression;
import jdplus.toolkit.base.core.regarima.RegArimaEstimation;
import jdplus.toolkit.base.core.regarima.RegArimaModel;
import jdplus.toolkit.base.core.regsarima.GlsSarimaComputer;
import jdplus.toolkit.base.core.regsarima.regular.ModelDescription;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import jdplus.toolkit.base.core.stats.linearmodel.JointTest;

public class SeasonalFTest {
    private RegArimaModel<SarimaModel> regarima;
    private RegArimaEstimation<SarimaModel> seasonalModel;
    private StatisticalTest ftest;
    private int nseas;

    public boolean test(TsData s) {
        this.clear();
        RegArimaModel.Builder builder = this.prepareSeasonalModel(s);
        this.addSeasonalDummies(builder, s.getDomain());
        if (!this.estimateModel()) {
            return false;
        }
        return this.computeStatistics();
    }

    public boolean test(ModelDescription m) {
        this.clear();
        RegArimaModel.Builder builder = this.prepareSeasonalModel(ModelDescription.copyOf(m));
        this.addSeasonalDummies(builder, m.getEstimationDomain());
        if (!this.estimateModel()) {
            return false;
        }
        return this.computeStatistics();
    }

    public RegArimaEstimation<SarimaModel> getEstimatedModel() {
        return this.seasonalModel;
    }

    public StatisticalTest getFTest() {
        return this.ftest;
    }

    private RegArimaModel.Builder prepareSeasonalModel(TsData input) {
        int period = input.getAnnualFrequency();
        SarimaOrders rspec = SarimaOrders.m011((int)period);
        SarimaModel arima = SarimaModel.builder(rspec).build();
        return RegArimaModel.builder().y(input.getValues()).arima(arima).meanCorrection(true);
    }

    private RegArimaModel.Builder prepareSeasonalModel(ModelDescription m) {
        SarimaOrders rspec = m.specification();
        rspec.setBd(0);
        rspec.setBp(0);
        rspec.setBq(0);
        m.setSpecification(rspec);
        return m.regarima().toBuilder().meanCorrection(true);
    }

    private void addSeasonalDummies(RegArimaModel.Builder builder, TsDomain domain) {
        PeriodicContrasts dummies = new PeriodicContrasts(domain.getAnnualFrequency());
        FastMatrix x = Regression.matrix(domain, new ITsVariable[]{dummies});
        builder.addX(x);
        this.regarima = builder.build();
        this.nseas = dummies.dim();
    }

    private boolean estimateModel() {
        GlsSarimaComputer processor = GlsSarimaComputer.builder().build();
        this.seasonalModel = processor.process(this.regarima, (IArimaMapping<SarimaModel>)null);
        return this.seasonalModel != null;
    }

    private boolean computeStatistics() {
        try {
            int nvars = this.regarima.getVariablesCount();
            int np = this.regarima.arima().orders().getParametersCount();
            this.ftest = new JointTest(this.seasonalModel.getConcentratedLikelihood()).variableSelection(nvars - this.nseas, this.nseas).hyperParametersCount(np).build();
            return true;
        }
        catch (Exception err) {
            return false;
        }
    }

    private void clear() {
        this.regarima = null;
        this.seasonalModel = null;
        this.ftest = null;
    }
}

