/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.core.arima;

import java.util.function.IntToDoubleFunction;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.arima.estimation.ArmaFilter;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.data.LogSign;
import jdplus.toolkit.base.core.math.linearfilters.SymmetricFilter;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.MatrixException;

public class AnsleyFilter
implements ArmaFilter {
    private FastMatrix L;
    private double[] ar;
    private double[] ma;
    private double var;
    private int n;

    public double[] filter(DoubleSeq y) {
        double[] e = y.toArray();
        int p = this.ar.length - 1;
        int q = this.ma.length - 1;
        if (p == 0 && q == 0) {
            if (this.var != 1.0) {
                double std = Math.sqrt(this.var);
                int i = 0;
                while (i < e.length) {
                    int n = i++;
                    e[n] = e[n] / std;
                }
            }
            return e;
        }
        if (p > 0) {
            int i = e.length - 1;
            while (i >= p) {
                double s = 0.0;
                for (int j = 1; j <= p; ++j) {
                    s += this.ar[j] * e[i - j];
                }
                int n = i--;
                e[n] = e[n] + s;
            }
        }
        this.rsolve(e);
        return e;
    }

    @Override
    public void apply(DoubleSeq y, DataBlock yf) {
        double[] e = this.filter(y);
        yf.copyFrom(e, 0);
    }

    @Override
    public double getLogDeterminant() {
        if (this.L == null) {
            return (double)this.n * Math.log(this.var);
        }
        DataBlock diag = this.L.row(0);
        return 2.0 * LogSign.of((DoubleSeq)diag).getValue();
    }

    @Override
    public int prepare(IArimaModel arima, int n) {
        this.n = n;
        this.L = null;
        this.ar = arima.getAr().asPolynomial().toArray();
        this.var = arima.getInnovationVariance();
        this.ma = arima.getMa().asPolynomial().toArray();
        int p = this.ar.length - 1;
        int q = this.ma.length - 1;
        if (p == 0 && q == 0) {
            return n;
        }
        int r = Math.max(p, q + 1);
        double[] cov = null;
        double[] dcov = null;
        if (p > 0) {
            cov = arima.getAutoCovarianceFunction().values(r);
            double[] psi = arima.getPsiWeights().getWeights(q);
            dcov = new double[r];
            for (int i = 1; i <= q; ++i) {
                double v = this.ma[i];
                for (int j = i + 1; j <= q; ++j) {
                    v += this.ma[j] * psi[j - i];
                }
                dcov[i] = v * this.var;
            }
        }
        IntToDoubleFunction sma = SymmetricFilter.convolutionOf(arima.getMa(), this.var).weights();
        this.L = FastMatrix.make(r, n);
        DataBlockIterator cols = this.L.columnsIterator();
        for (int j = 0; j < p; ++j) {
            int i;
            DataBlock col = cols.next();
            for (i = 0; i < p - j; ++i) {
                col.set(i, cov[i]);
            }
            for (i = p - j; i < r; ++i) {
                col.set(i, dcov[i]);
            }
        }
        FastMatrix M = this.L.extract(0, q + 1, p, n - p);
        DataBlockIterator rows = M.rowsIterator();
        int pos = 0;
        while (rows.hasNext()) {
            double s = sma.applyAsDouble(pos++);
            DataBlock row = rows.next();
            if (s == 0.0) continue;
            row.set(s);
        }
        this.lcholesky();
        return n;
    }

    private void lcholesky() {
        int r = this.L.getRowsCount();
        double[] data = this.L.getStorage();
        if (r == 1) {
            for (int i = 0; i < data.length; ++i) {
                if (data[i] <= 0.0) {
                    throw new MatrixException("m_err_chol");
                }
                data[i] = Math.sqrt(data[i]);
            }
        } else {
            int dr = r - 1;
            int drr = dr * dr;
            int i = 0;
            int idiag = 0;
            while (i < this.n) {
                int rcur;
                double aii = data[idiag];
                int rmin = idiag - drr;
                if (rmin < 0) {
                    rmin = 0;
                }
                for (rcur = idiag - dr; rcur >= rmin; rcur -= dr) {
                    double x = data[rcur];
                    if (x == 0.0) continue;
                    aii -= x * x;
                }
                if (aii <= 0.0) {
                    throw new MatrixException("m_err_chol");
                }
                data[idiag] = aii = Math.sqrt(aii);
                rcur = idiag - dr;
                int k = i + r - 1;
                while (rcur >= rmin) {
                    double x = data[rcur];
                    if (x != 0.0) {
                        int q = Math.min(k, this.n) - i;
                        int iy = idiag + 1;
                        for (int ia = rcur + 1; ia < rcur + q; ++ia) {
                            int n = iy++;
                            data[n] = data[n] - x * data[ia];
                        }
                    }
                    rcur -= dr;
                    --k;
                }
                int ymax = r * (i + 1);
                int iy = idiag + 1;
                while (iy < ymax) {
                    int n = iy++;
                    data[n] = data[n] / aii;
                }
                ++i;
                idiag += r;
            }
        }
    }

    private void rsolve(double[] b) {
        int i;
        int r = this.L.getRowsCount();
        double[] data = this.L.getStorage();
        int nb = b.length;
        for (i = 0; i < nb && b[i] == 0.0; ++i) {
        }
        int idx = i * r;
        while (i < nb) {
            double t = b[i] / data[idx];
            int jmax = Math.min(r, this.n - i);
            int j = 1;
            int k = idx + 1;
            while (j < jmax) {
                int n = i + j;
                b[n] = b[n] - t * data[k];
                ++j;
                ++k;
            }
            b[i] = t;
            ++i;
            idx += r;
        }
    }

    public FastMatrix getCholeskyFactor() {
        if (this.L == null) {
            FastMatrix l = FastMatrix.make(1, this.n);
            l.set(Math.sqrt(this.var));
            return l;
        }
        return this.L;
    }
}

