/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.solver;

import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DenseDoubleAlgebra;
import cern.colt.matrix.tdouble.algo.solver.AbstractDoubleIterativeSolver;
import cern.colt.matrix.tdouble.algo.solver.CGLSDoubleIterationMonitor;
import cern.colt.matrix.tdouble.algo.solver.IterativeSolverDoubleNotConvergedException;
import cern.colt.matrix.tdouble.algo.solver.preconditioner.DoubleIdentity;
import cern.jet.math.tdouble.DoubleFunctions;

public class DoubleCGLS
extends AbstractDoubleIterativeSolver {
    private static final DenseDoubleAlgebra alg = DenseDoubleAlgebra.DEFAULT;
    public static final double sqrteps = Math.sqrt(Math.pow(2.0, -52.0));

    public DoubleCGLS() {
        this.iter = new CGLSDoubleIterationMonitor();
        ((CGLSDoubleIterationMonitor)this.iter).setRelativeTolerance(-1.0);
    }

    public DoubleMatrix1D solve(DoubleMatrix2D doubleMatrix2D, DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) throws IterativeSolverDoubleNotConvergedException {
        double d;
        double d2 = 0.0;
        if (((CGLSDoubleIterationMonitor)this.iter).getRelativeTolerance() == -1.0) {
            ((CGLSDoubleIterationMonitor)this.iter).setRelativeTolerance(sqrteps * alg.norm2(doubleMatrix2D.zMult(doubleMatrix1D, null, 1.0, 0.0, true)));
        }
        DoubleMatrix1D doubleMatrix1D3 = doubleMatrix2D.zMult(doubleMatrix1D2, null);
        doubleMatrix1D3.assign(doubleMatrix1D, DoubleFunctions.plusMultFirst(-1.0));
        DoubleMatrix1D doubleMatrix1D4 = doubleMatrix2D.zMult(doubleMatrix1D3, null, 1.0, 0.0, true);
        double d3 = alg.norm2(doubleMatrix1D4);
        if (!(this.M instanceof DoubleIdentity)) {
            doubleMatrix1D4 = this.M.transApply(doubleMatrix1D4, null);
            d = alg.norm2(doubleMatrix1D4);
            d *= d;
        } else {
            d = d3;
            d *= d;
        }
        DoubleMatrix1D doubleMatrix1D5 = doubleMatrix1D4.copy();
        this.iter.setFirst();
        while (!this.iter.converged(d3, doubleMatrix1D2)) {
            DoubleMatrix1D doubleMatrix1D6;
            if (!this.iter.isFirst()) {
                double d4 = d / d2;
                doubleMatrix1D5.assign(doubleMatrix1D4, DoubleFunctions.plusMultFirst(d4));
            }
            if (!(this.M instanceof DoubleIdentity)) {
                doubleMatrix1D4 = this.M.apply(doubleMatrix1D5, null);
                doubleMatrix1D6 = doubleMatrix2D.zMult(doubleMatrix1D4, null);
            } else {
                doubleMatrix1D6 = doubleMatrix2D.zMult(doubleMatrix1D5, null);
            }
            double d5 = alg.norm2(doubleMatrix1D6);
            d5 *= d5;
            double d6 = d / d5;
            if (!(this.M instanceof DoubleIdentity)) {
                doubleMatrix1D2.assign(doubleMatrix1D4, DoubleFunctions.plusMultSecond(d6));
            } else {
                doubleMatrix1D2.assign(doubleMatrix1D5, DoubleFunctions.plusMultSecond(d6));
            }
            doubleMatrix1D3.assign(doubleMatrix1D6, DoubleFunctions.plusMultSecond(-d6));
            doubleMatrix1D4 = doubleMatrix2D.zMult(doubleMatrix1D3, null, 1.0, 0.0, true);
            d3 = alg.norm2(doubleMatrix1D4);
            if (!(this.M instanceof DoubleIdentity)) {
                doubleMatrix1D4 = this.M.transApply(doubleMatrix1D4, null);
                d2 = d;
                d = alg.norm2(doubleMatrix1D4);
                d *= d;
            } else {
                d2 = d;
                d = d3;
                d *= d;
            }
            this.iter.next();
        }
        return doubleMatrix1D2;
    }
}

