;; Fitting common example dataset from:
;; Grasela and Donn (1985), Developmental 
;; Pharmacology and Therapeutics, 8, 374-383.
;; Description: Reparameterized final model
$PROB PPK Model for Phenobarbitol in neonates

$INPUT
ID TIME AMT WT APGR DV MDV EVID
$DATA data.csv IGNORE=@
$SUBROUTINE ADVAN1 TRANS2 

$PK
TVCL = THETA(1)*WT
MU_1 = LOG(TVCL)
CL = EXP(MU_1 + ETA(1))

TVV = THETA(2)*WT
MU_2 = LOG(TVV)
V = EXP(MU_2 + ETA(2))

S1 = V
RUVADD = THETA(3)

$ERROR
IPRED = F
 
W = RUVADD
 
Y =  IPRED+W*EPS(1)
IRES = DV - IPRED
IWRES = IRES/W

$THETA
(0, 0.01) ; CLpkg
(0, 1) ; Vpkg
(0, 0.1) ; RUVADD

$OMEGA BLOCK(2)
1 ; IIVCL
0.1 1 ; IIVV

$SIGMA
1 FIX

$ESTIMATION METH=SAEM INTER NBURN=10000 NITER=1000 ISAMPLE=5 IACCEPT=0.3 CINTERVAL=25 CTYPE=3 NOABORT PRINT=100
$ESTIMATION METH=IMP INTER PRINT=1 NITER=25 ISAMPLE=10000 EONLY=1 IACCEPT=0.3  MAPITER=0
$COV	PRINT=E UNCONDITIONAL

; Monolithic table
$TAB ID TIME AMT WT APGR MDV EVID IPRED IRES IWRES
	 CL V ETAS(1:LAST) 
	 PRED CRES CWRES NPDE NOPRINT FORMAT=s1PE13.7 
	 FILE=run16tab