/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.regsarima.regular;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.api.arima.SarimaSpec;
import jdplus.toolkit.base.api.data.DoubleList;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.regression.AdditiveOutlier;
import jdplus.toolkit.base.api.timeseries.regression.IEasterVariable;
import jdplus.toolkit.base.api.timeseries.regression.ILengthOfPeriodVariable;
import jdplus.toolkit.base.api.timeseries.regression.ITradingDaysVariable;
import jdplus.toolkit.base.api.timeseries.regression.LevelShift;
import jdplus.toolkit.base.api.timeseries.regression.PeriodicOutlier;
import jdplus.toolkit.base.api.timeseries.regression.TransitoryChange;
import jdplus.toolkit.base.api.timeseries.regression.Variable;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModel;
import jdplus.toolkit.base.core.stats.tests.LjungBox;

public class RegSarimaReport {
    private final int period;
    private final DoubleList ljungBox = new DoubleList();
    private final Map<SarimaOrders, Integer> arima = new HashMap<SarimaOrders, Integer>();
    private int Total;
    private int NUndecompsable;
    private int TdCount;
    private int LogCount;
    private int LpCount;
    private int EasterCount;
    private int AoCount;
    private int LsCount;
    private int TcCount;
    private int SoCount;
    private int MeanCount;
    private long T0;
    private long T1;

    public int getTotal() {
        return this.Total;
    }

    public int getNUndecompsable() {
        return this.NUndecompsable;
    }

    public int getTdCount() {
        return this.TdCount;
    }

    public int getLogCount() {
        return this.LogCount;
    }

    public int getLpCount() {
        return this.LpCount;
    }

    public int getEasterCount() {
        return this.EasterCount;
    }

    public int getAoCount() {
        return this.AoCount;
    }

    public int getLsCount() {
        return this.LsCount;
    }

    public int getTcCount() {
        return this.TcCount;
    }

    public int getSoCount() {
        return this.SoCount;
    }

    public int getMeanCount() {
        return this.MeanCount;
    }

    public long getT0() {
        return this.T0;
    }

    public long getT1() {
        return this.T1;
    }

    public RegSarimaReport(int freq) {
        this.period = freq;
    }

    public int getFrequency() {
        return this.period;
    }

    public SarimaOrders[] getModels() {
        SarimaOrders[] m = (SarimaOrders[])this.arima.keySet().stream().toArray(SarimaOrders[]::new);
        return m;
    }

    public int getModelCount(SarimaOrders spec) {
        int n = 0;
        try {
            n = this.arima.get(spec);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    public void start() {
        this.clear();
        this.T0 = System.currentTimeMillis();
    }

    protected void clear() {
        this.ljungBox.clear();
        this.Total = 0;
        this.TdCount = 0;
        this.LpCount = 0;
        this.EasterCount = 0;
        this.LogCount = 0;
        this.AoCount = 0;
        this.LsCount = 0;
        this.TcCount = 0;
        this.SoCount = 0;
        this.MeanCount = 0;
    }

    public void end() {
        this.T1 = System.currentTimeMillis();
    }

    public boolean add(RegSarimaModel mdl) {
        if (mdl != null) {
            ++this.Total;
            try {
                Variable[] variables = mdl.getDescription().getVariables();
                this.addArima(mdl.getDescription().getStochasticComponent());
                this.addTransform(mdl.getDescription().isLogTransformation());
                this.addCalendar(variables);
                this.addOutliers(variables);
                this.addStats(mdl);
                return true;
            }
            catch (Exception err) {
                return false;
            }
        }
        return false;
    }

    private void addArima(SarimaSpec arima) {
        SarimaOrders spec = arima.orders();
        Integer count = this.arima.get(spec);
        if (count == null) {
            this.arima.put(spec, 1);
        } else {
            this.arima.put(spec, count + 1);
        }
    }

    private void addStats(RegSarimaModel mdl) {
        TsData res = mdl.fullResiduals();
        if (res == null) {
            return;
        }
        try {
            StatisticalTest lb = new LjungBox(res.getValues()).hyperParametersCount(mdl.freeArimaParametersCount()).autoCorrelationsCount(LjungBox.defaultAutoCorrelationsCount(this.period)).build();
            this.ljungBox.add(lb.getValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addCalendar(Variable[] vars) {
        int ntd = Arrays.stream(vars).filter(var -> var.getCore() instanceof ITradingDaysVariable).mapToInt(var -> var.dim()).sum();
        int nlp = (int)Arrays.stream(vars).filter(var -> var.getCore() instanceof ILengthOfPeriodVariable).count();
        int nee = (int)Arrays.stream(vars).filter(var -> var.getCore() instanceof IEasterVariable).count();
        if (ntd > 0) {
            ++this.TdCount;
        }
        if (nlp > 0) {
            ++this.LpCount;
        }
        if (nee > 0) {
            ++this.EasterCount;
        }
    }

    private void addOutliers(Variable[] vars) {
        this.AoCount = (int)((long)this.AoCount + Arrays.stream(vars).filter(var -> var.getCore() instanceof AdditiveOutlier).count());
        this.LsCount = (int)((long)this.LsCount + Arrays.stream(vars).filter(var -> var.getCore() instanceof LevelShift).count());
        this.TcCount = (int)((long)this.TcCount + Arrays.stream(vars).filter(var -> var.getCore() instanceof TransitoryChange).count());
        this.SoCount = (int)((long)this.SoCount + Arrays.stream(vars).filter(var -> var.getCore() instanceof PeriodicOutlier).count());
    }

    private void addTransform(boolean multiplicative) {
        if (multiplicative) {
            ++this.LogCount;
        }
    }
}

